/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.TransportException;

public class ActionTransportException
extends TransportException {
    private TransportAddress address;
    private String action;

    public ActionTransportException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ActionTransportException(String name, TransportAddress address, String action, Throwable cause) {
        super(ActionTransportException.buildMessage(name, address, action, null), cause);
        this.address = address;
        this.action = action;
    }

    public ActionTransportException(String name, TransportAddress address, String action, String msg, Throwable cause) {
        super(ActionTransportException.buildMessage(name, address, action, msg), cause);
        this.address = address;
        this.action = action;
    }

    public TransportAddress address() {
        return this.address;
    }

    public String action() {
        return this.action;
    }

    private static String buildMessage(String name, TransportAddress address, String action, String msg) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append('[').append(name).append(']');
        }
        if (address != null) {
            sb.append('[').append(address).append(']');
        }
        if (action != null) {
            sb.append('[').append(action).append(']');
        }
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }
}

