/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.util.List;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.docset.DocSetCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsContext;
import org.elasticsearch.search.fetch.partial.PartialFieldsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.scan.ScanContext;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public abstract class SearchContext
implements Releasable {
    private static ThreadLocal<SearchContext> current = new ThreadLocal();

    public static void setCurrent(SearchContext value) {
        current.set(value);
        QueryParseContext.setTypes(value.types());
    }

    public static void removeCurrent() {
        current.remove();
        QueryParseContext.removeTypes();
    }

    public static SearchContext current() {
        return current.get();
    }

    public abstract boolean clearAndRelease();

    public abstract void preProcess();

    public abstract Filter searchFilter(String[] var1);

    public abstract long id();

    public abstract String source();

    public abstract ShardSearchRequest request();

    public abstract SearchType searchType();

    public abstract SearchContext searchType(SearchType var1);

    public abstract SearchShardTarget shardTarget();

    public abstract int numberOfShards();

    public abstract boolean hasTypes();

    public abstract String[] types();

    public abstract float queryBoost();

    public abstract SearchContext queryBoost(float var1);

    public abstract long nowInMillis();

    public abstract Scroll scroll();

    public abstract SearchContext scroll(Scroll var1);

    public abstract SearchContextAggregations aggregations();

    public abstract SearchContext aggregations(SearchContextAggregations var1);

    public abstract SearchContextFacets facets();

    public abstract SearchContext facets(SearchContextFacets var1);

    public abstract SearchContextHighlight highlight();

    public abstract void highlight(SearchContextHighlight var1);

    public abstract SuggestionSearchContext suggest();

    public abstract void suggest(SuggestionSearchContext var1);

    public abstract RescoreSearchContext rescore();

    public abstract void rescore(RescoreSearchContext var1);

    public abstract boolean hasFieldDataFields();

    public abstract FieldDataFieldsContext fieldDataFields();

    public abstract boolean hasScriptFields();

    public abstract ScriptFieldsContext scriptFields();

    public abstract boolean hasPartialFields();

    public abstract PartialFieldsContext partialFields();

    public abstract boolean sourceRequested();

    public abstract boolean hasFetchSourceContext();

    public abstract FetchSourceContext fetchSourceContext();

    public abstract SearchContext fetchSourceContext(FetchSourceContext var1);

    public abstract ContextIndexSearcher searcher();

    public abstract IndexShard indexShard();

    public abstract MapperService mapperService();

    public abstract AnalysisService analysisService();

    public abstract IndexQueryParserService queryParserService();

    public abstract SimilarityService similarityService();

    public abstract ScriptService scriptService();

    public abstract CacheRecycler cacheRecycler();

    public abstract PageCacheRecycler pageCacheRecycler();

    public abstract FilterCache filterCache();

    public abstract DocSetCache docSetCache();

    public abstract IndexFieldDataService fieldData();

    public abstract IdCache idCache();

    public abstract long timeoutInMillis();

    public abstract void timeoutInMillis(long var1);

    public abstract SearchContext minimumScore(float var1);

    public abstract Float minimumScore();

    public abstract SearchContext sort(Sort var1);

    public abstract Sort sort();

    public abstract SearchContext trackScores(boolean var1);

    public abstract boolean trackScores();

    public abstract SearchContext parsedPostFilter(ParsedFilter var1);

    public abstract ParsedFilter parsedPostFilter();

    public abstract Filter aliasFilter();

    public abstract SearchContext parsedQuery(ParsedQuery var1);

    public abstract ParsedQuery parsedQuery();

    public abstract Query query();

    public abstract boolean queryRewritten();

    public abstract SearchContext updateRewriteQuery(Query var1);

    public abstract int from();

    public abstract SearchContext from(int var1);

    public abstract int size();

    public abstract SearchContext size(int var1);

    public abstract boolean hasFieldNames();

    public abstract List<String> fieldNames();

    public abstract void emptyFieldNames();

    public abstract boolean explain();

    public abstract void explain(boolean var1);

    @Nullable
    public abstract List<String> groupStats();

    public abstract void groupStats(List<String> var1);

    public abstract boolean version();

    public abstract void version(boolean var1);

    public abstract int[] docIdsToLoad();

    public abstract int docIdsToLoadFrom();

    public abstract int docIdsToLoadSize();

    public abstract SearchContext docIdsToLoad(int[] var1, int var2, int var3);

    public abstract void accessed(long var1);

    public abstract long lastAccessTime();

    public abstract long keepAlive();

    public abstract void keepAlive(long var1);

    public abstract SearchLookup lookup();

    public abstract DfsSearchResult dfsResult();

    public abstract QuerySearchResult queryResult();

    public abstract FetchSearchResult fetchResult();

    public abstract void addReleasable(Releasable var1);

    public abstract void clearReleasables();

    public abstract ScanContext scanContext();

    public abstract MapperService.SmartNameFieldMappers smartFieldMappers(String var1);

    public abstract FieldMappers smartNameFieldMappers(String var1);

    public abstract FieldMapper smartNameFieldMapper(String var1);

    public abstract MapperService.SmartNameObjectMapper smartNameObjectMapper(String var1);
}

