/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatterStreams;

public class InternalAvg
extends MetricsAggregation.SingleValue
implements Avg {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("avg");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalAvg readResult(StreamInput in) throws IOException {
            InternalAvg result = new InternalAvg();
            result.readFrom(in);
            return result;
        }
    };
    private double sum;
    private long count;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalAvg() {
    }

    public InternalAvg(String name, double sum, long count) {
        super(name);
        this.sum = sum;
        this.count = count;
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / (double)this.count;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAvg reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            return (InternalAvg)aggregations.get(0);
        }
        InternalAvg reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            if (reduced == null) {
                reduced = (InternalAvg)aggregation;
                continue;
            }
            reduced.count += ((InternalAvg)aggregation).count;
            reduced.sum += ((InternalAvg)aggregation).sum;
        }
        return reduced;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.sum = in.readDouble();
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.sum);
        out.writeVLong(this.count);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(InternalAggregation.CommonFields.VALUE, this.count != 0L ? Double.valueOf(this.getValue()) : null);
        if (this.count != 0L && this.valueFormatter != null) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.getValue()));
        }
        builder.endObject();
        return builder;
    }
}

