/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class AvgAggregator
extends MetricsAggregator.SingleValue {
    private final NumericValuesSource valuesSource;
    private LongArray counts;
    private DoubleArray sums;

    public AvgAggregator(String name, long estimatedBucketsCount, NumericValuesSource valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.counts = BigArrays.newLongArray(initialSize, context.pageCacheRecycler(), true);
            this.sums = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (this.valuesSource != null) : "if value source is null, collect should never be called";
        DoubleValues values = this.valuesSource.doubleValues();
        if (values == null) {
            return;
        }
        this.counts = BigArrays.grow(this.counts, owningBucketOrdinal + 1L);
        this.sums = BigArrays.grow(this.sums, owningBucketOrdinal + 1L);
        int valueCount = values.setDocument(doc);
        this.counts.increment(owningBucketOrdinal, valueCount);
        double sum = 0.0;
        for (int i = 0; i < valueCount; ++i) {
            sum += values.nextValue();
        }
        this.sums.increment(owningBucketOrdinal, sum);
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null || owningBucketOrdinal >= this.counts.size()) {
            return new InternalAvg(this.name, 0.0, 0L);
        }
        return new InternalAvg(this.name, this.sums.get(owningBucketOrdinal), this.counts.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.counts, this.sums);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<NumericValuesSource> {
        public Factory(String name, String type, ValuesSourceConfig<NumericValuesSource> valuesSourceConfig) {
            super(name, type, valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new AvgAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new AvgAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

