/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewaySnapshotFailedException;
import org.elasticsearch.index.gateway.RecoveryStatus;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.Translog;

public interface IndexShardGateway
extends IndexShardComponent,
CloseableIndexComponent {
    public static final SnapshotLock NO_SNAPSHOT_LOCK = new SnapshotLock(){

        @Override
        public void release() {
        }
    };

    public String type();

    public RecoveryStatus recoveryStatus();

    public SnapshotStatus lastSnapshotStatus();

    public SnapshotStatus currentSnapshotStatus();

    public void recover(boolean var1, RecoveryStatus var2) throws IndexShardGatewayRecoveryException;

    public SnapshotStatus snapshot(Snapshot var1) throws IndexShardGatewaySnapshotFailedException;

    public boolean requiresSnapshot();

    public boolean requiresSnapshotScheduling();

    public SnapshotLock obtainSnapshotLock() throws Exception;

    public static class Snapshot {
        private final SnapshotIndexCommit indexCommit;
        private final Translog.Snapshot translogSnapshot;
        private final long lastIndexVersion;
        private final long lastTranslogId;
        private final long lastTranslogLength;
        private final int lastTotalTranslogOperations;

        public Snapshot(SnapshotIndexCommit indexCommit, Translog.Snapshot translogSnapshot, long lastIndexVersion, long lastTranslogId, long lastTranslogLength, int lastTotalTranslogOperations) {
            this.indexCommit = indexCommit;
            this.translogSnapshot = translogSnapshot;
            this.lastIndexVersion = lastIndexVersion;
            this.lastTranslogId = lastTranslogId;
            this.lastTranslogLength = lastTranslogLength;
            this.lastTotalTranslogOperations = lastTotalTranslogOperations;
        }

        public boolean indexChanged() {
            return this.lastIndexVersion != this.indexCommit.getGeneration();
        }

        public boolean newTranslogCreated() {
            return this.translogSnapshot.translogId() != this.lastTranslogId;
        }

        public boolean sameTranslogNewOperations() {
            if (this.newTranslogCreated()) {
                throw new ElasticsearchIllegalStateException("Should not be called when there is a new translog");
            }
            return this.translogSnapshot.length() > this.lastTranslogLength;
        }

        public SnapshotIndexCommit indexCommit() {
            return this.indexCommit;
        }

        public Translog.Snapshot translogSnapshot() {
            return this.translogSnapshot;
        }

        public long lastIndexVersion() {
            return this.lastIndexVersion;
        }

        public long lastTranslogId() {
            return this.lastTranslogId;
        }

        public long lastTranslogLength() {
            return this.lastTranslogLength;
        }

        public int lastTotalTranslogOperations() {
            return this.lastTotalTranslogOperations;
        }
    }

    public static interface SnapshotLock {
        public void release();
    }
}

