/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;

public final class UTF8Writer
extends Writer {
    static final int SURR1_FIRST = 55296;
    static final int SURR1_LAST = 56319;
    static final int SURR2_FIRST = 56320;
    static final int SURR2_LAST = 57343;
    private static final int DEFAULT_BUFFER_SIZE = 8000;
    protected static final ThreadLocal<SoftReference<byte[][]>> _bufferRecycler = new ThreadLocal();
    protected final byte[][] _bufferHolder;
    private OutputStream _out;
    private byte[] _outBuffer;
    private final int _outBufferEnd;
    private int _outPtr;
    int _surrogate = 0;

    public UTF8Writer(OutputStream outputStream) {
        this._out = outputStream;
        this._bufferHolder = UTF8Writer._findBufferHolder();
        byte[] byArray = this._bufferHolder[0];
        if (byArray == null) {
            byArray = new byte[8000];
            this._bufferHolder[0] = byArray;
        }
        this._outBuffer = byArray;
        this._outBufferEnd = this._outBuffer.length - 4;
        this._outPtr = 0;
    }

    private static byte[][] _findBufferHolder() {
        Object object = null;
        SoftReference<byte[][]> softReference = _bufferRecycler.get();
        if (softReference != null) {
            object = softReference.get();
        }
        if (object == null) {
            object = new byte[1][];
            _bufferRecycler.set(new SoftReference<byte[][]>((byte[][])object));
        }
        return object;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this._out != null) {
            if (this._outPtr > 0) {
                this._out.write(this._outBuffer, 0, this._outPtr);
                this._outPtr = 0;
            }
            OutputStream outputStream = this._out;
            this._out = null;
            byte[] byArray = this._outBuffer;
            if (byArray != null) {
                this._outBuffer = null;
                this._bufferHolder[0] = byArray;
            }
            outputStream.close();
            int n = this._surrogate;
            this._surrogate = 0;
            if (n > 0) {
                this.throwIllegal(n);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._out != null) {
            if (this._outPtr > 0) {
                this._out.write(this._outBuffer, 0, this._outPtr);
                this._outPtr = 0;
            }
            this._out.flush();
        }
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1[var2_2]);
            }
            return;
        }
        if (this._surrogate > 0) {
            var4_4 = var1_1[var2_2++];
            --var3_3;
            this.write(this.convertSurrogate(var4_4));
        }
        var4_4 = this._outPtr;
        var5_5 = this._outBuffer;
        var6_6 = this._outBufferEnd;
        var3_3 += var2_2;
        block0: while (var2_2 < var3_3) {
            if (var4_4 >= var6_6) {
                this._out.write(var5_5, 0, var4_4);
                var4_4 = 0;
            }
            if ((var7_7 = var1_1[var2_2++]) >= 128) ** GOTO lbl28
            var5_5[var4_4++] = (byte)var7_7;
            var8_8 = var3_3 - var2_2;
            var9_9 = var6_6 - var4_4;
            if (var8_8 > var9_9) {
                var8_8 = var9_9;
            }
            var8_8 += var2_2;
            while (var2_2 < var8_8) {
                if ((var7_7 = var1_1[var2_2++]) < 128) {
                    var5_5[var4_4++] = (byte)var7_7;
                    continue;
                }
lbl28:
                // 3 sources

                if (var7_7 < 2048) {
                    var5_5[var4_4++] = (byte)(192 | var7_7 >> 6);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 < 55296 || var7_7 > 57343) {
                    var5_5[var4_4++] = (byte)(224 | var7_7 >> 12);
                    var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 > 56319) {
                    this._outPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                this._surrogate = var7_7;
                if (var2_2 >= var3_3) break block0;
                if ((var7_7 = this.convertSurrogate(var1_1[var2_2++])) > 0x10FFFF) {
                    this._outPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                var5_5[var4_4++] = (byte)(240 | var7_7 >> 18);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 12 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                continue block0;
            }
        }
        this._outPtr = var4_4;
    }

    @Override
    public void write(int n) throws IOException {
        if (this._surrogate > 0) {
            n = this.convertSurrogate(n);
        } else if (n >= 55296 && n <= 57343) {
            if (n > 56319) {
                this.throwIllegal(n);
            }
            this._surrogate = n;
            return;
        }
        if (this._outPtr >= this._outBufferEnd) {
            this._out.write(this._outBuffer, 0, this._outPtr);
            this._outPtr = 0;
        }
        if (n < 128) {
            this._outBuffer[this._outPtr++] = (byte)n;
        } else {
            int n2 = this._outPtr;
            if (n < 2048) {
                this._outBuffer[n2++] = (byte)(0xC0 | n >> 6);
                this._outBuffer[n2++] = (byte)(0x80 | n & 0x3F);
            } else if (n <= 65535) {
                this._outBuffer[n2++] = (byte)(0xE0 | n >> 12);
                this._outBuffer[n2++] = (byte)(0x80 | n >> 6 & 0x3F);
                this._outBuffer[n2++] = (byte)(0x80 | n & 0x3F);
            } else {
                if (n > 0x10FFFF) {
                    this.throwIllegal(n);
                }
                this._outBuffer[n2++] = (byte)(0xF0 | n >> 18);
                this._outBuffer[n2++] = (byte)(0x80 | n >> 12 & 0x3F);
                this._outBuffer[n2++] = (byte)(0x80 | n >> 6 & 0x3F);
                this._outBuffer[n2++] = (byte)(0x80 | n & 0x3F);
            }
            this._outPtr = n2;
        }
    }

    @Override
    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(String var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1.charAt(var2_2));
            }
            return;
        }
        if (this._surrogate > 0) {
            var4_4 = var1_1.charAt(var2_2++);
            --var3_3;
            this.write(this.convertSurrogate(var4_4));
        }
        var4_4 = this._outPtr;
        var5_5 = this._outBuffer;
        var6_6 = this._outBufferEnd;
        var3_3 += var2_2;
        block0: while (var2_2 < var3_3) {
            if (var4_4 >= var6_6) {
                this._out.write(var5_5, 0, var4_4);
                var4_4 = 0;
            }
            if ((var7_7 = var1_1.charAt(var2_2++)) >= 128) ** GOTO lbl28
            var5_5[var4_4++] = (byte)var7_7;
            var8_8 = var3_3 - var2_2;
            var9_9 = var6_6 - var4_4;
            if (var8_8 > var9_9) {
                var8_8 = var9_9;
            }
            var8_8 += var2_2;
            while (var2_2 < var8_8) {
                if ((var7_7 = (int)var1_1.charAt(var2_2++)) < 128) {
                    var5_5[var4_4++] = (byte)var7_7;
                    continue;
                }
lbl28:
                // 3 sources

                if (var7_7 < 2048) {
                    var5_5[var4_4++] = (byte)(192 | var7_7 >> 6);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 < 55296 || var7_7 > 57343) {
                    var5_5[var4_4++] = (byte)(224 | var7_7 >> 12);
                    var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 > 56319) {
                    this._outPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                this._surrogate = var7_7;
                if (var2_2 >= var3_3) break block0;
                if ((var7_7 = this.convertSurrogate(var1_1.charAt(var2_2++))) > 0x10FFFF) {
                    this._outPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                var5_5[var4_4++] = (byte)(240 | var7_7 >> 18);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 12 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                continue block0;
            }
        }
        this._outPtr = var4_4;
    }

    private int convertSurrogate(int n) throws IOException {
        int n2 = this._surrogate;
        this._surrogate = 0;
        if (n < 56320 || n > 57343) {
            throw new IOException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n) + "; illegal combination");
        }
        return 65536 + (n2 - 55296 << 10) + (n - 56320);
    }

    private void throwIllegal(int n) throws IOException {
        if (n > 0x10FFFF) {
            throw new IOException("Illegal character point (0x" + Integer.toHexString(n) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n >= 55296) {
            if (n <= 56319) {
                throw new IOException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n) + ")");
            }
            throw new IOException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n) + ")");
        }
        throw new IOException("Illegal character point (0x" + Integer.toHexString(n) + ") to output");
    }
}

