/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import java.io.IOException;
import org.elasticsearch.common.geo.builders.PointCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MultiPointBuilder
extends PointCollection<MultiPointBuilder> {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTIPOINT;

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", MultiPointBuilder.TYPE.shapename);
        builder.field("coordinates");
        super.coordinatesToXcontent(builder, false);
        builder.endObject();
        return builder;
    }

    @Override
    public Shape build() {
        MultiPoint geometry = FACTORY.createMultiPoint(this.points.toArray(new Coordinate[this.points.size()]));
        return new JtsGeometry((Geometry)geometry, SPATIAL_CONTEXT, true);
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }
}

