/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ReplicaAfterPrimaryActiveAllocationDecider
extends AllocationDecider {
    @Inject
    public ReplicaAfterPrimaryActiveAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            return allocation.decision(Decision.YES, "shard is primary", new Object[0]);
        }
        MutableShardRouting primary = allocation.routingNodes().activePrimary(shardRouting);
        if (primary == null) {
            return allocation.decision(Decision.NO, "primary shard is not yet active", new Object[0]);
        }
        return allocation.decision(Decision.YES, "primary is already active", new Object[0]);
    }
}

