/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class NodesOperationResponse<NodeResponse extends NodeOperationResponse>
extends ActionResponse
implements Iterable<NodeResponse> {
    private ClusterName clusterName;
    protected NodeResponse[] nodes;
    private Map<String, NodeResponse> nodesMap;

    protected NodesOperationResponse() {
    }

    protected NodesOperationResponse(ClusterName clusterName, NodeResponse[] nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterNameAsString() {
        return this.clusterName.value();
    }

    public NodeResponse[] getNodes() {
        return this.nodes;
    }

    public NodeResponse getAt(int position) {
        return this.nodes[position];
    }

    @Override
    public Iterator<NodeResponse> iterator() {
        return this.getNodesMap().values().iterator();
    }

    public Map<String, NodeResponse> getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = Maps.newHashMap();
            for (NodeResponse nodeResponse : this.nodes) {
                this.nodesMap.put(((NodeOperationResponse)nodeResponse).getNode().id(), nodeResponse);
            }
        }
        return this.nodesMap;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = ClusterName.readClusterName(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
    }
}

