/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.facet.Facet;

public interface TermsStatsFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "terms_stats";

    public long getMissingCount();

    public List<? extends Entry> getEntries();

    public static interface Entry
    extends Comparable<Entry> {
        public Text getTerm();

        public Number getTermAsNumber();

        public long getCount();

        public long getTotalCount();

        public double getMin();

        public double getMax();

        public double getTotal();

        public double getMean();
    }

    public static enum ComparatorType {
        COUNT(0, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int i;
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int n = o2.getCount() < o1.getCount() ? -1 : (i = o1.getCount() == o2.getCount() ? 0 : 1);
                if (i == 0) {
                    i = o2.compareTo(o1);
                }
                return i;
            }
        }),
        REVERSE_COUNT(1, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -COUNT.comparator().compare(o1, o2);
            }
        }),
        TERM(2, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i = o1.compareTo(o2);
                if (i == 0) {
                    i = COUNT.comparator().compare(o1, o2);
                }
                return i;
            }
        }),
        REVERSE_TERM(3, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -TERM.comparator().compare(o1, o2);
            }
        }),
        TOTAL(4, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i = -Double.compare(o1.getTotal(), o2.getTotal());
                if (i == 0) {
                    i = COUNT.comparator().compare(o1, o2);
                }
                return i;
            }
        }),
        REVERSE_TOTAL(5, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -TOTAL.comparator().compare(o1, o2);
            }
        }),
        MIN(6, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i = Double.compare(o1.getMin(), o2.getMin());
                if (i == 0) {
                    i = COUNT.comparator().compare(o1, o2);
                }
                return i;
            }
        }),
        REVERSE_MIN(7, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -MIN.comparator().compare(o1, o2);
            }
        }),
        MAX(8, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i = -Double.compare(o1.getMax(), o2.getMax());
                if (i == 0) {
                    i = COUNT.comparator().compare(o1, o2);
                }
                return i;
            }
        }),
        REVERSE_MAX(9, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -MAX.comparator().compare(o1, o2);
            }
        }),
        MEAN(10, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i = -Double.compare(o1.getMean(), o2.getMean());
                if (i == 0) {
                    i = COUNT.comparator().compare(o1, o2);
                }
                return i;
            }
        }),
        REVERSE_MEAN(11, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -MEAN.comparator().compare(o1, o2);
            }
        });

        private final byte id;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id, Comparator<Entry> comparator) {
            this.id = id;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id) {
            if (id == COUNT.id()) {
                return COUNT;
            }
            if (id == REVERSE_COUNT.id()) {
                return REVERSE_COUNT;
            }
            if (id == TERM.id()) {
                return TERM;
            }
            if (id == REVERSE_TERM.id()) {
                return REVERSE_TERM;
            }
            if (id == TOTAL.id()) {
                return TOTAL;
            }
            if (id == REVERSE_TOTAL.id()) {
                return REVERSE_TOTAL;
            }
            if (id == MIN.id()) {
                return MIN;
            }
            if (id == REVERSE_MIN.id()) {
                return REVERSE_MIN;
            }
            if (id == MAX.id()) {
                return MAX;
            }
            if (id == REVERSE_MAX.id()) {
                return REVERSE_MAX;
            }
            if (id == MEAN.id()) {
                return MEAN;
            }
            if (id == REVERSE_MEAN.id()) {
                return REVERSE_MEAN;
            }
            throw new ElasticsearchIllegalArgumentException("No type argument match for terms facet comparator [" + id + "]");
        }

        public static ComparatorType fromString(String type) {
            if ("count".equals(type)) {
                return COUNT;
            }
            if ("term".equals(type)) {
                return TERM;
            }
            if ("reverse_count".equals(type) || "reverseCount".equals(type)) {
                return REVERSE_COUNT;
            }
            if ("reverse_term".equals(type) || "reverseTerm".equals(type)) {
                return REVERSE_TERM;
            }
            if ("total".equals(type)) {
                return TOTAL;
            }
            if ("reverse_total".equals(type) || "reverseTotal".equals(type)) {
                return REVERSE_TOTAL;
            }
            if ("min".equals(type)) {
                return MIN;
            }
            if ("reverse_min".equals(type) || "reverseMin".equals(type)) {
                return REVERSE_MIN;
            }
            if ("max".equals(type)) {
                return MAX;
            }
            if ("reverse_max".equals(type) || "reverseMax".equals(type)) {
                return REVERSE_MAX;
            }
            if ("mean".equals(type)) {
                return MEAN;
            }
            if ("reverse_mean".equals(type) || "reverseMean".equals(type)) {
                return REVERSE_MEAN;
            }
            throw new ElasticsearchIllegalArgumentException("No type argument match for terms stats facet comparator [" + type + "]");
        }
    }
}

