/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.FacetBuilder;

public class RangeScriptFacetBuilder
extends FacetBuilder {
    private String lang;
    private String keyScript;
    private String valueScript;
    private Map<String, Object> params;
    private List<Entry> entries = Lists.newArrayList();

    public RangeScriptFacetBuilder(String name) {
        super(name);
    }

    public RangeScriptFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public RangeScriptFacetBuilder keyScript(String keyScript) {
        this.keyScript = keyScript;
        return this;
    }

    public RangeScriptFacetBuilder valueScript(String valueScript) {
        this.valueScript = valueScript;
        return this;
    }

    public RangeScriptFacetBuilder param(String name, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value);
        return this;
    }

    public RangeScriptFacetBuilder addRange(double from, double to) {
        this.entries.add(new Entry(from, to));
        return this;
    }

    public RangeScriptFacetBuilder addUnboundedTo(double from) {
        this.entries.add(new Entry(from, Double.POSITIVE_INFINITY));
        return this;
    }

    public RangeScriptFacetBuilder addUnboundedFrom(double to) {
        this.entries.add(new Entry(Double.NEGATIVE_INFINITY, to));
        return this;
    }

    @Override
    public RangeScriptFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public RangeScriptFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public RangeScriptFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyScript == null) {
            throw new SearchSourceBuilderException("key_script must be set on range script facet for facet [" + this.name + "]");
        }
        if (this.valueScript == null) {
            throw new SearchSourceBuilderException("value_script must be set on range script facet for facet [" + this.name + "]");
        }
        if (this.entries.isEmpty()) {
            throw new SearchSourceBuilderException("at least one range must be defined for range facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("range");
        builder.field("key_script", this.keyScript);
        builder.field("value_script", this.valueScript);
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        builder.startArray("ranges");
        for (Entry entry : this.entries) {
            builder.startObject();
            if (!Double.isInfinite(entry.from)) {
                builder.field("from", entry.from);
            }
            if (!Double.isInfinite(entry.to)) {
                builder.field("to", entry.to);
            }
            builder.endObject();
        }
        builder.endArray();
        if (this.params != null) {
            builder.field("params", this.params);
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }

    private static class Entry {
        final double from;
        final double to;

        private Entry(double from, double to) {
            this.from = from;
            this.to = to;
        }
    }
}

