/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptHistogramFacetExecutor
extends FacetExecutor {
    final SearchScript keyScript;
    final SearchScript valueScript;
    final long interval;
    private final HistogramFacet.ComparatorType comparatorType;
    final Recycler.V<LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry>> entries;

    public ScriptHistogramFacetExecutor(String scriptLang, String keyScript, String valueScript, Map<String, Object> params, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.keyScript = context.scriptService().search(context.lookup(), scriptLang, keyScript, params);
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        this.interval = interval > 0L ? interval : 0L;
        this.comparatorType = comparatorType;
        this.entries = context.cacheRecycler().longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector(this.entries.v());
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullHistogramFacet.FullEntry> entries1 = new ArrayList<InternalFullHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            InternalFullHistogramFacet.FullEntry value = (InternalFullHistogramFacet.FullEntry)values[i];
            entries1.add(value);
        }
        this.entries.release();
        return new InternalFullHistogramFacet(facetName, this.comparatorType, entries1);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }

    class Collector
    extends FacetExecutor.Collector {
        final LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries;

        Collector(LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries) {
            this.entries = entries;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            ScriptHistogramFacetExecutor.this.keyScript.setScorer(scorer);
            ScriptHistogramFacetExecutor.this.valueScript.setScorer(scorer);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            ScriptHistogramFacetExecutor.this.keyScript.setNextReader(context);
            ScriptHistogramFacetExecutor.this.valueScript.setNextReader(context);
        }

        public void collect(int doc) throws IOException {
            ScriptHistogramFacetExecutor.this.keyScript.setNextDocId(doc);
            ScriptHistogramFacetExecutor.this.valueScript.setNextDocId(doc);
            long bucket = ScriptHistogramFacetExecutor.this.interval == 0L ? ScriptHistogramFacetExecutor.this.keyScript.runAsLong() : ScriptHistogramFacetExecutor.bucket(ScriptHistogramFacetExecutor.this.keyScript.runAsDouble(), ScriptHistogramFacetExecutor.this.interval);
            double value = ScriptHistogramFacetExecutor.this.valueScript.runAsDouble();
            InternalFullHistogramFacet.FullEntry entry = this.entries.get(bucket);
            if (entry == null) {
                entry = new InternalFullHistogramFacet.FullEntry(bucket, 1L, value, value, 1L, value);
                this.entries.put(bucket, entry);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += value;
                if (value < entry.min) {
                    entry.min = value;
                }
                if (value > entry.max) {
                    entry.max = value;
                }
            }
        }

        @Override
        public void postCollection() {
        }
    }
}

