/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.facet.FacetParseElement;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetParsers;
import org.elasticsearch.search.facet.FacetPhase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacetParser;
import org.elasticsearch.search.facet.filter.FilterFacetParser;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetParser;
import org.elasticsearch.search.facet.histogram.HistogramFacetParser;
import org.elasticsearch.search.facet.query.QueryFacetParser;
import org.elasticsearch.search.facet.range.RangeFacetParser;
import org.elasticsearch.search.facet.statistical.StatisticalFacetParser;
import org.elasticsearch.search.facet.terms.TermsFacetParser;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacetParser;

public class FacetModule
extends AbstractModule {
    private List<Class<? extends FacetParser>> processors = Lists.newArrayList();

    public FacetModule() {
        this.processors.add(FilterFacetParser.class);
        this.processors.add(QueryFacetParser.class);
        this.processors.add(GeoDistanceFacetParser.class);
        this.processors.add(HistogramFacetParser.class);
        this.processors.add(DateHistogramFacetParser.class);
        this.processors.add(RangeFacetParser.class);
        this.processors.add(StatisticalFacetParser.class);
        this.processors.add(TermsFacetParser.class);
        this.processors.add(TermsStatsFacetParser.class);
    }

    public void addFacetProcessor(Class<? extends FacetParser> facetProcessor) {
        this.processors.add(facetProcessor);
    }

    @Override
    protected void configure() {
        Multibinder<FacetParser> multibinder = Multibinder.newSetBinder(this.binder(), FacetParser.class);
        for (Class<? extends FacetParser> processor : this.processors) {
            multibinder.addBinding().to(processor);
        }
        this.bind(FacetParsers.class).asEagerSingleton();
        this.bind(FacetParseElement.class).asEagerSingleton();
        this.bind(FacetPhase.class).asEagerSingleton();
    }
}

