/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.LongHash;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;

public class HistogramAggregator
extends BucketsAggregator {
    private final NumericValuesSource valuesSource;
    private final Rounding rounding;
    private final InternalOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final InternalHistogram.Factory histogramFactory;
    private final LongHash bucketOrds;
    private LongValues values;

    public HistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, InternalOrder order, boolean keyed, long minDocCount, @Nullable NumericValuesSource valuesSource, long initialCapacity, InternalHistogram.Factory<?> histogramFactory, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, initialCapacity, aggregationContext, parent);
        this.valuesSource = valuesSource;
        this.rounding = rounding;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.histogramFactory = histogramFactory;
        this.bucketOrds = new LongHash(initialCapacity, aggregationContext.pageCacheRecycler());
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        LongValues values = this.valuesSource.longValues();
        int valuesCount = values.setDocument(doc);
        long previousKey = Long.MIN_VALUE;
        for (int i = 0; i < valuesCount; ++i) {
            long value = values.nextValue();
            long key = this.rounding.round(value);
            assert (key >= previousKey);
            if (key == previousKey) continue;
            long bucketOrd = this.bucketOrds.add(key);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
            }
            this.collectBucket(doc, bucketOrd);
            previousKey = key;
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        ArrayList buckets = new ArrayList((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.capacity(); ++i) {
            long ord = this.bucketOrds.id(i);
            if (ord < 0L) continue;
            buckets.add(this.histogramFactory.createBucket(this.bucketOrds.key(i), this.bucketDocCount(ord), this.bucketAggregations(ord), this.valuesSource.formatter()));
        }
        CollectionUtil.introSort(buckets, this.order.comparator());
        ValueFormatter formatter = this.valuesSource != null ? this.valuesSource.formatter() : null;
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations()) : null;
        return this.histogramFactory.create(this.name, buckets, this.order, this.minDocCount, emptyBucketInfo, formatter, this.keyed);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        ValueFormatter formatter = this.valuesSource != null ? this.valuesSource.formatter() : null;
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations()) : null;
        return this.histogramFactory.create(this.name, Collections.emptyList(), this.order, this.minDocCount, emptyBucketInfo, formatter, this.keyed);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.bucketOrds);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory<NumericValuesSource> {
        private final Rounding rounding;
        private final InternalOrder order;
        private final boolean keyed;
        private final long minDocCount;
        private final InternalHistogram.Factory<?> histogramFactory;

        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valueSourceConfig, Rounding rounding, InternalOrder order, boolean keyed, long minDocCount, InternalHistogram.Factory<?> histogramFactory) {
            super(name, histogramFactory.type(), valueSourceConfig);
            this.rounding = rounding;
            this.order = order;
            this.keyed = keyed;
            this.minDocCount = minDocCount;
            this.histogramFactory = histogramFactory;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new HistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, null, 0L, this.histogramFactory, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new HistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, valuesSource, 50L, this.histogramFactory, aggregationContext, parent);
        }
    }
}

