/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.util.Collection;
import java.util.Comparator;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregation;

public interface MultiBucketsAggregation
extends Aggregation {
    public Collection<? extends Bucket> getBuckets();

    public <B extends Bucket> B getBucketByKey(String var1);

    public static interface Bucket {
        public String getKey();

        public Text getKeyAsText();

        public long getDocCount();

        public Aggregations getAggregations();

        public static class SubAggregationComparator<B extends Bucket>
        implements Comparator<B> {
            private final String aggName;
            private final String valueName;
            private final boolean asc;

            public SubAggregationComparator(String expression, boolean asc) {
                this.asc = asc;
                int i = expression.indexOf(46);
                if (i < 0) {
                    this.aggName = expression;
                    this.valueName = null;
                } else {
                    this.aggName = expression.substring(0, i);
                    this.valueName = expression.substring(i + 1);
                }
            }

            public SubAggregationComparator(String aggName, String valueName, boolean asc) {
                this.aggName = aggName;
                this.valueName = valueName;
                this.asc = asc;
            }

            public boolean asc() {
                return this.asc;
            }

            public String aggName() {
                return this.aggName;
            }

            public String valueName() {
                return this.valueName;
            }

            @Override
            public int compare(B b1, B b2) {
                double v1 = this.value(b1);
                double v2 = this.value(b2);
                return this.asc ? Double.compare(v1, v2) : Double.compare(v2, v1);
            }

            private double value(B bucket) {
                MetricsAggregation aggregation = (MetricsAggregation)bucket.getAggregations().get(this.aggName);
                if (aggregation == null) {
                    throw new ElasticsearchIllegalArgumentException("Unknown aggregation named [" + this.aggName + "]");
                }
                if (aggregation instanceof MetricsAggregation.SingleValue) {
                    return ((MetricsAggregation.SingleValue)aggregation).value();
                }
                if (aggregation instanceof MetricsAggregation.MultiValue) {
                    if (this.valueName == null) {
                        throw new ElasticsearchIllegalArgumentException("Cannot sort on multi valued aggregation [" + this.aggName + "]. A value name is required");
                    }
                    return ((MetricsAggregation.MultiValue)aggregation).value(this.valueName);
                }
                throw new ElasticsearchIllegalArgumentException("A mal attempt to sort terms by aggregation [" + aggregation.getName() + "]. Terms can only be ordered by either standard order or direct calc aggregators of the terms");
            }
        }
    }
}

