/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.template.put;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestPutIndexTemplateAction
extends BaseRestHandler {
    @Inject
    public RestPutIndexTemplateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/_template/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_template/{name}", new CreateHandler());
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        PutIndexTemplateRequest putRequest = new PutIndexTemplateRequest(request.param("name"));
        putRequest.listenerThreaded(false);
        putRequest.template(request.param("template", putRequest.template()));
        putRequest.order(request.paramAsInt("order", putRequest.order()));
        putRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putRequest.masterNodeTimeout()));
        try {
            putRequest.create(request.paramAsBoolean("create", false));
            putRequest.cause(request.param("cause", ""));
            putRequest.source(request.content());
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send response", e1, new Object[0]);
            }
            return;
        }
        this.client.admin().indices().putTemplate(putRequest, new AcknowledgedRestResponseActionListener<PutIndexTemplateResponse>(request, channel, this.logger));
    }

    final class CreateHandler
    implements RestHandler {
        CreateHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            request.params().put("create", "true");
            RestPutIndexTemplateAction.this.handleRequest(request, channel);
        }
    }
}

