/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.network;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class NetworkInfo
implements Streamable,
Serializable,
ToXContent {
    public static final Interface NA_INTERFACE = new Interface();
    long refreshInterval;
    Interface primary = NA_INTERFACE;

    public long refreshInterval() {
        return this.refreshInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public Interface primaryInterface() {
        return this.primary;
    }

    public Interface getPrimaryInterface() {
        return this.primaryInterface();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.NETWORK);
        builder.field(Fields.REFRESH_INTERVAL, this.refreshInterval);
        if (this.primary != NA_INTERFACE) {
            builder.startObject(Fields.PRIMARY_INTERFACE);
            builder.field(Fields.ADDRESS, this.primary.address());
            builder.field(Fields.NAME, this.primary.name());
            builder.field(Fields.MAC_ADDRESS, this.primary.macAddress());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static NetworkInfo readNetworkInfo(StreamInput in) throws IOException {
        NetworkInfo info = new NetworkInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        this.primary = Interface.readNetworkInterface(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        this.primary.writeTo(out);
    }

    public static class Interface
    implements Streamable,
    Serializable {
        private String name = "";
        private String address = "";
        private String macAddress = "";

        private Interface() {
        }

        public Interface(String name, String address, String macAddress) {
            this.name = name;
            this.address = address;
            this.macAddress = macAddress;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name();
        }

        public String address() {
            return this.address;
        }

        public String getAddress() {
            return this.address();
        }

        public String macAddress() {
            return this.macAddress;
        }

        public String getMacAddress() {
            return this.macAddress();
        }

        public static Interface readNetworkInterface(StreamInput in) throws IOException {
            Interface inf = new Interface();
            inf.readFrom(in);
            return inf;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.address = in.readString();
            this.macAddress = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.address);
            out.writeString(this.macAddress);
        }
    }

    static final class Fields {
        static final XContentBuilderString NETWORK = new XContentBuilderString("network");
        static final XContentBuilderString REFRESH_INTERVAL = new XContentBuilderString("refresh_interval");
        static final XContentBuilderString PRIMARY_INTERFACE = new XContentBuilderString("primary_interface");
        static final XContentBuilderString ADDRESS = new XContentBuilderString("address");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString MAC_ADDRESS = new XContentBuilderString("mac_address");

        Fields() {
        }
    }
}

