/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.warmer;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndicesWarmer
extends AbstractComponent
implements IndicesWarmer {
    public static final String INDEX_WARMER_ENABLED = "index.warmer.enabled";
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final CopyOnWriteArrayList<IndicesWarmer.Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public InternalIndicesWarmer(Settings settings, ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    @Override
    public void addListener(IndicesWarmer.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IndicesWarmer.Listener listener) {
        this.listeners.remove(listener);
    }

    public void warm(IndicesWarmer.WarmerContext context) {
        IndexMetaData indexMetaData = this.clusterService.state().metaData().index(context.shardId().index().name());
        if (indexMetaData == null) {
            return;
        }
        if (!indexMetaData.settings().getAsBoolean(INDEX_WARMER_ENABLED, this.settings.getAsBoolean(INDEX_WARMER_ENABLED, (Boolean)true)).booleanValue()) {
            return;
        }
        IndexService indexService = this.indicesService.indexService(context.shardId().index().name());
        if (indexService == null) {
            return;
        }
        IndexShard indexShard = indexService.shard(context.shardId().id());
        if (indexShard == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}][{}] warming [{}]", context.shardId().index().name(), context.shardId().id(), context.newSearcher().reader());
        }
        indexShard.warmerService().onPreWarm();
        long time = System.nanoTime();
        ArrayList<IndicesWarmer.Listener.TerminationHandle> terminationHandles = Lists.newArrayList();
        for (IndicesWarmer.Listener listener : this.listeners) {
            terminationHandles.add(listener.warm(indexShard, indexMetaData, context, this.threadPool));
        }
        for (IndicesWarmer.Listener.TerminationHandle terminationHandle : terminationHandles) {
            try {
                terminationHandle.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("Warming has been interrupted", e, new Object[0]);
                break;
            }
        }
        long took = System.nanoTime() - time;
        indexShard.warmerService().onPostWarm(took);
        if (indexShard.warmerService().logger().isTraceEnabled()) {
            indexShard.warmerService().logger().trace("warming took [{}]", new TimeValue(took, TimeUnit.NANOSECONDS));
        }
    }
}

