/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.index.mapper.object.ObjectMapper;

public class ObjectMappers
implements Iterable<ObjectMapper> {
    private final ImmutableList<ObjectMapper> objectMappers;
    private final boolean hasNested;

    public ObjectMappers() {
        this(ImmutableList.of());
    }

    public ObjectMappers(ObjectMapper objectMapper) {
        this(new ObjectMapper[]{objectMapper});
    }

    public ObjectMappers(ObjectMapper[] objectMappers) {
        this(ImmutableList.copyOf(objectMappers));
    }

    public ObjectMappers(ImmutableList<ObjectMapper> objectMappers) {
        this.objectMappers = objectMappers;
        boolean hasNested = false;
        for (ObjectMapper objectMapper : objectMappers) {
            if (!objectMapper.nested().isNested()) continue;
            hasNested = true;
            break;
        }
        this.hasNested = hasNested;
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public ObjectMapper mapper() {
        if (this.objectMappers.isEmpty()) {
            return null;
        }
        return (ObjectMapper)this.objectMappers.get(0);
    }

    public boolean isEmpty() {
        return this.objectMappers.isEmpty();
    }

    public ImmutableList<ObjectMapper> mappers() {
        return this.objectMappers;
    }

    @Override
    public UnmodifiableIterator<ObjectMapper> iterator() {
        return this.objectMappers.iterator();
    }

    public ObjectMappers concat(ObjectMapper mapper) {
        return new ObjectMappers((ImmutableList<ObjectMapper>)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.objectMappers)).add(mapper)).build());
    }

    public ObjectMappers concat(ObjectMappers mappers) {
        return new ObjectMappers((ImmutableList<ObjectMapper>)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.objectMappers)).addAll((Iterable)mappers)).build());
    }

    public ObjectMappers remove(Iterable<ObjectMapper> mappers) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ObjectMapper objectMapper : this.objectMappers) {
            boolean found = false;
            for (ObjectMapper mapper : mappers) {
                if (objectMapper != mapper) continue;
                found = true;
            }
            if (found) continue;
            builder.add(objectMapper);
        }
        return new ObjectMappers((ImmutableList<ObjectMapper>)builder.build());
    }

    public ObjectMappers remove(ObjectMapper mapper) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ObjectMapper objectMapper : this.objectMappers) {
            if (objectMapper == mapper) continue;
            builder.add(objectMapper);
        }
        return new ObjectMappers((ImmutableList<ObjectMapper>)builder.build());
    }
}

