/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class ShardFieldData
extends AbstractIndexShardComponent
implements IndexFieldDataCache.Listener {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();
    private final CircuitBreakerService breakerService;

    @Inject
    public ShardFieldData(ShardId shardId, @IndexSettings Settings indexSettings, CircuitBreakerService breakerService) {
        super(shardId, indexSettings);
        this.breakerService = breakerService;
    }

    public FieldDataStats stats(String ... fields) {
        ObjectLongOpenHashMap<String> fieldTotals = null;
        if (fields != null && fields.length > 0) {
            fieldTotals = new ObjectLongOpenHashMap<String>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                for (String field : fields) {
                    if (!Regex.simpleMatch(field, (String)entry.getKey())) continue;
                    fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
                }
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals);
    }

    @Override
    public void onLoad(FieldMapper.Names fieldNames, FieldDataType fieldDataType, AtomicFieldData fieldData) {
        long sizeInBytes = fieldData.getMemorySizeInBytes();
        this.totalMetric.inc(sizeInBytes);
        String keyFieldName = fieldNames.indexName();
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
        if (total != null) {
            total.inc(sizeInBytes);
        } else {
            total = new CounterMetric();
            total.inc(sizeInBytes);
            CounterMetric prev = this.perFieldTotals.putIfAbsent(keyFieldName, total);
            if (prev != null) {
                prev.inc(sizeInBytes);
            }
        }
    }

    @Override
    public void onUnload(FieldMapper.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes, @Nullable AtomicFieldData fieldData) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.breakerService.getBreaker().addWithoutBreaking(-sizeInBytes);
            this.totalMetric.dec(sizeInBytes);
            String keyFieldName = fieldNames.indexName();
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }
}

