/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerTokenizer;

public class NumericIntegerAnalyzer
extends NumericAnalyzer<NumericIntegerTokenizer> {
    private static final IntObjectOpenHashMap<NamedAnalyzer> builtIn = new IntObjectOpenHashMap();
    private final int precisionStep;

    public static NamedAnalyzer buildNamedAnalyzer(int precisionStep) {
        NamedAnalyzer namedAnalyzer = builtIn.get(precisionStep);
        if (namedAnalyzer == null) {
            namedAnalyzer = new NamedAnalyzer("_int/" + precisionStep, AnalyzerScope.INDEX, new NumericIntegerAnalyzer(precisionStep));
        }
        return namedAnalyzer;
    }

    public NumericIntegerAnalyzer() {
        this(4);
    }

    public NumericIntegerAnalyzer(int precisionStep) {
        this.precisionStep = precisionStep;
    }

    @Override
    protected NumericIntegerTokenizer createNumericTokenizer(Reader reader, char[] buffer) throws IOException {
        return new NumericIntegerTokenizer(reader, this.precisionStep, buffer);
    }

    static {
        builtIn.put(Integer.MAX_VALUE, new NamedAnalyzer("_int/max", AnalyzerScope.GLOBAL, new NumericIntegerAnalyzer(Integer.MAX_VALUE)));
        for (int i = 0; i <= 64; i += 4) {
            builtIn.put(i, new NamedAnalyzer("_int/" + i, AnalyzerScope.GLOBAL, new NumericIntegerAnalyzer(i)));
        }
    }
}

