/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.elasticsearch.common.util.concurrent.jsr166e.CompletionException;
import org.elasticsearch.common.util.concurrent.jsr166e.ForkJoinPool;
import org.elasticsearch.common.util.concurrent.jsr166e.ForkJoinTask;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import sun.misc.Unsafe;

public class CompletableFuture<T>
implements Future<T> {
    static final AltResult NIL = new AltResult(null);
    volatile Object result;
    volatile WaitNode waiters;
    volatile CompletionNode completions;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int SPINS = NCPU > 1 ? 256 : 0;
    private static final Unsafe UNSAFE;
    private static final long RESULT;
    private static final long WAITERS;
    private static final long COMPLETIONS;

    final void postComplete() {
        CompletionNode h;
        WaitNode q;
        while ((q = this.waiters) != null) {
            Thread t;
            if (!UNSAFE.compareAndSwapObject(this, WAITERS, q, q.next) || (t = q.thread) == null) continue;
            q.thread = null;
            LockSupport.unpark(t);
        }
        while ((h = this.completions) != null) {
            Completion c;
            if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, h, h.next) || (c = h.completion) == null) continue;
            c.run();
        }
    }

    final void internalComplete(T v, Throwable ex) {
        if (this.result == null) {
            UNSAFE.compareAndSwapObject(this, RESULT, null, ex == null ? (v == null ? NIL : v) : new AltResult(ex instanceof CompletionException ? ex : new CompletionException(ex)));
        }
        this.postComplete();
    }

    final void helpPostComplete() {
        if (this.result != null) {
            this.postComplete();
        }
    }

    private Object waitingGet(boolean interruptible) {
        WaitNode q = null;
        boolean queued = false;
        int spins = SPINS;
        while (true) {
            Object r;
            if ((r = this.result) != null) {
                if (q != null) {
                    q.thread = null;
                    if (q.interruptControl < 0) {
                        if (interruptible) {
                            this.removeWaiter(q);
                            return null;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                this.postComplete();
                return r;
            }
            if (spins > 0) {
                int rnd = ThreadLocalRandom.current().nextInt();
                if (rnd < 0) continue;
                --spins;
                continue;
            }
            if (q == null) {
                q = new WaitNode(interruptible, 0L, 0L);
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, WAITERS, q.next, q);
                continue;
            }
            if (interruptible && q.interruptControl < 0) {
                this.removeWaiter(q);
                return null;
            }
            if (q.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(q);
                continue;
            }
            catch (InterruptedException ex) {
                q.interruptControl = -1;
                continue;
            }
            break;
        }
    }

    private Object timedAwaitDone(long nanos) throws InterruptedException, TimeoutException {
        WaitNode q = null;
        boolean queued = false;
        while (true) {
            Object r;
            if ((r = this.result) != null) {
                if (q != null) {
                    q.thread = null;
                    if (q.interruptControl < 0) {
                        this.removeWaiter(q);
                        throw new InterruptedException();
                    }
                }
                this.postComplete();
                return r;
            }
            if (q == null) {
                if (nanos <= 0L) {
                    throw new TimeoutException();
                }
                long d = System.nanoTime() + nanos;
                q = new WaitNode(true, nanos, d == 0L ? 1L : d);
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, WAITERS, q.next, q);
                continue;
            }
            if (q.interruptControl < 0) {
                this.removeWaiter(q);
                throw new InterruptedException();
            }
            if (q.nanos <= 0L) {
                if (this.result != null) continue;
                this.removeWaiter(q);
                throw new TimeoutException();
            }
            if (q.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(q);
                continue;
            }
            catch (InterruptedException ex) {
                q.interruptControl = -1;
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode node) {
        if (node != null) {
            node.thread = null;
            block0: while (true) {
                pred = null;
                q = this.waiters;
                while (q != null) {
                    s = q.next;
                    if (q.thread != null) {
                        pred = q;
                    } else if (pred != null) {
                        pred.next = s;
                        if (pred.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (CompletableFuture.UNSAFE.compareAndSwapObject(this, CompletableFuture.WAITERS, q, s)) ** break;
                        continue block0;
                    }
                    q = s;
                }
                break;
            }
        }
    }

    public static <U> CompletableFuture<U> supplyAsync(Generator<U> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture f = new CompletableFuture();
        ForkJoinPool.commonPool().execute((ForkJoinTask<?>)new AsyncSupply<U>(supplier, f));
        return f;
    }

    public static <U> CompletableFuture<U> supplyAsync(Generator<U> supplier, Executor executor) {
        if (executor == null || supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture f = new CompletableFuture();
        executor.execute(new AsyncSupply<U>(supplier, f));
        return f;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        ForkJoinPool.commonPool().execute(new AsyncRun(runnable, f));
        return f;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        if (executor == null || runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        executor.execute(new AsyncRun(runnable, f));
        return f;
    }

    public static <U> CompletableFuture<U> completedFuture(U value) {
        CompletableFuture f = new CompletableFuture();
        f.result = value == null ? NIL : value;
        return f;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Throwable cause;
        Object r = this.result;
        if (r == null && (r = this.waitingGet(true)) == null) {
            throw new InterruptedException();
        }
        if (!(r instanceof AltResult)) {
            Object tr = r;
            return (T)tr;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException && (cause = ex.getCause()) != null) {
            ex = cause;
        }
        throw new ExecutionException(ex);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Throwable cause;
        long nanos = unit.toNanos(timeout);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object r = this.result;
        if (r == null) {
            r = this.timedAwaitDone(nanos);
        }
        if (!(r instanceof AltResult)) {
            Object tr = r;
            return (T)tr;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException && (cause = ex.getCause()) != null) {
            ex = cause;
        }
        throw new ExecutionException(ex);
    }

    public T join() {
        Object r = this.result;
        if (r == null) {
            r = this.waitingGet(false);
        }
        if (!(r instanceof AltResult)) {
            Object tr = r;
            return (T)tr;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException) {
            throw (CompletionException)ex;
        }
        throw new CompletionException(ex);
    }

    public T getNow(T valueIfAbsent) {
        Object r = this.result;
        if (r == null) {
            return valueIfAbsent;
        }
        if (!(r instanceof AltResult)) {
            Object tr = r;
            return (T)tr;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException) {
            throw (CompletionException)ex;
        }
        throw new CompletionException(ex);
    }

    public boolean complete(T value) {
        boolean triggered = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, value == null ? NIL : value);
        this.postComplete();
        return triggered;
    }

    public boolean completeExceptionally(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        boolean triggered = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, new AltResult(ex));
        this.postComplete();
        return triggered;
    }

    public <U> CompletableFuture<U> thenApply(Fun<? super T, ? extends U> fn) {
        return this.doThenApply(fn, null);
    }

    public <U> CompletableFuture<U> thenApplyAsync(Fun<? super T, ? extends U> fn) {
        return this.doThenApply(fn, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<U> thenApplyAsync(Fun<? super T, ? extends U> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenApply(fn, executor);
    }

    private <U> CompletableFuture<U> doThenApply(Fun<? super T, ? extends U> fn, Executor e) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = new CompletableFuture<Object>();
        ThenApply<T, U> d = null;
        Object r = this.result;
        if (r == null) {
            d = new ThenApply<T, U>(this, fn, dst, e);
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            T u = null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncApply<T, U>(t, fn, dst));
                    } else {
                        u = (T)fn.apply(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(u, ex);
            }
        }
        this.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> thenAccept(Action<? super T> block) {
        return this.doThenAccept(block, null);
    }

    public CompletableFuture<Void> thenAcceptAsync(Action<? super T> block) {
        return this.doThenAccept(block, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> thenAcceptAsync(Action<? super T> block, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenAccept(block, executor);
    }

    private CompletableFuture<Void> doThenAccept(Action<? super T> fn, Executor e) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        ThenAccept<T> d = null;
        Object r = this.result;
        if (r == null) {
            d = new ThenAccept<T>(this, fn, dst, e);
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncAccept<T>(t, fn, dst));
                    } else {
                        fn.accept(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.doThenRun(action, null);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.doThenRun(action, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenRun(action, executor);
    }

    private CompletableFuture<Void> doThenRun(Runnable action, Executor e) {
        if (action == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        AtomicInteger d = null;
        Object r = this.result;
        if (r == null) {
            d = new ThenRun(this, action, dst, e);
            CompletionNode p = new CompletionNode((Completion)d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncRun(action, dst));
                    } else {
                        action.run();
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        return dst;
    }

    public <U, V> CompletableFuture<V> thenCombine(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn) {
        return this.doThenCombine(other, fn, null);
    }

    public <U, V> CompletableFuture<V> thenCombineAsync(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn) {
        return this.doThenCombine(other, fn, ForkJoinPool.commonPool());
    }

    public <U, V> CompletableFuture<V> thenCombineAsync(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenCombine(other, fn, executor);
    }

    private <U, V> CompletableFuture<V> doThenCombine(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = new CompletableFuture<Object>();
        ThenCombine<T, U, V> d = null;
        Object s = null;
        Object r = this.result;
        if (r == null || (s = other.result) == null) {
            d = new ThenCombine<T, U, V>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p = new CompletionNode(d);
            while (r == null && (r = this.result) == null || s == null && (s = other.result) == null) {
                if (q != null) {
                    if (s == null && !UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next = other.completions, q)) continue;
                    break;
                }
                if (r == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) continue;
                if (s != null) break;
                q = new CompletionNode(d);
            }
        }
        if (r != null && s != null && (d == null || d.compareAndSet(0, 1))) {
            Object u;
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            if (ex != null) {
                u = null;
            } else if (s instanceof AltResult) {
                ex = ((AltResult)s).ex;
                u = null;
            } else {
                Object us;
                u = us = s;
            }
            T v = null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncCombine<T, U, V>(t, u, fn, dst));
                    } else {
                        v = (T)fn.apply(t, u);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(v, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> block) {
        return this.doThenAcceptBoth(other, block, null);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> block) {
        return this.doThenAcceptBoth(other, block, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> block, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenAcceptBoth(other, block, executor);
    }

    private <U> CompletableFuture<Void> doThenAcceptBoth(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        ThenAcceptBoth<T, U> d = null;
        Object s = null;
        Object r = this.result;
        if (r == null || (s = other.result) == null) {
            d = new ThenAcceptBoth<T, U>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p = new CompletionNode(d);
            while (r == null && (r = this.result) == null || s == null && (s = other.result) == null) {
                if (q != null) {
                    if (s == null && !UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next = other.completions, q)) continue;
                    break;
                }
                if (r == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) continue;
                if (s != null) break;
                q = new CompletionNode(d);
            }
        }
        if (r != null && s != null && (d == null || d.compareAndSet(0, 1))) {
            Object u;
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            if (ex != null) {
                u = null;
            } else if (s instanceof AltResult) {
                ex = ((AltResult)s).ex;
                u = null;
            } else {
                Object us;
                u = us = s;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncAcceptBoth<T, U>(t, u, fn, dst));
                    } else {
                        fn.accept(t, u);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> runAfterBoth(CompletableFuture<?> other, Runnable action) {
        return this.doRunAfterBoth(other, action, null);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletableFuture<?> other, Runnable action) {
        return this.doRunAfterBoth(other, action, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletableFuture<?> other, Runnable action, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doRunAfterBoth(other, action, executor);
    }

    private CompletableFuture<Void> doRunAfterBoth(CompletableFuture<?> other, Runnable action, Executor e) {
        if (other == null || action == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        RunAfterBoth d = null;
        Object s = null;
        Object r = this.result;
        if (r == null || (s = other.result) == null) {
            d = new RunAfterBoth(this, other, action, dst, e);
            CompletionNode q = null;
            CompletionNode p = new CompletionNode(d);
            while (r == null && (r = this.result) == null || s == null && (s = other.result) == null) {
                if (q != null) {
                    if (s == null && !UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next = other.completions, q)) continue;
                    break;
                }
                if (r == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) continue;
                if (s != null) break;
                q = new CompletionNode(d);
            }
        }
        if (r != null && s != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null && s instanceof AltResult) {
                ex = ((AltResult)s).ex;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncRun(action, dst));
                    } else {
                        action.run();
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<U> applyToEither(CompletableFuture<? extends T> other, Fun<? super T, U> fn) {
        return this.doApplyToEither(other, fn, null);
    }

    public <U> CompletableFuture<U> applyToEitherAsync(CompletableFuture<? extends T> other, Fun<? super T, U> fn) {
        return this.doApplyToEither(other, fn, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<U> applyToEitherAsync(CompletableFuture<? extends T> other, Fun<? super T, U> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doApplyToEither(other, fn, executor);
    }

    private <U> CompletableFuture<U> doApplyToEither(CompletableFuture<? extends T> other, Fun<? super T, U> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = new CompletableFuture<Object>();
        ApplyToEither<T, U> d = null;
        Object r = this.result;
        if (r == null && (r = other.result) == null) {
            d = new ApplyToEither<T, U>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && (r = other.result) == null) {
                if (q != null) {
                    q.next = other.completions;
                    if (!UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next, q)) continue;
                    break;
                }
                p.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next, p)) continue;
                q = new CompletionNode(d);
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            T u = null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncApply<T, U>(t, fn, dst));
                    } else {
                        u = (T)fn.apply(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(u, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> acceptEither(CompletableFuture<? extends T> other, Action<? super T> block) {
        return this.doAcceptEither(other, block, null);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletableFuture<? extends T> other, Action<? super T> block) {
        return this.doAcceptEither(other, block, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletableFuture<? extends T> other, Action<? super T> block, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doAcceptEither(other, block, executor);
    }

    private CompletableFuture<Void> doAcceptEither(CompletableFuture<? extends T> other, Action<? super T> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        AcceptEither<T> d = null;
        Object r = this.result;
        if (r == null && (r = other.result) == null) {
            d = new AcceptEither<T>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && (r = other.result) == null) {
                if (q != null) {
                    q.next = other.completions;
                    if (!UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next, q)) continue;
                    break;
                }
                p.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next, p)) continue;
                q = new CompletionNode(d);
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncAccept<T>(t, fn, dst));
                    } else {
                        fn.accept(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> runAfterEither(CompletableFuture<?> other, Runnable action) {
        return this.doRunAfterEither(other, action, null);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletableFuture<?> other, Runnable action) {
        return this.doRunAfterEither(other, action, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletableFuture<?> other, Runnable action, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doRunAfterEither(other, action, executor);
    }

    private CompletableFuture<Void> doRunAfterEither(CompletableFuture<?> other, Runnable action, Executor e) {
        if (other == null || action == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        AtomicInteger d = null;
        Object r = this.result;
        if (r == null && (r = other.result) == null) {
            d = new RunAfterEither(this, other, action, dst, e);
            CompletionNode q = null;
            CompletionNode p = new CompletionNode((Completion)d);
            while ((r = this.result) == null && (r = other.result) == null) {
                if (q != null) {
                    q.next = other.completions;
                    if (!UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next, q)) continue;
                    break;
                }
                p.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next, p)) continue;
                q = new CompletionNode((Completion)d);
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncRun(action, dst));
                    } else {
                        action.run();
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<U> thenCompose(Fun<? super T, CompletableFuture<U>> fn) {
        return this.doThenCompose(fn, null);
    }

    public <U> CompletableFuture<U> thenComposeAsync(Fun<? super T, CompletableFuture<U>> fn) {
        return this.doThenCompose(fn, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<U> thenComposeAsync(Fun<? super T, CompletableFuture<U>> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenCompose(fn, executor);
    }

    private <U> CompletableFuture<U> doThenCompose(Fun<? super T, CompletableFuture<U>> fn, Executor e) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = null;
        ThenCompose<T, U> d = null;
        Object r = this.result;
        if (r == null) {
            dst = new CompletableFuture<T>();
            d = new ThenCompose<T, U>(this, fn, dst, e);
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            if (ex == null) {
                if (e != null) {
                    if (dst == null) {
                        dst = new CompletableFuture<T>();
                    }
                    e.execute(new AsyncCompose<T, U>(t, fn, dst));
                } else {
                    try {
                        dst = fn.apply(t);
                        if (dst == null) {
                            ex = new NullPointerException();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
            }
            if (dst == null) {
                dst = new CompletableFuture<T>();
            }
            if (ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        dst.helpPostComplete();
        return dst;
    }

    public CompletableFuture<T> exceptionally(Fun<Throwable, ? extends T> fn) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = new CompletableFuture<Object>();
        ExceptionCompletion<T> d = null;
        Object r = this.result;
        if (r == null) {
            d = new ExceptionCompletion<T>(this, fn, dst);
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t = null;
            Throwable dx = null;
            if (r instanceof AltResult) {
                Throwable ex = ((AltResult)r).ex;
                if (ex != null) {
                    try {
                        t = fn.apply(ex);
                    }
                    catch (Throwable rex) {
                        dx = rex;
                    }
                }
            } else {
                Object tr;
                t = tr = r;
            }
            dst.internalComplete(t, dx);
        }
        this.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<U> handle(BiFun<? super T, Throwable, ? extends U> fn) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<U> dst = new CompletableFuture<U>();
        HandleCompletion<T, U> d = null;
        Object r = this.result;
        if (r == null) {
            d = new HandleCompletion<T, U>(this, fn, dst);
            CompletionNode p = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p.next = this.completions, p)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable dx;
            U u;
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr;
                ex = null;
                t = tr = r;
            }
            try {
                u = fn.apply(t, ex);
                dx = null;
            }
            catch (Throwable rex) {
                dx = rex;
                u = null;
            }
            dst.internalComplete(u, dx);
        }
        this.helpPostComplete();
        return dst;
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?> ... cfs) {
        int len = cfs.length;
        if (len > 1) {
            return CompletableFuture.allTree(cfs, 0, len - 1);
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        if (len == 0) {
            dst.result = NIL;
        } else {
            Object r;
            CompletableFuture<?> f = cfs[0];
            if (f == null) {
                throw new NullPointerException();
            }
            ThenPropagate d = null;
            CompletionNode p = null;
            while ((r = f.result) == null) {
                if (d == null) {
                    d = new ThenPropagate(f, dst);
                    continue;
                }
                if (p == null) {
                    p = new CompletionNode(d);
                    continue;
                }
                p.next = f.completions;
                if (!UNSAFE.compareAndSwapObject(f, COMPLETIONS, p.next, p)) continue;
            }
            if (r != null && (d == null || d.compareAndSet(0, 1))) {
                dst.internalComplete(null, r instanceof AltResult ? ((AltResult)r).ex : null);
            }
            f.helpPostComplete();
        }
        return dst;
    }

    private static CompletableFuture<Void> allTree(CompletableFuture<?>[] cfs, int lo, int hi) {
        CompletableFuture<?> snd;
        int mid = lo + hi >>> 1;
        CompletableFuture<Object> fst = lo == mid ? cfs[lo] : CompletableFuture.allTree(cfs, lo, mid);
        if (fst == null || (snd = hi == mid + 1 ? cfs[hi] : CompletableFuture.allTree(cfs, mid + 1, hi)) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        AndCompletion d = null;
        CompletionNode p = null;
        CompletionNode q = null;
        Object r = null;
        Object s = null;
        while ((r = fst.result) == null || (s = snd.result) == null) {
            if (d == null) {
                d = new AndCompletion(fst, snd, dst);
                continue;
            }
            if (p == null) {
                p = new CompletionNode(d);
                continue;
            }
            if (q == null) {
                p.next = fst.completions;
                if (!UNSAFE.compareAndSwapObject(fst, COMPLETIONS, p.next, p)) continue;
                q = new CompletionNode(d);
                continue;
            }
            q.next = snd.completions;
            if (!UNSAFE.compareAndSwapObject(snd, COMPLETIONS, q.next, q)) continue;
        }
        if (!(r == null && (r = fst.result) == null || s == null && (s = snd.result) == null || d != null && !d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null && s instanceof AltResult) {
                ex = ((AltResult)s).ex;
            }
            dst.internalComplete(null, ex);
        }
        fst.helpPostComplete();
        snd.helpPostComplete();
        return dst;
    }

    public static CompletableFuture<Object> anyOf(CompletableFuture<?> ... cfs) {
        int len = cfs.length;
        if (len > 1) {
            return CompletableFuture.anyTree(cfs, 0, len - 1);
        }
        CompletableFuture<Object> dst = new CompletableFuture<Object>();
        if (len != 0) {
            Object r;
            CompletableFuture<?> f = cfs[0];
            if (f == null) {
                throw new NullPointerException();
            }
            ThenCopy<Object> d = null;
            CompletionNode p = null;
            while ((r = f.result) == null) {
                if (d == null) {
                    d = new ThenCopy<Object>(f, dst);
                    continue;
                }
                if (p == null) {
                    p = new CompletionNode(d);
                    continue;
                }
                p.next = f.completions;
                if (!UNSAFE.compareAndSwapObject(f, COMPLETIONS, p.next, p)) continue;
            }
            if (r != null && (d == null || d.compareAndSet(0, 1))) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    ex = null;
                    t = r;
                }
                dst.internalComplete(t, ex);
            }
            f.helpPostComplete();
        }
        return dst;
    }

    private static CompletableFuture<Object> anyTree(CompletableFuture<?>[] cfs, int lo, int hi) {
        Object r;
        CompletableFuture<?> snd;
        int mid = lo + hi >>> 1;
        CompletableFuture<Object> fst = lo == mid ? cfs[lo] : CompletableFuture.anyTree(cfs, lo, mid);
        if (fst == null || (snd = hi == mid + 1 ? cfs[hi] : CompletableFuture.anyTree(cfs, mid + 1, hi)) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = new CompletableFuture<Object>();
        AtomicInteger d = null;
        CompletionNode p = null;
        CompletionNode q = null;
        while ((r = fst.result) == null && (r = snd.result) == null) {
            if (d == null) {
                d = new OrCompletion(fst, snd, dst);
                continue;
            }
            if (p == null) {
                p = new CompletionNode((Completion)d);
                continue;
            }
            if (q == null) {
                p.next = fst.completions;
                if (!UNSAFE.compareAndSwapObject(fst, COMPLETIONS, p.next, p)) continue;
                q = new CompletionNode((Completion)d);
                continue;
            }
            q.next = snd.completions;
            if (!UNSAFE.compareAndSwapObject(snd, COMPLETIONS, q.next, q)) continue;
        }
        if (!(r == null && (r = fst.result) == null && (r = snd.result) == null || d != null && !d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                ex = null;
                t = r;
            }
            dst.internalComplete(t, ex);
        }
        fst.helpPostComplete();
        snd.helpPostComplete();
        return dst;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, new AltResult(new CancellationException()));
        this.postComplete();
        return cancelled || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        Object r = this.result;
        return r instanceof AltResult && ((AltResult)r).ex instanceof CancellationException;
    }

    public void obtrudeValue(T value) {
        this.result = value == null ? NIL : value;
        this.postComplete();
    }

    public void obtrudeException(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        this.result = new AltResult(ex);
        this.postComplete();
    }

    public int getNumberOfDependents() {
        int count = 0;
        CompletionNode p = this.completions;
        while (p != null) {
            ++count;
            p = p.next;
        }
        return count;
    }

    public String toString() {
        int count;
        Object r = this.result;
        return super.toString() + (r == null ? ((count = this.getNumberOfDependents()) == 0 ? "[Not completed]" : "[Not completed, " + count + " dependents]") : (r instanceof AltResult && ((AltResult)r).ex != null ? "[Completed exceptionally]" : "[Completed normally]"));
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = CompletableFuture.getUnsafe();
            Class<CompletableFuture> k = CompletableFuture.class;
            RESULT = UNSAFE.objectFieldOffset(k.getDeclaredField("result"));
            WAITERS = UNSAFE.objectFieldOffset(k.getDeclaredField("waiters"));
            COMPLETIONS = UNSAFE.objectFieldOffset(k.getDeclaredField("completions"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class ThenCompose<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Fun<? super T, CompletableFuture<U>> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCompose(CompletableFuture<? extends T> src, Fun<? super T, CompletableFuture<U>> fn, CompletableFuture<U> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Fun<T, CompletableFuture<U>> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                CompletableFuture<U> c = null;
                Object u = null;
                boolean complete = false;
                if (ex == null) {
                    Executor e = this.executor;
                    if (e != null) {
                        e.execute(new AsyncCompose<T, U>(t, fn, dst));
                    } else {
                        try {
                            c = fn.apply(t);
                            if (c == null) {
                                ex = new NullPointerException();
                            }
                        }
                        catch (Throwable rex) {
                            ex = rex;
                        }
                    }
                }
                if (c != null) {
                    ThenCopy<U> d = null;
                    Object s = c.result;
                    if (s == null) {
                        d = new ThenCopy<U>(c, dst);
                        CompletionNode p = new CompletionNode(d);
                        while ((s = c.result) == null) {
                            p.next = c.completions;
                            if (!UNSAFE.compareAndSwapObject(c, COMPLETIONS, p.next, p)) continue;
                        }
                    }
                    if (s != null && (d == null || d.compareAndSet(0, 1))) {
                        complete = true;
                        if (s instanceof AltResult) {
                            ex = ((AltResult)s).ex;
                            u = null;
                        } else {
                            Object us;
                            u = us = s;
                        }
                    }
                }
                if (complete || ex != null) {
                    dst.internalComplete(u, ex);
                }
                if (c != null) {
                    c.helpPostComplete();
                }
            }
        }
    }

    static final class HandleCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final BiFun<? super T, Throwable, ? extends U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        HandleCompletion(CompletableFuture<? extends T> src, BiFun<? super T, Throwable, ? extends U> fn, CompletableFuture<U> dst) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            BiFun<T, Throwable, U> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                Object u = null;
                Throwable dx = null;
                try {
                    u = fn.apply(t, ex);
                }
                catch (Throwable rex) {
                    dx = rex;
                }
                dst.internalComplete(u, dx);
            }
        }
    }

    static final class ThenPropagate
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenPropagate(CompletableFuture<?> src, CompletableFuture<Void> dst) {
            this.src = src;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<?> a;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                dst.internalComplete(null, ex);
            }
        }
    }

    static final class ThenCopy<T>
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCopy(CompletableFuture<?> src, CompletableFuture<T> dst) {
            this.src = src;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<?> a;
            CompletableFuture<Object> dst = this.dst;
            if (dst != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                dst.internalComplete(t, ex);
            }
        }
    }

    static final class ExceptionCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Fun<? super Throwable, ? extends T> fn;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ExceptionCompletion(CompletableFuture<? extends T> src, Fun<? super Throwable, ? extends T> fn, CompletableFuture<T> dst) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Fun<Throwable, T> fn;
            Object t = null;
            Throwable dx = null;
            CompletableFuture<Object> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex;
                if (r instanceof AltResult && (ex = ((AltResult)r).ex) != null) {
                    try {
                        t = fn.apply(ex);
                    }
                    catch (Throwable rex) {
                        dx = rex;
                    }
                } else {
                    Object tr;
                    t = tr = r;
                }
                dst.internalComplete(t, dx);
            }
        }
    }

    static final class OrCompletion
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final CompletableFuture<Object> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        OrCompletion(CompletableFuture<?> src, CompletableFuture<?> snd, CompletableFuture<Object> dst) {
            this.src = src;
            this.snd = snd;
            this.dst = dst;
        }

        @Override
        public final void run() {
            CompletableFuture<?> b;
            Object r;
            CompletableFuture<?> a;
            CompletableFuture<Object> dst = this.dst;
            if (dst != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    ex = null;
                    t = r;
                }
                dst.internalComplete(t, ex);
            }
        }
    }

    static final class RunAfterEither
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunAfterEither(CompletableFuture<?> src, CompletableFuture<?> snd, Runnable fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<?> b;
            Object r;
            CompletableFuture<?> a;
            Runnable fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncRun(fn, dst));
                        } else {
                            fn.run();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class AcceptEither<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Action<? super T> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        AcceptEither(CompletableFuture<? extends T> src, CompletableFuture<? extends T> snd, Action<? super T> fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<? extends T> b;
            Object r;
            CompletableFuture<? extends T> a;
            Action<T> fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncAccept<T>(t, fn, dst));
                        } else {
                            fn.accept(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class ApplyToEither<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Fun<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ApplyToEither(CompletableFuture<? extends T> src, CompletableFuture<? extends T> snd, Fun<? super T, ? extends U> fn, CompletableFuture<U> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<? extends T> b;
            Object r;
            CompletableFuture<? extends T> a;
            Fun<T, U> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                Executor e = this.executor;
                Object u = null;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncApply<T, U>(t, fn, dst));
                        } else {
                            u = fn.apply(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(u, ex);
                }
            }
        }
    }

    static final class AndCompletion
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AndCompletion(CompletableFuture<?> src, CompletableFuture<?> snd, CompletableFuture<Void> dst) {
            this.src = src;
            this.snd = snd;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object s;
            CompletableFuture<?> b;
            Object r;
            CompletableFuture<?> a;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s = b.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                if (ex == null && s instanceof AltResult) {
                    ex = ((AltResult)s).ex;
                }
                dst.internalComplete(null, ex);
            }
        }
    }

    static final class RunAfterBoth
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunAfterBoth(CompletableFuture<?> src, CompletableFuture<?> snd, Runnable fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object s;
            CompletableFuture<?> b;
            Object r;
            CompletableFuture<?> a;
            Runnable fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s = b.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                if (ex == null && s instanceof AltResult) {
                    ex = ((AltResult)s).ex;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncRun(fn, dst));
                        } else {
                            fn.run();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class ThenAcceptBoth<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiAction<? super T, ? super U> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenAcceptBoth(CompletableFuture<? extends T> src, CompletableFuture<? extends U> snd, BiAction<? super T, ? super U> fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object s;
            CompletableFuture<? extends U> b;
            Object r;
            CompletableFuture<? extends T> a;
            BiAction<T, U> fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s = b.result) != null && this.compareAndSet(0, 1)) {
                Object u;
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                if (ex != null) {
                    u = null;
                } else if (s instanceof AltResult) {
                    ex = ((AltResult)s).ex;
                    u = null;
                } else {
                    Object us;
                    u = us = s;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncAcceptBoth<T, U>(t, u, fn, dst));
                        } else {
                            fn.accept(t, u);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class ThenCombine<T, U, V>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiFun<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCombine(CompletableFuture<? extends T> src, CompletableFuture<? extends U> snd, BiFun<? super T, ? super U, ? extends V> fn, CompletableFuture<V> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object s;
            CompletableFuture<? extends U> b;
            Object r;
            CompletableFuture<? extends T> a;
            BiFun<T, U, V> fn;
            CompletableFuture<V> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s = b.result) != null && this.compareAndSet(0, 1)) {
                Object u;
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                if (ex != null) {
                    u = null;
                } else if (s instanceof AltResult) {
                    ex = ((AltResult)s).ex;
                    u = null;
                } else {
                    Object us;
                    u = us = s;
                }
                Executor e = this.executor;
                Object v = null;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncCombine<T, U, V>(t, u, fn, dst));
                        } else {
                            v = fn.apply(t, u);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(v, ex);
                }
            }
        }
    }

    static final class ThenRun
    extends Completion {
        final CompletableFuture<?> src;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenRun(CompletableFuture<?> src, Runnable fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<?> a;
            Runnable fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncRun(fn, dst));
                        } else {
                            fn.run();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class ThenAccept<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Action<? super T> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenAccept(CompletableFuture<? extends T> src, Action<? super T> fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Action<T> fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncAccept<T>(t, fn, dst));
                        } else {
                            fn.accept(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class ThenApply<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Fun<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenApply(CompletableFuture<? extends T> src, Fun<? super T, ? extends U> fn, CompletableFuture<U> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Fun<T, U> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr;
                    ex = null;
                    t = tr = r;
                }
                Executor e = this.executor;
                Object u = null;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncApply<T, U>(t, fn, dst));
                        } else {
                            u = fn.apply(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(u, ex);
                }
            }
        }
    }

    static abstract class Completion
    extends AtomicInteger
    implements Runnable {
        Completion() {
        }
    }

    static final class CompletionNode {
        final Completion completion;
        volatile CompletionNode next;

        CompletionNode(Completion completion) {
            this.completion = completion;
        }
    }

    static final class AsyncCompose<T, U>
    extends Async {
        final T arg;
        final Fun<? super T, CompletableFuture<U>> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncCompose(T arg, Fun<? super T, CompletableFuture<U>> fn, CompletableFuture<U> dst) {
            this.arg = arg;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> d = this.dst;
            if (d != null && d.result == null) {
                Object u;
                Throwable ex;
                CompletableFuture<U> fr;
                try {
                    fr = this.fn.apply(this.arg);
                    ex = fr == null ? new NullPointerException() : null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    fr = null;
                }
                if (ex != null) {
                    u = null;
                } else {
                    Object r = fr.result;
                    if (r == null) {
                        r = ((CompletableFuture)fr).waitingGet(false);
                    }
                    if (r instanceof AltResult) {
                        ex = ((AltResult)r).ex;
                        u = null;
                    } else {
                        Object ur;
                        u = ur = r;
                    }
                }
                d.internalComplete(u, ex);
            }
            return true;
        }
    }

    static final class AsyncAcceptBoth<T, U>
    extends Async {
        final T arg1;
        final U arg2;
        final BiAction<? super T, ? super U> fn;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAcceptBoth(T arg1, U arg2, BiAction<? super T, ? super U> fn, CompletableFuture<Void> dst) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                try {
                    this.fn.accept(this.arg1, this.arg2);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                }
                d.internalComplete(null, ex);
            }
            return true;
        }
    }

    static final class AsyncAccept<T>
    extends Async {
        final T arg;
        final Action<? super T> fn;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAccept(T arg, Action<? super T> fn, CompletableFuture<Void> dst) {
            this.arg = arg;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                try {
                    this.fn.accept(this.arg);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                }
                d.internalComplete(null, ex);
            }
            return true;
        }
    }

    static final class AsyncCombine<T, U, V>
    extends Async {
        final T arg1;
        final U arg2;
        final BiFun<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncCombine(T arg1, U arg2, BiFun<? super T, ? super U, ? extends V> fn, CompletableFuture<V> dst) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<V> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                Object v;
                try {
                    v = this.fn.apply(this.arg1, this.arg2);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    v = null;
                }
                d.internalComplete(v, ex);
            }
            return true;
        }
    }

    static final class AsyncApply<T, U>
    extends Async {
        final T arg;
        final Fun<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncApply(T arg, Fun<? super T, ? extends U> fn, CompletableFuture<U> dst) {
            this.arg = arg;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                U u;
                try {
                    u = this.fn.apply(this.arg);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    u = null;
                }
                d.internalComplete(u, ex);
            }
            return true;
        }
    }

    static final class AsyncSupply<U>
    extends Async {
        final Generator<U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncSupply(Generator<U> fn, CompletableFuture<U> dst) {
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                U u;
                try {
                    u = this.fn.get();
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    u = null;
                }
                d.internalComplete(u, ex);
            }
            return true;
        }
    }

    static final class AsyncRun
    extends Async {
        final Runnable fn;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncRun(Runnable fn, CompletableFuture<Void> dst) {
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                try {
                    this.fn.run();
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                }
                d.internalComplete(null, ex);
            }
            return true;
        }
    }

    static abstract class Async
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        Async() {
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final void run() {
            this.exec();
        }
    }

    public static interface AsynchronousCompletionTask {
    }

    static final class WaitNode
    implements ForkJoinPool.ManagedBlocker {
        long nanos;
        final long deadline;
        volatile int interruptControl;
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode(boolean interruptible, long nanos, long deadline) {
            this.interruptControl = interruptible ? 1 : 0;
            this.nanos = nanos;
            this.deadline = deadline;
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (Thread.interrupted()) {
                int i = this.interruptControl;
                this.interruptControl = -1;
                if (i > 0) {
                    return true;
                }
            }
            if (this.deadline != 0L && (this.nanos <= 0L || (this.nanos = this.deadline - System.nanoTime()) <= 0L)) {
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (this.deadline == 0L) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }
    }

    static final class AltResult {
        final Throwable ex;

        AltResult(Throwable ex) {
            this.ex = ex;
        }
    }

    public static interface Generator<T> {
        public T get();
    }

    public static interface BiFun<A, B, T> {
        public T apply(A var1, B var2);
    }

    public static interface Fun<A, T> {
        public T apply(A var1);
    }

    public static interface BiAction<A, B> {
        public void accept(A var1, B var2);
    }

    public static interface Action<A> {
        public void accept(A var1);
    }
}

