/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.ElasticsearchIllegalStateException;

public class KeyedLock<T> {
    private final ConcurrentMap<T, KeyLock> map = new ConcurrentHashMap<T, KeyLock>();
    private final ThreadLocal<KeyLock> threadLocal = new ThreadLocal();

    public void acquire(T key) {
        KeyLock perNodeLock;
        int i;
        do {
            KeyLock newLock;
            if (this.threadLocal.get() != null) {
                throw new ElasticsearchIllegalStateException("Lock already accquired in Thread" + Thread.currentThread().getId() + " for key " + key);
            }
            perNodeLock = (KeyLock)this.map.get(key);
            if (perNodeLock == null && (perNodeLock = this.map.putIfAbsent(key, newLock = new KeyLock())) == null) {
                newLock.lock();
                this.threadLocal.set(newLock);
                return;
            }
            assert (perNodeLock != null);
        } while ((i = perNodeLock.count.get()) <= 0 || !perNodeLock.count.compareAndSet(i, i + 1));
        perNodeLock.lock();
        this.threadLocal.set(perNodeLock);
    }

    public void release(T key) {
        KeyLock lock = this.threadLocal.get();
        if (lock == null) {
            throw new ElasticsearchIllegalStateException("Lock not accquired");
        }
        assert (lock.isHeldByCurrentThread());
        assert (lock == this.map.get(key));
        lock.unlock();
        this.threadLocal.set(null);
        int decrementAndGet = lock.count.decrementAndGet();
        if (decrementAndGet == 0) {
            this.map.remove(key, lock);
        }
    }

    public boolean hasLockedKeys() {
        return !this.map.isEmpty();
    }

    private static final class KeyLock
    extends ReentrantLock {
        private final AtomicInteger count = new AtomicInteger(1);

        private KeyLock() {
        }
    }
}

