/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.IntArray;

final class BigIntArray
extends AbstractBigArray
implements IntArray {
    private int[][] pages;

    public BigIntArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        super(4096, recycler, clearOnResize);
        this.size = size;
        this.pages = new int[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newIntPage(i);
        }
    }

    @Override
    public int get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public int set(long index, int value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = this.pages[pageIndex];
        int ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public int increment(long index, int inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] nArray = this.pages[pageIndex];
        int n = indexInPage;
        int n2 = nArray[n] + inc;
        nArray[n] = n2;
        return n2;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (int[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newIntPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }
}

