/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class ThrottlingAllocationDecider
extends AllocationDecider {
    public static final String CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES = "cluster.routing.allocation.node_initial_primaries_recoveries";
    public static final String CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES = "cluster.routing.allocation.node_concurrent_recoveries";
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES = 2;
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES = 4;
    private volatile int primariesInitialRecoveries;
    private volatile int concurrentRecoveries;

    @Inject
    public ThrottlingAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.primariesInitialRecoveries = settings.getAsInt(CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES, (Integer)4);
        this.concurrentRecoveries = settings.getAsInt("cluster.routing.allocation.concurrent_recoveries", settings.getAsInt(CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES, (Integer)2));
        this.logger.debug("using node_concurrent_recoveries [{}], node_initial_primaries_recoveries [{}]", this.concurrentRecoveries, this.primariesInitialRecoveries);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            assert (shardRouting.unassigned() || shardRouting.active());
            if (shardRouting.unassigned()) {
                int primariesInRecovery = 0;
                for (MutableShardRouting shard : node) {
                    if (shard.state() != ShardRoutingState.INITIALIZING || !shard.primary() || shard.relocatingNodeId() != null) continue;
                    ++primariesInRecovery;
                }
                if (primariesInRecovery >= this.primariesInitialRecoveries) {
                    return allocation.decision(Decision.THROTTLE, "too many primaries currently recovering [%d], limit: [%d]", primariesInRecovery, this.primariesInitialRecoveries);
                }
                return allocation.decision(Decision.YES, "below primary recovery limit of [%d]", this.primariesInitialRecoveries);
            }
        }
        return this.canAllocate(node, allocation);
    }

    @Override
    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        int currentRecoveries = 0;
        for (MutableShardRouting shard : node) {
            if (shard.state() != ShardRoutingState.INITIALIZING && shard.state() != ShardRoutingState.RELOCATING) continue;
            ++currentRecoveries;
        }
        if (currentRecoveries >= this.concurrentRecoveries) {
            return allocation.decision(Decision.THROTTLE, "too many shards currently recovering [%d], limit: [%d]", currentRecoveries, this.concurrentRecoveries);
        }
        return allocation.decision(Decision.YES, "below shard recovery limit of [%d]", this.concurrentRecoveries);
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int concurrentRecoveries;
            int primariesInitialRecoveries = settings.getAsInt(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES, (Integer)ThrottlingAllocationDecider.this.primariesInitialRecoveries);
            if (primariesInitialRecoveries != ThrottlingAllocationDecider.this.primariesInitialRecoveries) {
                ThrottlingAllocationDecider.this.logger.info("updating [cluster.routing.allocation.node_initial_primaries_recoveries] from [{}] to [{}]", ThrottlingAllocationDecider.this.primariesInitialRecoveries, primariesInitialRecoveries);
                ThrottlingAllocationDecider.this.primariesInitialRecoveries = primariesInitialRecoveries;
            }
            if ((concurrentRecoveries = settings.getAsInt(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES, (Integer)ThrottlingAllocationDecider.this.concurrentRecoveries).intValue()) != ThrottlingAllocationDecider.this.concurrentRecoveries) {
                ThrottlingAllocationDecider.this.logger.info("updating [cluster.routing.allocation.node_concurrent_recoveries] from [{}] to [{}]", ThrottlingAllocationDecider.this.concurrentRecoveries, concurrentRecoveries);
                ThrottlingAllocationDecider.this.concurrentRecoveries = concurrentRecoveries;
            }
        }
    }
}

