/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bulk.udp;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.ChannelBufferBytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.netty.bootstrap.ConnectionlessBootstrap;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.ReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.SimpleChannelUpstreamHandler;
import org.elasticsearch.common.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;

public class BulkUdpService
extends AbstractLifecycleComponent<BulkUdpService> {
    private final Client client;
    private final NetworkService networkService;
    private final boolean enabled;
    final String host;
    final String port;
    final ByteSizeValue receiveBufferSize;
    final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    final int bulkActions;
    final ByteSizeValue bulkSize;
    final TimeValue flushInterval;
    final int concurrentRequests;
    private BulkProcessor bulkProcessor;
    private ConnectionlessBootstrap bootstrap;
    private Channel channel;

    @Inject
    public BulkUdpService(Settings settings, Client client, NetworkService networkService) {
        super(settings);
        this.client = client;
        this.networkService = networkService;
        this.host = this.componentSettings.get("host");
        this.port = this.componentSettings.get("port", "9700-9800");
        this.bulkActions = this.componentSettings.getAsInt("bulk_actions", (Integer)1000);
        this.bulkSize = this.componentSettings.getAsBytesSize("bulk_size", new ByteSizeValue(5L, ByteSizeUnit.MB));
        this.flushInterval = this.componentSettings.getAsTime("flush_interval", TimeValue.timeValueSeconds(5L));
        this.concurrentRequests = this.componentSettings.getAsInt("concurrent_requests", (Integer)4);
        this.receiveBufferSize = this.componentSettings.getAsBytesSize("receive_buffer_size", new ByteSizeValue(10L, ByteSizeUnit.MB));
        this.receiveBufferSizePredictorFactory = new FixedReceiveBufferSizePredictorFactory(this.componentSettings.getAsBytesSize("receive_predictor_size", this.receiveBufferSize).bytesAsInt());
        this.enabled = this.componentSettings.getAsBoolean("enabled", (Boolean)false);
        this.logger.debug("using enabled [{}], host [{}], port [{}], bulk_actions [{}], bulk_size [{}], flush_interval [{}], concurrent_requests [{}]", this.enabled, this.host, this.port, this.bulkActions, this.bulkSize, this.flushInterval, this.concurrentRequests);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        InetAddress hostAddressX;
        if (!this.enabled) {
            return;
        }
        this.bulkProcessor = BulkProcessor.builder(this.client, new BulkListener()).setBulkActions(this.bulkActions).setBulkSize(this.bulkSize).setFlushInterval(this.flushInterval).setConcurrentRequests(this.concurrentRequests).build();
        this.bootstrap = new ConnectionlessBootstrap(new NioDatagramChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "bulk_udp_worker"))));
        this.bootstrap.setOption("receiveBufferSize", this.receiveBufferSize.bytesAsInt());
        this.bootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        this.bootstrap.setOption("broadcast", "false");
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(new Handler());
            }
        });
        try {
            hostAddressX = this.networkService.resolveBindHostAddress(this.host);
        }
        catch (IOException e) {
            this.logger.warn("failed to resolve host {}", e, this.host);
            return;
        }
        final InetAddress hostAddress = hostAddressX;
        PortsRange portsRange = new PortsRange(this.port);
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    BulkUdpService.this.channel = BulkUdpService.this.bootstrap.bind(new InetSocketAddress(hostAddress, portNumber));
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            this.logger.warn("failed to bind to {}/{}", (Throwable)lastException.get(), hostAddress, this.port);
            return;
        }
        this.logger.info("address {}", this.channel.getLocalAddress());
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        if (!this.enabled) {
            return;
        }
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
        this.bulkProcessor.close();
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    class BulkListener
    implements BulkProcessor.Listener {
        BulkListener() {
        }

        @Override
        public void beforeBulk(long executionId, BulkRequest request) {
            if (BulkUdpService.this.logger.isTraceEnabled()) {
                BulkUdpService.this.logger.trace("[{}] executing [{}]/[{}]", executionId, request.numberOfActions(), new ByteSizeValue(request.estimatedSizeInBytes()));
            }
        }

        @Override
        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            if (BulkUdpService.this.logger.isTraceEnabled()) {
                BulkUdpService.this.logger.trace("[{}] executed  [{}]/[{}], took [{}]", executionId, request.numberOfActions(), new ByteSizeValue(request.estimatedSizeInBytes()), response.getTook());
            }
            if (response.hasFailures()) {
                BulkUdpService.this.logger.warn("[{}] failed to execute bulk request: {}", executionId, response.buildFailureMessage());
            }
        }

        @Override
        public void afterBulk(long executionId, BulkRequest request, Throwable e) {
            BulkUdpService.this.logger.warn("[{}] failed to execute bulk request", e, executionId);
        }
    }

    class Handler
    extends SimpleChannelUpstreamHandler {
        Handler() {
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
            BulkUdpService.this.logger.trace("received message size [{}]", buffer.readableBytes());
            try {
                BulkUdpService.this.bulkProcessor.add(new ChannelBufferBytesReference(buffer), false, null, null);
            }
            catch (Exception e1) {
                BulkUdpService.this.logger.warn("failed to execute bulk request", e1, new Object[0]);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (e.getCause() instanceof BindException) {
                return;
            }
            BulkUdpService.this.logger.warn("failure caught", e.getCause(), new Object[0]);
        }
    }
}

