/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.opensearchserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerConfig;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OpenSearchServerConnection {
    private String serverLocation;
    private String indexName;
    private String userName;
    private String apiKey;
    private String resultDescription;
    private String callUrlSnippet;
    private String response;
    private Document xmlResponse;
    private HttpClient httpClient;
    protected String xPathStatus = "/response/entry[@key='Status']/text()";
    protected String xPathException = "/response/entry[@key='Exception']/text()";
    private Result result;
    private String resultCode;

    protected OpenSearchServerConnection(HttpClient client, OpenSearchServerConfig config) {
        this.httpClient = client;
        this.result = Result.UNKNOWN;
        this.response = null;
        this.xmlResponse = null;
        this.resultDescription = "";
        this.callUrlSnippet = null;
        this.serverLocation = config.getServerLocation();
        this.indexName = config.getIndexName();
        this.userName = config.getUserName();
        this.apiKey = config.getApiKey();
    }

    protected StringBuffer getApiUrl(String command) throws ManifoldCFException {
        StringBuffer url = new StringBuffer(this.serverLocation);
        if (!this.serverLocation.endsWith("/")) {
            url.append('/');
        }
        url.append(command);
        url.append("?use=");
        url.append(URLEncoder.encode((String)this.indexName));
        this.callUrlSnippet = url.toString();
        if (this.userName != null && this.apiKey != null && this.userName.length() > 0 && this.apiKey.length() > 0) {
            url.append("&login=");
            url.append(URLEncoder.encode((String)this.userName));
            url.append("&key=");
            url.append(this.apiKey);
        }
        return url;
    }

    protected StringBuffer getApiUrlV2(String path) throws ManifoldCFException {
        StringBuffer url = new StringBuffer(this.serverLocation);
        if (!this.serverLocation.endsWith("/")) {
            url.append('/');
        }
        url.append(path);
        this.callUrlSnippet = url.toString();
        if (this.userName != null && this.apiKey != null && this.userName.length() > 0 && this.apiKey.length() > 0) {
            url.append("&login=");
            url.append(URLEncoder.encode((String)this.userName));
            url.append("&key=");
            url.append(this.apiKey);
        }
        return url;
    }

    protected void call(HttpRequestBase method) throws ManifoldCFException {
        CallThread ct = new CallThread(this.httpClient, method);
        try {
            ct.start();
            try {
                ct.finishUp();
                if (!this.checkResultCode(ct.getResultCode())) {
                    throw new ManifoldCFException(this.getResultDescription());
                }
                this.response = ct.getResponse();
            }
            catch (InterruptedException e) {
                ct.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }
        catch (SocketTimeoutException e) {
            this.setResult(e.getClass().getSimpleName().toUpperCase(Locale.ROOT), Result.ERROR, e.getMessage());
            throw new ManifoldCFException("SocketTimeoutException while calling " + method.getURI() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            this.setResult(e.getClass().getSimpleName().toUpperCase(Locale.ROOT), Result.ERROR, e.getMessage());
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (HttpException e) {
            this.setResult(((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT), Result.ERROR, e.getMessage());
            throw new ManifoldCFException("HttpException while calling " + method.getURI() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.setResult(e.getClass().getSimpleName().toUpperCase(Locale.ROOT), Result.ERROR, e.getMessage());
            throw new ManifoldCFException("IOException while calling " + method.getURI() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void readXmlResponse() throws ManifoldCFException {
        if (this.xmlResponse != null) {
            return;
        }
        try (StringReader sw = null;){
            sw = new StringReader(this.response);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            this.xmlResponse = builder.parse(new InputSource(sw));
        }
    }

    protected String checkXPath(String xPathQuery) throws ManifoldCFException {
        try {
            this.readXmlResponse();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression xPathExpr = xpath.compile(xPathQuery);
            return xPathExpr.evaluate(this.xmlResponse);
        }
        catch (XPathExpressionException e) {
            throw new ManifoldCFException((Throwable)e);
        }
    }

    protected void setResult(String resultCode, Result res, String desc) {
        if (res != null) {
            this.result = res;
        }
        if (desc != null && desc.length() > 0) {
            this.resultDescription = desc;
        }
        this.setResultCode(resultCode);
    }

    public String getResultDescription() {
        return this.resultDescription;
    }

    protected String getResponse() {
        return this.response;
    }

    private boolean checkResultCode(int code) {
        switch (code) {
            case 0: {
                this.setResult("HTTPERROR", Result.UNKNOWN, null);
                return false;
            }
            case 200: {
                this.setResult("OK", Result.OK, null);
                return true;
            }
            case 404: {
                this.setResult("HTTPERROR", Result.ERROR, "Server/page not found");
                return false;
            }
        }
        this.setResult("HTTPERROR", Result.ERROR, null);
        return false;
    }

    public Result getResult() {
        return this.result;
    }

    public String getCallUrlSnippet() {
        return this.callUrlSnippet;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    protected static class CallThread
    extends Thread {
        protected final HttpClient client;
        protected final HttpRequestBase method;
        protected int resultCode = -1;
        protected String response = null;
        protected Throwable exception = null;

        public CallThread(HttpClient client, HttpRequestBase method) {
            this.client = client;
            this.method = method;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    HttpResponse resp = this.client.execute((HttpUriRequest)this.method);
                    this.resultCode = resp.getStatusLine().getStatusCode();
                    HttpEntity entity = resp.getEntity();
                    this.response = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                }
                finally {
                    this.method.abort();
                }
            }
            catch (SocketTimeoutException e) {
                this.exception = e;
            }
            catch (InterruptedIOException e) {
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public String getResponse() {
            return this.response;
        }

        public void finishUp() throws InterruptedException, HttpException, IOException {
            this.join();
            Throwable t = this.exception;
            if (t != null) {
                if (t instanceof HttpException) {
                    throw (HttpException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException("Unexpected exception thrown: " + t.getMessage(), t);
            }
        }
    }

    public static enum Result {
        OK,
        ERROR,
        UNKNOWN;

    }
}

