/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.generic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.common.XThreadInputStream;
import org.apache.manifoldcf.core.common.XThreadStringBuffer;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.system.ManifoldCF;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.generic.Messages;
import org.apache.manifoldcf.crawler.connectors.generic.api.Item;
import org.apache.manifoldcf.crawler.connectors.generic.api.Items;
import org.apache.manifoldcf.crawler.connectors.generic.api.Meta;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.ui.util.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: GenericConnector.java 994959 2010-09-08 10:04:42Z redguy $";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    private static final String ACTION_PARAM_NAME = "action";
    private static final String ACTION_CHECK = "check";
    private static final String ACTION_SEED = "seed";
    private static final String ACTION_ITEMS = "items";
    private static final String ACTION_ITEM = "item";
    private String genericLogin = null;
    private String genericPassword = null;
    private String genericEntryPoint = null;
    private int connectionTimeoutMillis = 60000;
    private int socketTimeoutMillis = 1800000;
    protected static final String RELATIONSHIP_RELATED = "related";
    private ConcurrentHashMap<String, Item> documentCache = new ConcurrentHashMap(10);

    public int getMaxDocumentRequest() {
        return 10;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_RELATED};
    }

    public int getConnectorModel() {
        return 2;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.genericEntryPoint};
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.genericEntryPoint = this.getParam(configParams, "genericEntryPoint", null);
        this.genericLogin = this.getParam(configParams, "genericLogin", null);
        this.genericPassword = "";
        try {
            this.genericPassword = ManifoldCF.deobfuscate((String)this.getParam(configParams, "genericPassword", ""));
        }
        catch (ManifoldCFException manifoldCFException) {
            // empty catch block
        }
        this.connectionTimeoutMillis = Integer.parseInt(this.getParam(configParams, "genericConnectionTimeout", "60000"));
        if (this.connectionTimeoutMillis == 0) {
            this.connectionTimeoutMillis = 60000;
        }
        this.socketTimeoutMillis = Integer.parseInt(this.getParam(configParams, "genericSocketTimeout", "1800000"));
        if (this.socketTimeoutMillis == 0) {
            this.socketTimeoutMillis = 1800000;
        }
    }

    protected DefaultHttpClient getClient() throws ManifoldCFException {
        DefaultHttpClient cl = new DefaultHttpClient();
        if (this.genericLogin != null && !this.genericLogin.isEmpty()) {
            try {
                URL url = new URL(this.genericEntryPoint);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.genericLogin, this.genericPassword);
                cl.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), url.getPort() > 0 ? url.getPort() : 80, AuthScope.ANY_REALM), (Credentials)credentials);
                cl.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth((Credentials)credentials), 0);
            }
            catch (MalformedURLException ex) {
                throw new ManifoldCFException("getClient exception: " + ex.getMessage(), (Throwable)ex);
            }
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)cl.getParams(), (int)this.connectionTimeoutMillis);
        HttpConnectionParams.setSoTimeout((HttpParams)cl.getParams(), (int)this.socketTimeoutMillis);
        return cl;
    }

    public String check() throws ManifoldCFException {
        DefaultHttpClient client = this.getClient();
        try {
            CheckThread checkThread = new CheckThread((HttpClient)client, this.genericEntryPoint + "?" + ACTION_PARAM_NAME + "=" + ACTION_CHECK);
            checkThread.start();
            checkThread.join();
            if (checkThread.getException() != null) {
                Throwable thr = checkThread.getException();
                return "Check exception: " + thr.getMessage();
            }
            return checkThread.getResult();
        }
        catch (InterruptedException ex) {
            throw new ManifoldCFException(ex.getMessage(), (Throwable)ex, 2);
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        DefaultHttpClient client = this.getClient();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        StringBuilder url = new StringBuilder(this.genericEntryPoint);
        url.append("?").append(ACTION_PARAM_NAME).append("=").append(ACTION_SEED);
        if (startTime > 0L) {
            url.append("&startTime=").append(sdf.format(new Date(startTime)));
        }
        url.append("&endTime=").append(sdf.format(new Date(seedTime)));
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("param")) continue;
            String paramName = sn.getAttributeValue("name");
            String paramValue = sn.getValue();
            url.append("&").append(URLEncoder.encode((String)paramName)).append("=").append(URLEncoder.encode((String)paramValue));
        }
        ExecuteSeedingThread t = new ExecuteSeedingThread((HttpClient)client, url.toString());
        try {
            t.start();
            boolean wasInterrupted = false;
            try {
                String docPath;
                XThreadStringBuffer seedBuffer = t.getBuffer();
                while ((docPath = seedBuffer.fetch()) != null) {
                    activities.addSeedDocument(docPath);
                }
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                throw e;
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    wasInterrupted = true;
                }
                throw e;
            }
            finally {
                if (!wasInterrupted) {
                    t.finishUp();
                }
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        return new Long(seedTime).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        int i;
        Object[] acls = GenericConnector.getAcls(spec);
        Arrays.sort(acls);
        String rights = Arrays.toString(acls);
        String genericAuthMode = "provided";
        for (int i2 = 0; i2 < spec.getChildCount(); ++i2) {
            SpecificationNode sn = spec.getChild(i2);
            if (!sn.getType().equals("genericAuthMode")) continue;
            genericAuthMode = sn.getValue();
            break;
        }
        DefaultHttpClient client = this.getClient();
        StringBuilder url = new StringBuilder(this.genericEntryPoint);
        url.append("?").append(ACTION_PARAM_NAME).append("=").append(ACTION_ITEMS);
        for (i = 0; i < documentIdentifiers.length; ++i) {
            url.append("&id[]=").append(URLEncoder.encode((String)documentIdentifiers[i]));
        }
        for (i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("param")) continue;
            String paramName = sn.getAttributeValue("name");
            String paramValue = sn.getValue();
            url.append("&").append(URLEncoder.encode((String)paramName)).append("=").append(URLEncoder.encode((String)paramValue));
        }
        String[] versions = null;
        try {
            DocumentVersionThread versioningThread = new DocumentVersionThread((HttpClient)client, url.toString(), documentIdentifiers, genericAuthMode, rights, this.documentCache);
            versioningThread.start();
            try {
                versions = versioningThread.finishUp();
            }
            catch (IOException ex) {
                GenericConnector.handleIOException(ex);
            }
            catch (InterruptedException ex) {
                throw new ManifoldCFException(ex.getMessage(), (Throwable)ex, 2);
            }
            for (int i3 = 0; i3 < documentIdentifiers.length; ++i3) {
                String documentIdentifier = documentIdentifiers[i3];
                String versionString = versions[i3];
                if (versionString == null) {
                    activities.deleteDocument(documentIdentifier);
                    continue;
                }
                Item item = this.documentCache.get(documentIdentifier);
                if (item == null) {
                    throw new ManifoldCFException("processDocuments error - no cache entry for: " + documentIdentifier);
                }
                if (item.related != null) {
                    for (String rel : item.related) {
                        activities.addDocumentReference(rel, documentIdentifier, RELATIONSHIP_RELATED);
                    }
                }
                if (versionString.length() != 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                RepositoryDocument doc = new RepositoryDocument();
                if (item.mimeType != null) {
                    doc.setMimeType(item.mimeType);
                }
                if (item.created != null) {
                    doc.setCreatedDate(item.created);
                }
                if (item.updated != null) {
                    doc.setModifiedDate(item.updated);
                }
                if (item.fileName != null) {
                    doc.setFileName(item.fileName);
                }
                if (item.metadata != null) {
                    HashMap meta = new HashMap();
                    for (Meta m : item.metadata) {
                        if (meta.containsKey(m.name)) {
                            ((List)meta.get(m.name)).add(m.value);
                            continue;
                        }
                        ArrayList<String> list = new ArrayList<String>(1);
                        list.add(m.value);
                        meta.put(m.name, list);
                    }
                    for (String name : meta.keySet()) {
                        List values = (List)meta.get(name);
                        if (values.size() > 1) {
                            String[] svals = new String[values.size()];
                            for (int j = 0; j < values.size(); ++j) {
                                svals[j] = (String)values.get(j);
                            }
                            doc.addField(name, svals);
                            continue;
                        }
                        doc.addField(name, (String)values.get(0));
                    }
                }
                if ("provided".equals(genericAuthMode)) {
                    if (item.auth != null) {
                        String[] acl = new String[item.auth.size()];
                        for (int j = 0; j < item.auth.size(); ++j) {
                            acl[j] = item.auth.get(j);
                        }
                        doc.setSecurity("document", acl, new String[]{defaultAuthorityDenyToken});
                    }
                } else if (acls.length > 0) {
                    doc.setSecurity("document", (String[])acls, new String[]{defaultAuthorityDenyToken});
                }
                if (item.content != null) {
                    try {
                        byte[] content = item.content.getBytes(StandardCharsets.UTF_8);
                        try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
                            doc.setBinary((InputStream)is, (long)content.length);
                            activities.ingestDocumentWithException(documentIdentifier, versionString, item.url, doc);
                            is.close();
                        }
                    }
                    catch (IOException ex) {
                        GenericConnector.handleIOException(ex);
                    }
                    continue;
                }
                url = new StringBuilder(this.genericEntryPoint);
                url.append("?").append(ACTION_PARAM_NAME).append("=").append(ACTION_ITEM);
                url.append("&id=").append(URLEncoder.encode((String)documentIdentifier));
                for (int j = 0; j < spec.getChildCount(); ++j) {
                    SpecificationNode sn = spec.getChild(j);
                    if (!sn.getType().equals("param")) continue;
                    String paramName = sn.getAttributeValue("name");
                    String paramValue = sn.getValue();
                    url.append("&").append(URLEncoder.encode((String)paramName)).append("=").append(URLEncoder.encode((String)paramValue));
                }
                ExecuteProcessThread t = new ExecuteProcessThread((HttpClient)client, url.toString());
                try {
                    t.start();
                    boolean wasInterrupted = false;
                    try {
                        InputStream is = t.getSafeInputStream();
                        long fileLength = t.getStreamLength();
                        try {
                            doc.setBinary(is, fileLength);
                            activities.ingestDocumentWithException(documentIdentifier, versionString, item.url, doc);
                            continue;
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 2) {
                            wasInterrupted = true;
                        }
                        throw e;
                    }
                    catch (SocketTimeoutException e) {
                        throw e;
                    }
                    catch (InterruptedIOException e) {
                        wasInterrupted = true;
                        throw e;
                    }
                    finally {
                        if (!wasInterrupted) {
                            t.finishUp();
                        }
                    }
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (InterruptedIOException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (IOException e) {
                    GenericConnector.handleIOException(e);
                }
            }
        }
        finally {
            for (String documentIdentifier : documentIdentifiers) {
                if (!this.documentCache.containsKey(documentIdentifier)) continue;
                this.documentCache.remove(documentIdentifier);
            }
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "generic.EntryPoint"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig() {\n  return true;\n}\n\nfunction checkConfigForSave() {\n  return true;\n}\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String server = this.getParam(parameters, "genericEntryPoint", "");
        String login = this.getParam(parameters, "genericLogin", "");
        String password = "";
        try {
            password = ManifoldCF.deobfuscate((String)this.getParam(parameters, "genericPassword", ""));
        }
        catch (ManifoldCFException ignore) {
            // empty catch block
        }
        String conTimeout = this.getParam(parameters, "genericConnectionTimeout", "60000");
        String soTimeout = this.getParam(parameters, "genericSocketTimeout", "1800000");
        if (tabName.equals(Messages.getString(locale, "generic.EntryPoint"))) {
            out.print("<table class=\"displaytable\">\n <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n <tr>\n  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.EntryPointColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericEntryPoint\" value=\"" + Encoder.attributeEscape((String)server) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.LoginColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericLogin\" value=\"" + Encoder.attributeEscape((String)login) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.PasswordColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"password\" size=\"32\" name=\"genericPassword\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ConnectionTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericConTimeout\" value=\"" + Encoder.attributeEscape((String)conTimeout) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.SocketTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericSoTimeout\" value=\"" + Encoder.attributeEscape((String)soTimeout) + "\"/></td>\n" + " </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"genericEntryPoint\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericLogin\" value=\"" + Encoder.attributeEscape((String)login) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericPassword\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericConTimeout\" value=\"" + Encoder.attributeEscape((String)conTimeout) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericSoTimeout\" value=\"" + Encoder.attributeEscape((String)soTimeout) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        this.copyParam(variableContext, parameters, "genericLogin");
        this.copyParam(variableContext, parameters, "genericEntryPoint");
        this.copyParam(variableContext, parameters, "genericConTimeout");
        this.copyParam(variableContext, parameters, "genericSoTimeout");
        String password = variableContext.getParameter("genericPassword");
        if (password == null) {
            password = "";
        }
        parameters.setParameter("genericPassword", ManifoldCF.obfuscate((String)password));
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        String login = this.getParam(parameters, "genericLogin", "");
        String server = this.getParam(parameters, "genericEntryPoint", "");
        String conTimeout = this.getParam(parameters, "genericConnectionTimeout", "60000");
        String soTimeout = this.getParam(parameters, "genericSocketTimeout", "1800000");
        out.print("<table class=\"displaytable\">\n <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n <tr>\n  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.EntryPointColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)server) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.LoginColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)login) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.PasswordColon") + "</nobr></td>\n" + "  <td class=\"value\">**********</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ConnectionTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)conTimeout) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.SocketTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)soTimeout) + "</td>\n" + " </tr>\n" + "</table>\n");
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "generic.Parameters"));
        tabsArray.add(Messages.getString(locale, "generic.Security"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue) {\n" + "  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n" + "  postFormSetAnchor(anchorvalue);\n" + "}\n" + "\n" + "function " + seqPrefix + "SpecAddToken(anchorvalue) {\n" + "  if (editjob." + seqPrefix + "spectoken.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "generic.TypeInAnAccessToken") + "\");\n" + "    editjob." + seqPrefix + "spectoken.focus();\n" + "    return;\n" + "  }\n" + "  " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n" + "}\n" + "function " + seqPrefix + "SpecAddParam(anchorvalue) {\n" + "  if (editjob." + seqPrefix + "specparamname.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "generic.TypeInParamName") + "\");\n" + "    editjob." + seqPrefix + "specparamname.focus();\n" + "    return;\n" + "  }\n" + "  " + seqPrefix + "SpecOp(\"" + seqPrefix + "paramop\",\"Add\",anchorvalue);\n" + "}\n" + "//-->\n" + "</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String accessDescription;
        SpecificationNode sn;
        SpecificationNode sn2;
        int k;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (tabName.equals(Messages.getString(locale, "generic.Parameters")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\"><tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ParametersColon") + "</nobr></td>" + "<td class=\"value\">");
            out.print("<table class=\"formtable\">\n<tr class=\"formheaderrow\"><td class=\"formcolumnheader\"></td><td class=\"formcolumnheader\">" + Messages.getBodyString(locale, "generic.ParameterName") + "</td>" + "<td class=\"formcolumnheader\">" + Messages.getBodyString(locale, "generic.ParameterValue") + "</td>" + "</tr>");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn2 = ds.getChild(i++)).getType().equals("param")) continue;
                String paramDescription = "_" + Integer.toString(k);
                String paramOpName = seqPrefix + "paramop" + paramDescription;
                String paramName = sn2.getAttributeValue("name");
                String paramValue = sn2.getValue();
                out.print("  <tr class=\"evenformrow\">\n    <td class=\"formcolumncell\">\n      <input type=\"hidden\" name=\"" + paramOpName + "\" value=\"\"/>\n" + "      <a name=\"" + seqPrefix + "param_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "generic.Delete") + "\" onClick='Javascript:SpecOp(\"" + paramOpName + "\",\"Delete\",\"param" + paramDescription + "\")' alt=\"" + Messages.getAttributeString(locale, "generic.DeleteParameter") + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"formcolumncell\">\n" + "      <input type=\"text\" name=\"" + seqPrefix + "specparamname" + paramDescription + "\" value=\"" + Encoder.attributeEscape((String)paramName) + "\"/>\n" + "    </td>\n" + "    <td class=\"formcolumncell\">\n" + "      <input type=\"text\" name=\"" + seqPrefix + "specparamvalue" + paramDescription + "\" value=\"" + Encoder.attributeEscape((String)paramValue) + "\"/>\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"3\">" + Messages.getBodyString(locale, "generic.NoParametersSpecified") + "</td>\n" + "  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"3\"><hr/></td></tr>\n  <tr class=\"evenformrow\">\n    <td class=\"formcolumncell\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "paramcount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"" + seqPrefix + "paramop\" value=\"\"/>\n" + "      <a name=\"" + seqPrefix + "param_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "generic.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecAddParam(\"" + seqPrefix + "param_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "generic.AddParameter") + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"formcolumncell\">\n" + "      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "specparamname\" value=\"\"/>\n" + "    </td>\n" + "    <td class=\"formcolumncell\">\n" + "      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "specparamvalue\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
            out.print("</td></tr></table>");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn2 = ds.getChild(i++)).getType().equals("param")) continue;
                String accessDescription2 = "_" + Integer.toString(k);
                String paramName = sn2.getAttributeValue("name");
                String paramValue = sn2.getValue();
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specparamname" + accessDescription2 + "\" value=\"" + Encoder.attributeEscape((String)paramName) + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "specparamvalue" + accessDescription2 + "\" value=\"" + Encoder.attributeEscape((String)paramValue) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "paramcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        String genericAuthMode = "provided";
        for (i = 0; i < ds.getChildCount(); ++i) {
            sn = ds.getChild(i);
            if (!sn.getType().equals("genericAuthMode")) continue;
            genericAuthMode = sn.getValue();
        }
        if (tabName.equals(Messages.getString(locale, "generic.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            out.print("  <tr>\n    <td class=\"description\">" + Messages.getBodyString(locale, "generic.AuthMode") + "</td>\n" + "    <td class=\"value\" >\n" + "      <input type=\"radio\" name=\"" + seqPrefix + "genericAuthMode\" value=\"provided\" " + ("provided".equals(genericAuthMode) ? "checked=\"checked\"" : "") + "/>" + Messages.getBodyString(locale, "generic.AuthModeProvided") + "<br/>\n" + "      <input type=\"radio\" name=\"" + seqPrefix + "genericAuthMode\" value=\"forced\" " + ("forced".equals(genericAuthMode) ? "checked=\"checked\"" : "") + "/>" + Messages.getBodyString(locale, "generic.AuthModeForced") + "<br/>\n" + "    </td>\n" + "  </tr>\n");
            out.print("<tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.TokensColon") + "</nobr></td>" + "<td class=\"value\">");
            out.print("<table class=\"formtable\">\n<tr class=\"formheaderrow\"><td class=\"formcolumnheader\"></td><td class=\"formcolumnheader\">" + Messages.getBodyString(locale, "generic.Token") + "</td>" + "</tr>");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr class=\"evenformrow\">\n    <td class=\"formcolumncell\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n" + "      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "generic.Delete") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "generic.DeleteToken") + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"formcolumncell\">\n" + "      " + Encoder.bodyEscape((String)token) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "generic.NoAccessTokensSpecified") + "</td>\n" + "  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr class=\"evenformrow\">\n    <td class=\"formcolumncell\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n" + "      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "generic.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "generic.AddAccessToken") + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"formcolumncell\">\n" + "      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
            out.print("</td></tr></table>");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "genericAuthMode\" value=\"" + Encoder.attributeEscape((String)genericAuthMode) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode sn;
        int i;
        String redmineAuthMode;
        SpecificationNode node;
        SpecificationNode node2;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String xc = variableContext.getParameter(seqPrefix + "paramcount");
        if (xc != null) {
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i2);
                if (sn2.getType().equals("param")) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            int accessCount = Integer.parseInt(xc);
            i2 = 0;
            while (i2 < accessCount) {
                String paramDescription = "_" + Integer.toString(i2);
                String paramOpName = seqPrefix + "paramop" + paramDescription;
                xc = variableContext.getParameter(paramOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i2;
                    continue;
                }
                String paramName = variableContext.getParameter(seqPrefix + "specparamname" + paramDescription);
                String paramValue = variableContext.getParameter(seqPrefix + "specparamvalue" + paramDescription);
                node2 = new SpecificationNode("param");
                node2.setAttribute("name", paramName);
                node2.setValue(paramValue);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
                ++i2;
            }
            String op = variableContext.getParameter(seqPrefix + "paramop");
            if (op != null && op.equals("Add")) {
                String paramName = variableContext.getParameter(seqPrefix + "specparamname");
                String paramValue = variableContext.getParameter(seqPrefix + "specparamvalue");
                node = new SpecificationNode("param");
                node.setAttribute("name", paramName);
                node.setValue(paramValue);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((redmineAuthMode = variableContext.getParameter(seqPrefix + "genericAuthMode")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("genericAuthMode")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode cn = new SpecificationNode("genericAuthMode");
            cn.setValue(redmineAuthMode);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                node2 = new SpecificationNode("access");
                node2.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        int i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("param")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.Parameters") + "</nobr></td>\n" + "    <td class=\"value\">\n");
                seenAny = true;
            }
            String paramName = sn.getAttributeValue("name");
            String paramValue = sn.getValue();
            out.print(Encoder.bodyEscape((String)paramName) + " = " + Encoder.bodyEscape((String)paramValue) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"4\"><nobr>" + Messages.getBodyString(locale, "generic.NoParametersSpecified") + "</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
        i = 0;
        seenAny = false;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.AccessTokens") + "</nobr></td>\n" + "    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print(Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"4\"><nobr>" + Messages.getBodyString(locale, "generic.NoAccessTokensSpecified") + "</nobr></td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
    }

    private String getParam(ConfigParams parameters, String name, String def) {
        return parameters.getParameter(name) != null ? parameters.getParameter(name) : def;
    }

    private boolean copyParam(IPostParameters variableContext, ConfigParams parameters, String name) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            return false;
        }
        parameters.setParameter(name, val);
        return true;
    }

    protected static String[] getAcls(Specification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            map.put(token, token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    public static class SAXSeedingHandler
    extends DefaultHandler {
        protected XThreadStringBuffer seedBuffer;

        public SAXSeedingHandler(XThreadStringBuffer seedBuffer) {
            this.seedBuffer = seedBuffer;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (GenericConnector.ACTION_SEED.equals(localName) && attributes.getValue("id") != null) {
                try {
                    this.seedBuffer.add(attributes.getValue("id"));
                }
                catch (InterruptedException ex) {
                    throw new SAXException("Adding seed failed: " + ex.getMessage(), ex);
                }
            }
        }
    }

    protected static class ExecuteProcessThread
    extends Thread {
        protected final HttpClient client;
        protected final String url;
        protected Throwable exception = null;
        protected XThreadInputStream threadStream;
        protected boolean abortThread = false;
        protected long streamLength = 0L;

        public ExecuteProcessThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpGet method = new HttpGet(this.url);
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.exception = new ManifoldCFException("processDocuments error - interface returned incorrect return code for: " + this.url + " - " + response.getStatusLine().toString());
                        return;
                    }
                    ExecuteProcessThread executeProcessThread = this;
                    synchronized (executeProcessThread) {
                        if (!this.abortThread) {
                            this.streamLength = response.getEntity().getContentLength();
                            this.threadStream = new XThreadInputStream(response.getEntity().getContent());
                            this.notifyAll();
                        }
                    }
                    if (this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                catch (Throwable ex) {
                    this.exception = ex;
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, ManifoldCFException {
            while (true) {
                ExecuteProcessThread executeProcessThread = this;
                synchronized (executeProcessThread) {
                    if (this.exception != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.exception);
                    if (this.threadStream != null) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getStreamLength() throws IOException, InterruptedException, ManifoldCFException {
            while (true) {
                ExecuteProcessThread executeProcessThread = this;
                synchronized (executeProcessThread) {
                    if (this.exception != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.exception);
                    if (this.threadStream != null) {
                        return this.streamLength;
                    }
                    this.wait();
                }
            }
        }

        protected synchronized void checkException(Throwable exception) throws IOException, ManifoldCFException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof ManifoldCFException) {
                    throw (ManifoldCFException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishUp() throws InterruptedException, IOException, ManifoldCFException {
            ExecuteProcessThread executeProcessThread = this;
            synchronized (executeProcessThread) {
                if (this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
            this.join();
            this.checkException(this.exception);
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected static class DocumentVersionThread
    extends Thread {
        protected final HttpClient client;
        protected final String url;
        protected Throwable exception = null;
        protected final String[] versions;
        protected final ConcurrentHashMap<String, Item> documentCache;
        protected final String[] documentIdentifiers;
        protected final String genericAuthMode;
        protected final String defaultRights;

        public DocumentVersionThread(HttpClient client, String url, String[] documentIdentifiers, String genericAuthMode, String defaultRights, ConcurrentHashMap<String, Item> documentCache) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
            this.documentCache = documentCache;
            this.documentIdentifiers = documentIdentifiers;
            this.genericAuthMode = genericAuthMode;
            this.defaultRights = defaultRights;
            this.versions = new String[documentIdentifiers.length];
            for (int i = 0; i < this.versions.length; ++i) {
                this.versions[i] = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpGet method = new HttpGet(this.url.toString());
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.exception = new ManifoldCFException("addSeedDocuments error - interface returned incorrect return code for: " + this.url + " - " + response.getStatusLine().toString());
                        return;
                    }
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Items.class});
                    Unmarshaller m = context.createUnmarshaller();
                    Items items = (Items)m.unmarshal(response.getEntity().getContent());
                    if (items.items != null) {
                        block8: for (Item item : items.items) {
                            this.documentCache.put(item.id, item);
                            for (int i = 0; i < this.versions.length; ++i) {
                                if (!this.documentIdentifiers[i].equals(item.id)) continue;
                                if ("provided".equals(this.genericAuthMode)) {
                                    this.versions[i] = item.getVersionString();
                                    continue block8;
                                }
                                this.versions[i] = item.version + this.defaultRights;
                                continue block8;
                            }
                        }
                    }
                }
                catch (JAXBException ex) {
                    this.exception = ex;
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public String[] finishUp() throws ManifoldCFException, ServiceInterruption, IOException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof ServiceInterruption) {
                    throw (ServiceInterruption)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new ManifoldCFException("getDocumentVersions error: " + thr.getMessage(), thr);
            }
            return this.versions;
        }
    }

    protected static class ExecuteSeedingThread
    extends Thread {
        protected final HttpClient client;
        protected final String url;
        protected final XThreadStringBuffer seedBuffer;
        protected Throwable exception = null;

        public ExecuteSeedingThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
            this.seedBuffer = new XThreadStringBuffer();
        }

        public XThreadStringBuffer getBuffer() {
            return this.seedBuffer;
        }

        public void finishUp() throws InterruptedException {
            this.seedBuffer.abandon();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpGet method = new HttpGet(this.url.toString());
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.exception = new ManifoldCFException("addSeedDocuments error - interface returned incorrect return code for: " + this.url + " - " + response.getStatusLine().toString());
                        return;
                    }
                    try {
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        SAXParser parser = factory.newSAXParser();
                        SAXSeedingHandler handler = new SAXSeedingHandler(this.seedBuffer);
                        parser.parse(response.getEntity().getContent(), (DefaultHandler)handler);
                    }
                    catch (FactoryConfigurationError ex) {
                        this.exception = new ManifoldCFException("addSeedDocuments error: " + ex.getMessage(), (Throwable)ex);
                    }
                    catch (ParserConfigurationException ex) {
                        this.exception = new ManifoldCFException("addSeedDocuments error: " + ex.getMessage(), (Throwable)ex);
                    }
                    catch (SAXException ex) {
                        this.exception = new ManifoldCFException("addSeedDocuments error: " + ex.getMessage(), (Throwable)ex);
                    }
                    this.seedBuffer.signalDone();
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected static class CheckThread
    extends Thread {
        protected HttpClient client;
        protected String url;
        protected Throwable exception = null;
        protected String result = "Unknown";

        public CheckThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpGet method = new HttpGet(this.url);
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.result = "Connection failed: " + response.getStatusLine().getReasonPhrase();
                        return;
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    this.result = "Connection OK";
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getResult() {
            return this.result;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private Credentials credentials;

        public PreemptiveAuth(Credentials creds) {
            this.credentials = creds;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(new BasicScheme(StandardCharsets.US_ASCII).authenticate(this.credentials, request, context));
        }
    }
}

