/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.alfresco;

import java.io.IOException;
import java.rmi.RemoteException;
import org.alfresco.webservice.repository.RepositoryFault;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Node;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.util.AuthenticationDetails;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.crawler.connectors.alfresco.Constants;
import org.apache.manifoldcf.crawler.system.Logging;

public class NodeUtils {
    private static final String NODE_REFERENCE_SPLIT = "/";

    public static Node get(String endpoint, String username, String password, int socketTimeout, AuthenticationDetails session, Predicate predicate) throws IOException {
        Node[] resultNodes = null;
        try {
            WebServiceFactory.setEndpointAddress((String)endpoint);
            WebServiceFactory.setTimeoutMilliseconds((int)socketTimeout);
            AuthenticationUtils.startSession((String)username, (String)password);
            session = AuthenticationUtils.getAuthenticationDetails();
            resultNodes = WebServiceFactory.getRepositoryService().get(predicate);
            AuthenticationUtils.endSession();
        }
        catch (RepositoryFault e) {
            Logging.connectors.error((Object)("Alfresco: RepositoryFault during getting a node in processDocuments. Node: " + predicate.getNodes()[0].getPath() + ". " + e.getMessage()), (Throwable)e);
            throw new IOException("Alfresco: RepositoryFault during getting a node in processDocuments. Node: " + predicate.getNodes()[0].getPath() + ". " + e.getMessage(), e);
        }
        catch (RemoteException e) {
            Logging.connectors.error((Object)("Alfresco: Remote exception error during getting a node in processDocuments. Node: " + predicate.getNodes()[0].getPath() + ". " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            session = null;
        }
        if (resultNodes != null && resultNodes.length > 0) {
            return resultNodes[0];
        }
        return null;
    }

    public static boolean isVersioned(String[] aspects) {
        for (String aspect : aspects) {
            if (!Constants.ASPECT_VERSIONABLE.equals(aspect)) continue;
            return true;
        }
        return false;
    }

    public static String getVersionLabel(NamedValue[] properties) {
        for (NamedValue property : properties) {
            if (!property.getName().equals(Constants.PROP_VERSION_LABEL)) continue;
            return property.getValue();
        }
        return "";
    }

    public static String getUuidFromNodeReference(String nodeReference) {
        String uuid = "";
        String[] nodeReferenceSplitted = StringUtils.split((String)nodeReference, (String)NODE_REFERENCE_SPLIT);
        if (nodeReferenceSplitted != null && nodeReferenceSplitted.length > 2 && StringUtils.isNotEmpty((String)nodeReferenceSplitted[2])) {
            uuid = nodeReferenceSplitted[2];
        }
        return uuid;
    }
}

