/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;

public class RandomAccessSparseVector
extends AbstractVector {
    private static final int INITIAL_CAPACITY = 11;
    private Int2DoubleOpenHashMap values;

    public RandomAccessSparseVector() {
        super(0);
    }

    public RandomAccessSparseVector(int cardinality) {
        this(cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(int cardinality, int initialCapacity) {
        super(cardinality);
        this.values = new Int2DoubleOpenHashMap(initialCapacity, 0.5f);
    }

    public RandomAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        for (Vector.Element e : other.nonZeroes()) {
            this.values.put(e.index(), e.get());
        }
    }

    private RandomAccessSparseVector(int cardinality, Int2DoubleOpenHashMap values) {
        super(cardinality);
        this.values = values;
    }

    public RandomAccessSparseVector(RandomAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : other.values.clone();
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new SparseMatrix(rows, columns);
    }

    @Override
    public RandomAccessSparseVector clone() {
        return new RandomAccessSparseVector(this.size(), this.values.clone());
    }

    @Override
    public String toString() {
        return this.sparseVectorToString();
    }

    @Override
    public Vector assign(Vector other) {
        if (this.size() != other.size()) {
            throw new CardinalityException(this.size(), other.size());
        }
        this.values.clear();
        for (Vector.Element e : other.nonZeroes()) {
            this.setQuick(e.index(), e.get());
        }
        return this;
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        for (int i = 0; i < updates.getNumMappings(); ++i) {
            this.values.put(updates.getIndices()[i], updates.getValues()[i]);
        }
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.invalidateCachedLength();
        if (value == 0.0) {
            this.values.remove(index);
        } else {
            this.values.put(index, value);
        }
    }

    @Override
    public void incrementQuick(int index, double increment) {
        this.invalidateCachedLength();
        this.values.addTo(index, increment);
    }

    @Override
    public RandomAccessSparseVector like() {
        return new RandomAccessSparseVector(this.size(), this.values.size());
    }

    @Override
    public Vector like(int cardinality) {
        return new RandomAccessSparseVector(cardinality, this.values.size());
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.size();
    }

    @Override
    public int getNumNonZeroElements() {
        DoubleIterator iterator = this.values.values().iterator();
        int numNonZeros = 0;
        int i = this.values.size();
        while (i-- != 0) {
            if (iterator.nextDouble() == 0.0) continue;
            ++numNonZeros;
        }
        return numNonZeros;
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.35;
    }

    @Override
    public boolean isAddConstantTime() {
        return true;
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonZeroIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    private final class AllIterator
    implements Iterator<Vector.Element> {
        private final GeneralElement element;

        private AllIterator() {
            this.element = new GeneralElement();
            this.element.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.element.index + 1 < RandomAccessSparseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.value = RandomAccessSparseVector.this.values.get(++this.element.index);
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class GeneralElement
    implements Vector.Element {
        int index;
        double value;

        GeneralElement() {
        }

        @Override
        public double get() {
            return this.value;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            RandomAccessSparseVector.this.invalidateCachedLength();
            if (value == 0.0) {
                RandomAccessSparseVector.this.values.remove(this.index);
            } else {
                RandomAccessSparseVector.this.values.put(this.index, value);
            }
        }
    }

    final class RandomAccessElement
    implements Vector.Element {
        Int2DoubleMap.Entry entry;
        final ObjectIterator<Int2DoubleMap.Entry> fastIterator;

        public RandomAccessElement(ObjectIterator<Int2DoubleMap.Entry> fastIterator) {
            this.fastIterator = fastIterator;
        }

        @Override
        public double get() {
            return this.entry.getDoubleValue();
        }

        @Override
        public int index() {
            return this.entry.getIntKey();
        }

        @Override
        public void set(double value) {
            RandomAccessSparseVector.this.invalidateCachedLength();
            if (value == 0.0) {
                this.fastIterator.remove();
            } else {
                this.entry.setValue(value);
            }
        }
    }

    private final class NonZeroIterator
    implements Iterator<Vector.Element> {
        final ObjectIterator<Int2DoubleMap.Entry> fastIterator;
        final RandomAccessElement element;

        private NonZeroIterator() {
            this.fastIterator = RandomAccessSparseVector.this.values.int2DoubleEntrySet().fastIterator();
            this.element = new RandomAccessElement(this.fastIterator);
        }

        @Override
        public boolean hasNext() {
            return this.fastIterator.hasNext();
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.entry = (Int2DoubleMap.Entry)this.fastIterator.next();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

