/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.HashMap;
import org.apache.mahout.common.io.GenericMatrixKryoSerializer$;
import org.apache.mahout.logging.package$;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.DenseSymmetricMatrix;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.UpperTriangular;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.flavor.TraversingStructureEnum;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dr!B\u0001\u0003\u0011\u0003i\u0011aG$f]\u0016\u0014\u0018nY'biJL\u0007p\u0013:z_N+'/[1mSj,'O\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\taaY8n[>t'BA\u0004\t\u0003\u0019i\u0017\r[8vi*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u00111dR3oKJL7-T1ue&D8J]=p'\u0016\u0014\u0018.\u00197ju\u0016\u00148CA\b\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011d\u0004C\u00015\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\b9=\u0011\r\u0011b\u0004\u001e\u0003\rawnZ\u000b\u0002=A\u0011qDI\u0007\u0002A)\u0011\u0011\u0005C\u0001\u0006Y><GG[\u0005\u0003G\u0001\u0012a\u0001T8hO\u0016\u0014\bBB\u0013\u0010A\u00035a$\u0001\u0003m_\u001e\u0004c\u0001\u0002\t\u0003\u0001\u001d\u001a\"A\n\u0015\u0011\u0007%\u0002$'D\u0001+\u0015\tYC&\u0001\u0003lef|'BA\u0017/\u0003A)7o\u001c;fe&\u001c7o\u001c4uo\u0006\u0014XMC\u00010\u0003\r\u0019w.\\\u0005\u0003c)\u0012!bU3sS\u0006d\u0017N_3s!\t\u0019d'D\u00015\u0015\t)d!\u0001\u0003nCRD\u0017BA\u001c5\u0005\u0019i\u0015\r\u001e:jq\")\u0011D\nC\u0001sQ\t!\b\u0005\u0002\u000fM!)AH\nC!{\u0005)qO]5uKR!a(Q#M!\t\u0019r(\u0003\u0002A)\t!QK\\5u\u0011\u0015Y3\b1\u0001C!\tI3)\u0003\u0002EU\t!1J]=p\u0011\u001515\b1\u0001H\u0003\u0019yW\u000f\u001e9viB\u0011\u0001JS\u0007\u0002\u0013*\u00111AK\u0005\u0003\u0017&\u0013aaT;uaV$\b\"B'<\u0001\u0004\u0011\u0014AA7y\u0011\u0015ye\u0005\"\u0003Q\u0003E9(/\u001b;f-\u0016\u001cGo\u001c:CC\u000e\\W\r\u001a\u000b\u0005}E\u00136\u000bC\u0003,\u001d\u0002\u0007!\tC\u0003G\u001d\u0002\u0007q\tC\u0003N\u001d\u0002\u0007!\u0007C\u0003VM\u0011%a+\u0001\tsK\u0006$g+Z2u_J\u0014\u0015mY6fIR)!g\u0016-^E\")1\u0006\u0016a\u0001\u0005\")\u0011\f\u0016a\u00015\u0006)\u0011N\u001c9viB\u0011\u0001jW\u0005\u00039&\u0013Q!\u00138qkRDQA\u0018+A\u0002}\u000bAA\u001c:poB\u00111\u0003Y\u0005\u0003CR\u00111!\u00138u\u0011\u0015\u0019G\u000b1\u0001`\u0003\u0011q7m\u001c7\t\u000b\u00154C\u0011\u00024\u0002\u0019]\u0014\u0018\u000e^3S_^<\u0016n]3\u0015\ty:\u0007.\u001b\u0005\u0006W\u0011\u0004\rA\u0011\u0005\u0006\r\u0012\u0004\ra\u0012\u0005\u0006\u001b\u0012\u0004\rA\r\u0005\u0006W\u001a\"I\u0001\\\u0001\te\u0016\fGMU8xgR!Qn\u001d;v!\r\u0019b\u000e]\u0005\u0003_R\u0011Q!\u0011:sCf\u0004\"aM9\n\u0005I$$A\u0002,fGR|'\u000fC\u0003,U\u0002\u0007!\tC\u0003ZU\u0002\u0007!\fC\u0003_U\u0002\u0007q\fC\u0003xM\u0011%\u00010\u0001\bsK\u0006$7\u000b]1sg\u0016\u0014vn^:\u0015\u0007elh\u0010E\u0002\u0014]j\u0004BaE>`a&\u0011A\u0010\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000b-2\b\u0019\u0001\"\t\u000be3\b\u0019\u0001.\t\u000f\u0005\u0005a\u0005\"\u0003\u0002\u0004\u0005\u0011rO]5uKN\u0003\u0018M]:f%><x+[:f)\u001dq\u0014QAA\u0004\u0003\u0013AQaK@A\u0002\tCQAR@A\u0002\u001dCQ!T@A\u0002IBq!!\u0004'\t\u0003\ny!\u0001\u0003sK\u0006$Gc\u0002\u001a\u0002\u0012\u0005M\u0011Q\u0003\u0005\u0007W\u0005-\u0001\u0019\u0001\"\t\re\u000bY\u00011\u0001[\u0011!\t9\"a\u0003A\u0002\u0005e\u0011aB7y\u00072\f7o\u001d\t\u0006\u00037\t\tC\r\b\u0004'\u0005u\u0011bAA\u0010)\u00051\u0001K]3eK\u001aLA!a\t\u0002&\t)1\t\\1tg*\u0019\u0011q\u0004\u000b")
public class GenericMatrixKryoSerializer
extends Serializer<Matrix> {
    public void write(Kryo kryo, Output output, Matrix mx) {
        package$.MODULE$.debug((Function0<Object>)new Serializable(this, mx){
            public static final long serialVersionUID = 0L;
            private final Matrix mx$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing mx of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mx$1.getClass().getName()}));
            }
            {
                this.mx$1 = mx$1;
            }
        }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
        TraversingStructureEnum structure = mx.getFlavor().getStructure();
        output.writeInt(structure.ordinal(), true);
        output.writeInt(RLikeOps$.MODULE$.m2mOps(mx).nrow(), true);
        output.writeInt(RLikeOps$.MODULE$.m2mOps(mx).ncol(), true);
        TraversingStructureEnum traversingStructureEnum = structure;
        if (((Object)((Object)TraversingStructureEnum.COLWISE)).equals((Object)traversingStructureEnum)) {
            this.writeRowWise(kryo, output, RLikeOps$.MODULE$.m2mOps(mx).t());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)TraversingStructureEnum.SPARSECOLWISE)).equals((Object)traversingStructureEnum)) {
            this.writeSparseRowWise(kryo, output, RLikeOps$.MODULE$.m2mOps(mx).t());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)TraversingStructureEnum.SPARSEROWWISE)).equals((Object)traversingStructureEnum)) {
            this.writeSparseRowWise(kryo, output, mx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)TraversingStructureEnum.VECTORBACKED)).equals((Object)traversingStructureEnum)) {
            this.writeVectorBacked(kryo, output, mx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.writeRowWise(kryo, output, mx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void writeVectorBacked(Kryo kryo, Output output, Matrix mx) {
        block5: {
            block3: {
                Matrix matrix;
                block4: {
                    block2: {
                        Predef$.MODULE$.require(mx != null);
                        kryo.writeClass(output, mx.getClass());
                        matrix = mx;
                        if (!(matrix instanceof DiagonalMatrix)) break block2;
                        DiagonalMatrix diagonalMatrix = (DiagonalMatrix)matrix;
                        kryo.writeObject(output, (Object)RLikeOps$.MODULE$.m2mOps(diagonalMatrix).diagv());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(matrix instanceof DenseSymmetricMatrix)) break block4;
                    DenseSymmetricMatrix denseSymmetricMatrix = (DenseSymmetricMatrix)matrix;
                    kryo.writeObject(output, (Object)org.apache.mahout.math.scalabindings.package$.MODULE$.dvec((TraversableOnce<Object>)Predef$.MODULE$.doubleArrayOps(denseSymmetricMatrix.getData())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(matrix instanceof UpperTriangular)) break block5;
                UpperTriangular upperTriangular = (UpperTriangular)matrix;
                kryo.writeObject(output, (Object)org.apache.mahout.math.scalabindings.package$.MODULE$.dvec((TraversableOnce<Object>)Predef$.MODULE$.doubleArrayOps(upperTriangular.getData())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported matrix type:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mx.getClass().getName()})));
    }

    private Matrix readVectorBacked(Kryo kryo, Input input, int nrow, int ncol) {
        Class clazz = kryo.readClass(input).getType();
        package$.MODULE$.debug((Function0<Object>)new Serializable(this, clazz){
            public static final long serialVersionUID = 0L;
            private final Class clazz$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deserializing vector-backed mx of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clazz$1.getName()}));
            }
            {
                this.clazz$1 = clazz$1;
            }
        }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
        return (Matrix)clazz.getConstructor(Vector.class).newInstance(kryo.readObject(input, Vector.class));
    }

    private void writeRowWise(Kryo kryo, Output output, Matrix mx) {
        JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)mx).foreach((Function1)new Serializable(this, kryo, output){
            public static final long serialVersionUID = 0L;
            private final Kryo kryo$1;
            private final Output output$1;

            public final void apply(MatrixSlice row) {
                this.kryo$1.writeObject(this.output$1, (Object)row);
            }
            {
                this.kryo$1 = kryo$1;
                this.output$1 = output$1;
            }
        });
    }

    private Vector[] readRows(Kryo kryo, Input input, int nrow) {
        return (Vector[])Array$.MODULE$.tabulate(nrow, (Function1)new Serializable(this, kryo, input){
            public static final long serialVersionUID = 0L;
            private final Kryo kryo$3;
            private final Input input$1;

            public final Vector apply(int x$1) {
                return (Vector)this.kryo$3.readObject(this.input$1, Vector.class);
            }
            {
                this.kryo$3 = kryo$3;
                this.input$1 = input$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    private Tuple2<Object, Vector>[] readSparseRows(Kryo kryo, Input input) {
        int nslices = input.readInt(true);
        return (Tuple2[])Array$.MODULE$.tabulate(nslices, (Function1)new Serializable(this, kryo, input){
            public static final long serialVersionUID = 0L;
            private final Kryo kryo$4;
            private final Input input$2;

            public final Tuple2<Object, Vector> apply(int x$2) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.input$2.readInt(true))), this.kryo$4.readObject(this.input$2, Vector.class));
            }
            {
                this.kryo$4 = kryo$4;
                this.input$2 = input$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private void writeSparseRowWise(Kryo kryo, Output output, Matrix mx) {
        int nslices = mx.numSlices();
        output.writeInt(nslices, true);
        IntRef actualNSlices = IntRef.create((int)0);
        JavaConversions$.MODULE$.asScalaIterator(mx.iterateNonEmpty()).foreach((Function1)new Serializable(this, kryo, output, actualNSlices){
            public static final long serialVersionUID = 0L;
            private final Kryo kryo$2;
            private final Output output$2;
            private final IntRef actualNSlices$1;

            public final void apply(MatrixSlice row) {
                this.output$2.writeInt(row.index(), true);
                this.kryo$2.writeObject(this.output$2, (Object)row.vector());
                ++this.actualNSlices$1.elem;
            }
            {
                this.kryo$2 = kryo$2;
                this.output$2 = output$2;
                this.actualNSlices$1 = actualNSlices$1;
            }
        });
        Predef$.MODULE$.require(nslices == actualNSlices.elem, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of slices reported by Matrix.numSlices() was different from actual slice iterator size.";
            }
        });
    }

    public Matrix read(Kryo kryo, Input input, Class<Matrix> mxClass) {
        Matrix matrix;
        TraversingStructureEnum structure = TraversingStructureEnum.values()[input.readInt(true)];
        int nrow = input.readInt(true);
        int ncol = input.readInt(true);
        package$.MODULE$.debug((Function0<Object>)new Serializable(this, nrow, ncol){
            public static final long serialVersionUID = 0L;
            private final int nrow$1;
            private final int ncol$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read matrix geometry: ", " x ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nrow$1), BoxesRunTime.boxToInteger((int)this.ncol$1)}));
            }
            {
                this.nrow$1 = nrow$1;
                this.ncol$1 = ncol$1;
            }
        }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
        TraversingStructureEnum traversingStructureEnum = structure;
        if (((Object)((Object)TraversingStructureEnum.COLWISE)).equals((Object)traversingStructureEnum)) {
            Matrix matrix2;
            Vector[] cols = this.readRows(kryo, input, ncol);
            if (!Predef$.MODULE$.refArrayOps((Object[])cols).isEmpty() && ((Vector)Predef$.MODULE$.refArrayOps((Object[])cols).head()).isDense()) {
                matrix2 = RLikeOps$.MODULE$.m2mOps(org.apache.mahout.math.scalabindings.package$.MODULE$.dense(Predef$.MODULE$.wrapRefArray((Object[])new Vector[][]{cols}))).t();
            } else {
                package$.MODULE$.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Deserializing as SparseRowMatrix.t (COLWISE).";
                    }
                }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
                matrix2 = RLikeOps$.MODULE$.m2mOps(new SparseRowMatrix(ncol, nrow, cols, true, false)).t();
            }
            matrix = matrix2;
        } else if (((Object)((Object)TraversingStructureEnum.SPARSECOLWISE)).equals((Object)traversingStructureEnum)) {
            Tuple2<Object, Vector>[] cols = this.readSparseRows(kryo, input);
            HashMap<Integer, Vector> javamap = new HashMap<Integer, Vector>((Predef$.MODULE$.refArrayOps((Object[])cols).size() << 1) + 1);
            Predef$.MODULE$.refArrayOps((Object[])cols).foreach((Function1)new Serializable(this, javamap){
                public static final long serialVersionUID = 0L;
                private final HashMap javamap$1;

                public final Vector apply(Tuple2<Object, Vector> x0$1) {
                    Tuple2<Object, Vector> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int idx = tuple2._1$mcI$sp();
                        Vector vec = (Vector)tuple2._2();
                        Vector vector = this.javamap$1.put(Predef$.MODULE$.int2Integer(idx), vec);
                        return vector;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.javamap$1 = javamap$1;
                }
            });
            package$.MODULE$.debug((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Deserializing as SparseMatrix.t (SPARSECOLWISE).";
                }
            }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
            matrix = RLikeOps$.MODULE$.m2mOps(new SparseMatrix(ncol, nrow, javamap, true)).t();
        } else if (((Object)((Object)TraversingStructureEnum.SPARSEROWWISE)).equals((Object)traversingStructureEnum)) {
            Tuple2<Object, Vector>[] rows = this.readSparseRows(kryo, input);
            HashMap<Integer, Vector> javamap = new HashMap<Integer, Vector>((Predef$.MODULE$.refArrayOps((Object[])rows).size() << 1) + 1);
            Predef$.MODULE$.refArrayOps((Object[])rows).foreach((Function1)new Serializable(this, javamap){
                public static final long serialVersionUID = 0L;
                private final HashMap javamap$2;

                public final Vector apply(Tuple2<Object, Vector> x0$2) {
                    Tuple2<Object, Vector> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int idx = tuple2._1$mcI$sp();
                        Vector vec = (Vector)tuple2._2();
                        Vector vector = this.javamap$2.put(Predef$.MODULE$.int2Integer(idx), vec);
                        return vector;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.javamap$2 = javamap$2;
                }
            });
            package$.MODULE$.debug((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Deserializing as SparseMatrix (SPARSEROWWISE).";
                }
            }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
            matrix = new SparseMatrix(nrow, ncol, javamap, true);
        } else if (((Object)((Object)TraversingStructureEnum.VECTORBACKED)).equals((Object)traversingStructureEnum)) {
            package$.MODULE$.debug((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Deserializing vector-backed...";
                }
            }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
            matrix = this.readVectorBacked(kryo, input, nrow, ncol);
        } else {
            AbstractMatrix abstractMatrix;
            Vector[] cols = this.readRows(kryo, input, nrow);
            if (!Predef$.MODULE$.refArrayOps((Object[])cols).isEmpty() && ((Vector)Predef$.MODULE$.refArrayOps((Object[])cols).head()).isDense()) {
                package$.MODULE$.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Deserializing as DenseMatrix.";
                    }
                }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
                abstractMatrix = org.apache.mahout.math.scalabindings.package$.MODULE$.dense(Predef$.MODULE$.wrapRefArray((Object[])new Vector[][]{cols}));
            } else {
                package$.MODULE$.debug((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Deserializing as SparseRowMatrix(default).";
                    }
                }, GenericMatrixKryoSerializer$.MODULE$.org$apache$mahout$common$io$GenericMatrixKryoSerializer$$log());
                abstractMatrix = new SparseRowMatrix(nrow, ncol, cols, true, false);
            }
            matrix = abstractMatrix;
        }
        return matrix;
    }
}

