/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractCharSet
extends AbstractSet {
    public boolean contains(final char key) {
        return !this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractCharSet copy() {
        return (AbstractCharSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractCharSet)) {
            return false;
        }
        final AbstractCharSet other = (AbstractCharSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char key) {
                return other.contains(key);
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachKey(new CharProcedure(){
            int i = 0;

            @Override
            public boolean apply(char iterKey) {
                buf[this.i++] = HashUtils.hash(iterKey);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(CharProcedure var1);

    public CharArrayList keys() {
        CharArrayList list = new CharArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final CharArrayList list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(char var1);

    public abstract boolean remove(char var1);

    public String toString() {
        CharArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

