/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.als;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitFeedbackAlternatingLeastSquaresSolver {
    private final int numFeatures;
    private final double alpha;
    private final double lambda;
    private final int numTrainingThreads;
    private final OpenIntObjectHashMap<Vector> Y;
    private final Matrix YtransposeY;
    private static final Logger log = LoggerFactory.getLogger(ImplicitFeedbackAlternatingLeastSquaresSolver.class);

    public ImplicitFeedbackAlternatingLeastSquaresSolver(int numFeatures, double lambda, double alpha, OpenIntObjectHashMap<Vector> Y, int numTrainingThreads) {
        this.numFeatures = numFeatures;
        this.lambda = lambda;
        this.alpha = alpha;
        this.Y = Y;
        this.numTrainingThreads = numTrainingThreads;
        this.YtransposeY = this.getYtransposeY(Y);
    }

    public Vector solve(Vector ratings) {
        return ImplicitFeedbackAlternatingLeastSquaresSolver.solve(this.YtransposeY.plus(this.getYtransponseCuMinusIYPlusLambdaI(ratings)), this.getYtransponseCuPu(ratings));
    }

    private static Vector solve(Matrix A, Matrix y) {
        return new QRDecomposition(A).solve(y).viewColumn(0);
    }

    double confidence(double rating) {
        return 1.0 + this.alpha * rating;
    }

    public Matrix getYtransposeY(final OpenIntObjectHashMap<Vector> Y) {
        ExecutorService queue = Executors.newFixedThreadPool(this.numTrainingThreads);
        if (log.isInfoEnabled()) {
            log.info("Starting the computation of Y'Y");
        }
        long startTime = System.nanoTime();
        final IntArrayList indexes = Y.keys();
        final int numIndexes = indexes.size();
        final double[][] YtY = new double[this.numFeatures][this.numFeatures];
        for (int i = 0; i < this.numFeatures; ++i) {
            int j = i;
            while (j < this.numFeatures) {
                final int ii = i;
                final int jj = j++;
                queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        double dot = 0.0;
                        for (int k = 0; k < numIndexes; ++k) {
                            Vector row = (Vector)Y.get(indexes.getQuick(k));
                            dot += row.getQuick(ii) * row.getQuick(jj);
                        }
                        YtY[ii][jj] = dot;
                        if (ii != jj) {
                            YtY[jj][ii] = dot;
                        }
                    }
                });
            }
        }
        queue.shutdown();
        try {
            queue.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            log.error("Error during Y'Y queue shutdown", (Throwable)e);
            throw new RuntimeException("Error during Y'Y queue shutdown");
        }
        if (log.isInfoEnabled()) {
            log.info("Computed Y'Y in " + (double)(System.nanoTime() - startTime) / 1000000.0 + " ms");
        }
        return new DenseMatrix(YtY, true);
    }

    /*
     * WARNING - void declaration
     */
    private Matrix getYtransponseCuMinusIYPlusLambdaI(Vector userRatings) {
        void var4_7;
        Preconditions.checkArgument((boolean)userRatings.isSequentialAccess(), (Object)"need sequential access to ratings!");
        OpenIntObjectHashMap<Vector> CuMinusIY = new OpenIntObjectHashMap<Vector>(userRatings.getNumNondefaultElements());
        for (Vector.Element element : userRatings.nonZeroes()) {
            CuMinusIY.put(element.index(), this.Y.get(element.index()).times(this.confidence(element.get()) - 1.0));
        }
        DenseMatrix YtransponseCuMinusIY = new DenseMatrix(this.numFeatures, this.numFeatures);
        for (Vector.Element e : userRatings.nonZeroes()) {
            for (Vector.Element feature : this.Y.get(e.index()).all()) {
                Vector partial = ((Vector)CuMinusIY.get(e.index())).times(feature.get());
                YtransponseCuMinusIY.viewRow(feature.index()).assign(partial, Functions.PLUS);
            }
        }
        boolean bl = false;
        while (var4_7 < this.numFeatures) {
            YtransponseCuMinusIY.setQuick((int)var4_7, (int)var4_7, YtransponseCuMinusIY.getQuick((int)var4_7, (int)var4_7) + this.lambda);
            ++var4_7;
        }
        return YtransponseCuMinusIY;
    }

    private Matrix getYtransponseCuPu(Vector userRatings) {
        Preconditions.checkArgument((boolean)userRatings.isSequentialAccess(), (Object)"need sequential access to ratings!");
        DenseVector YtransponseCuPu = new DenseVector(this.numFeatures);
        for (Vector.Element e : userRatings.nonZeroes()) {
            YtransponseCuPu.assign(this.Y.get(e.index()).times(this.confidence(e.get())), Functions.PLUS);
        }
        return this.columnVectorAsMatrix(YtransponseCuPu);
    }

    private Matrix columnVectorAsMatrix(Vector v) {
        double[][] matrix = new double[this.numFeatures][1];
        for (Vector.Element e : v.all()) {
            matrix[e.index()][0] = e.get();
        }
        return new DenseMatrix(matrix, true);
    }
}

