/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.stats;

import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.mahout.classifier.stats.ClassifierResult;
import org.apache.mahout.classifier.stats.ConfusionMatrix;
import org.apache.mahout.classifier.stats.RunningAverageAndStdDev;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u001b\tq!+Z:vYR\fe.\u00197zu\u0016\u0014(BA\u0002\u0005\u0003\u0015\u0019H/\u0019;t\u0015\t)a!\u0001\u0006dY\u0006\u001c8/\u001b4jKJT!a\u0002\u0005\u0002\r5\f\u0007n\\;u\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\nY\t\u0001\u0002\\1cK2\u001cV\r^\u000b\u0002/A\u0019\u0001$H\u0010\u000e\u0003eQ!AG\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0006D_2dWm\u0019;j_:\u0004\"\u0001I\u0012\u000f\u0005=\t\u0013B\u0001\u0012\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0002\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u00131\f'-\u001a7TKR\u0004\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0019\u0011,g-Y;mi2\u000b'-\u001a7\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ris\u0006\r\t\u0003]\u0001i\u0011A\u0001\u0005\u0006+)\u0002\ra\u0006\u0005\u0006S)\u0002\ra\b\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003=\u0019wN\u001c4vg&|g.T1ue&DX#\u0001\u001b\u0011\u00059*\u0014B\u0001\u001c\u0003\u0005=\u0019uN\u001c4vg&|g.T1ue&D\bB\u0002\u001d\u0001A\u0003%A'\u0001\td_:4Wo]5p]6\u000bGO]5yA!9!\b\u0001a\u0001\n\u0013Y\u0014!\u00025bg2cU#\u0001\u001f\u0011\u0005=i\u0014B\u0001 \u0011\u0005\u001d\u0011un\u001c7fC:Dq\u0001\u0011\u0001A\u0002\u0013%\u0011)A\u0005iCNdEj\u0018\u0013fcR\u0011!)\u0012\t\u0003\u001f\rK!\u0001\u0012\t\u0003\tUs\u0017\u000e\u001e\u0005\b\r~\n\t\u00111\u0001=\u0003\rAH%\r\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u001f\u0002\r!\f7\u000f\u0014'!\u0011\u001dQ\u0005\u00011A\u0005\n-\u000b1cY8se\u0016\u001cG\u000f\\=DY\u0006\u001c8/\u001b4jK\u0012,\u0012\u0001\u0014\t\u0003\u001f5K!A\u0014\t\u0003\u0007%sG\u000fC\u0004Q\u0001\u0001\u0007I\u0011B)\u0002/\r|'O]3di2L8\t\\1tg&4\u0017.\u001a3`I\u0015\fHC\u0001\"S\u0011\u001d1u*!AA\u00021Ca\u0001\u0016\u0001!B\u0013a\u0015\u0001F2peJ,7\r\u001e7z\u00072\f7o]5gS\u0016$\u0007\u0005C\u0004W\u0001\u0001\u0007I\u0011B&\u0002+%t7m\u001c:sK\u000e$H._\"mCN\u001c\u0018NZ5fI\"9\u0001\f\u0001a\u0001\n\u0013I\u0016!G5oG>\u0014(/Z2uYf\u001cE.Y:tS\u001aLW\rZ0%KF$\"A\u0011.\t\u000f\u0019;\u0016\u0011!a\u0001\u0019\"1A\f\u0001Q!\n1\u000ba#\u001b8d_J\u0014Xm\u0019;ms\u000ec\u0017m]:jM&,G\r\t\u0005\u0006=\u0002!\taM\u0001\u0013O\u0016$8i\u001c8gkNLwN\\'biJL\u0007\u0010C\u0003a\u0001\u0011\u0005\u0011-A\u0006bI\u0012Len\u001d;b]\u000e,Gc\u0001\u001fcI\")1m\u0018a\u0001?\u0005a1m\u001c:sK\u000e$H*\u00192fY\")Qm\u0018a\u0001M\u0006\u00012\r\\1tg&4\u0017.\u001a3SKN,H\u000e\u001e\t\u0003]\u001dL!\u0001\u001b\u0002\u0003!\rc\u0017m]:jM&,'OU3tk2$\b\"\u00026\u0001\t\u0003Z\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003}\u0001")
public class ResultAnalyzer {
    private final Collection<String> labelSet;
    private final ConfusionMatrix confusionMatrix;
    private boolean hasLL;
    private int correctlyClassified;
    private int incorrectlyClassified;

    private Collection<String> labelSet() {
        return this.labelSet;
    }

    public ConfusionMatrix confusionMatrix() {
        return this.confusionMatrix;
    }

    private boolean hasLL() {
        return this.hasLL;
    }

    private void hasLL_$eq(boolean x$1) {
        this.hasLL = x$1;
    }

    private int correctlyClassified() {
        return this.correctlyClassified;
    }

    private void correctlyClassified_$eq(int x$1) {
        this.correctlyClassified = x$1;
    }

    private int incorrectlyClassified() {
        return this.incorrectlyClassified;
    }

    private void incorrectlyClassified_$eq(int x$1) {
        this.incorrectlyClassified = x$1;
    }

    public ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public boolean addInstance(String correctLabel, ClassifierResult classifiedResult) {
        void var3_4;
        boolean result;
        String string = correctLabel;
        String string2 = classifiedResult.getLabel();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (result = false);
        if (result) {
            this.correctlyClassified_$eq(this.correctlyClassified() + 1);
        } else {
            this.incorrectlyClassified_$eq(this.incorrectlyClassified() + 1);
        }
        this.confusionMatrix().addInstance(correctLabel, classifiedResult);
        return (boolean)var3_4;
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder();
        returnString.append('\n');
        returnString.append("=======================================================\n");
        returnString.append("Summary\n");
        returnString.append("-------------------------------------------------------\n");
        int totalClassified = this.correctlyClassified() + this.incorrectlyClassified();
        double percentageCorrect = (double)100 * (double)this.correctlyClassified() / (double)totalClassified;
        double percentageIncorrect = (double)100 * (double)this.incorrectlyClassified() / (double)totalClassified;
        DecimalFormat decimalFormatter = new DecimalFormat("0.####");
        returnString.append("Correctly Classified Instances").append(": ").append(Integer.toString(this.correctlyClassified())).append('\t').append(decimalFormatter.format(percentageCorrect)).append("%\n");
        returnString.append("Incorrectly Classified Instances").append(": ").append(Integer.toString(this.incorrectlyClassified())).append('\t').append(decimalFormatter.format(percentageIncorrect)).append("%\n");
        returnString.append("Total Classified Instances").append(": ").append(Integer.toString(totalClassified)).append('\n');
        returnString.append('\n');
        returnString.append((Object)this.confusionMatrix());
        returnString.append("=======================================================\n");
        returnString.append("Statistics\n");
        returnString.append("-------------------------------------------------------\n");
        RunningAverageAndStdDev normStats = this.confusionMatrix().getNormalizedStats();
        returnString.append("Kappa: \t").append(decimalFormatter.format(this.confusionMatrix().getKappa())).append('\n');
        returnString.append("Accuracy: \t").append(decimalFormatter.format(this.confusionMatrix().getAccuracy())).append("%\n");
        returnString.append("Reliability: \t").append(decimalFormatter.format(normStats.getAverage() * 100.00000001)).append("%\n");
        returnString.append("Reliability (std dev): \t").append(decimalFormatter.format(normStats.getStandardDeviation())).append('\n');
        returnString.append("Weighted precision: \t").append(decimalFormatter.format(this.confusionMatrix().getWeightedPrecision())).append('\n');
        returnString.append("Weighted recall: \t").append(decimalFormatter.format(this.confusionMatrix().getWeightedRecall())).append('\n');
        returnString.append("Weighted F1 score: \t").append(decimalFormatter.format(this.confusionMatrix().getWeightedF1score())).append('\n');
        return returnString.toString();
    }

    public ResultAnalyzer(Collection<String> labelSet, String defaultLabel) {
        this.labelSet = labelSet;
        this.confusionMatrix = new ConfusionMatrix(labelSet, defaultLabel);
        this.hasLL = false;
        this.correctlyClassified = 0;
        this.incorrectlyClassified = 0;
    }
}

