﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

using Lucene.Net.Support;

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class EnglishStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "arsen", -1, -1 ),
                    new Among ( "commun", -1, -1 ),
                    new Among ( "gener", -1, -1 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "'", -1, 1 ),
                    new Among ( "'s'", 0, 1 ),
                    new Among ( "'s", -1, 1 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "ied", -1, 2 ),
                    new Among ( "s", -1, 3 ),
                    new Among ( "ies", 1, 2 ),
                    new Among ( "sses", 1, 1 ),
                    new Among ( "ss", 1, -1 ),
                    new Among ( "us", 1, -1 )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "", -1, 3 ),
                    new Among ( "bb", 0, 2 ),
                    new Among ( "dd", 0, 2 ),
                    new Among ( "ff", 0, 2 ),
                    new Among ( "gg", 0, 2 ),
                    new Among ( "bl", 0, 1 ),
                    new Among ( "mm", 0, 2 ),
                    new Among ( "nn", 0, 2 ),
                    new Among ( "pp", 0, 2 ),
                    new Among ( "rr", 0, 2 ),
                    new Among ( "at", 0, 1 ),
                    new Among ( "tt", 0, 2 ),
                    new Among ( "iz", 0, 1 )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "ed", -1, 2 ),
                    new Among ( "eed", 0, 1 ),
                    new Among ( "ing", -1, 2 ),
                    new Among ( "edly", -1, 2 ),
                    new Among ( "eedly", 3, 1 ),
                    new Among ( "ingly", -1, 2 )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "anci", -1, 3 ),
                    new Among ( "enci", -1, 2 ),
                    new Among ( "ogi", -1, 13 ),
                    new Among ( "li", -1, 16 ),
                    new Among ( "bli", 3, 12 ),
                    new Among ( "abli", 4, 4 ),
                    new Among ( "alli", 3, 8 ),
                    new Among ( "fulli", 3, 14 ),
                    new Among ( "lessli", 3, 15 ),
                    new Among ( "ousli", 3, 10 ),
                    new Among ( "entli", 3, 5 ),
                    new Among ( "aliti", -1, 8 ),
                    new Among ( "biliti", -1, 12 ),
                    new Among ( "iviti", -1, 11 ),
                    new Among ( "tional", -1, 1 ),
                    new Among ( "ational", 14, 7 ),
                    new Among ( "alism", -1, 8 ),
                    new Among ( "ation", -1, 7 ),
                    new Among ( "ization", 17, 6 ),
                    new Among ( "izer", -1, 6 ),
                    new Among ( "ator", -1, 7 ),
                    new Among ( "iveness", -1, 11 ),
                    new Among ( "fulness", -1, 9 ),
                    new Among ( "ousness", -1, 10 )
                };

        private readonly static Among[] a_6 = {
                    new Among ( "icate", -1, 4 ),
                    new Among ( "ative", -1, 6 ),
                    new Among ( "alize", -1, 3 ),
                    new Among ( "iciti", -1, 4 ),
                    new Among ( "ical", -1, 4 ),
                    new Among ( "tional", -1, 1 ),
                    new Among ( "ational", 5, 2 ),
                    new Among ( "ful", -1, 5 ),
                    new Among ( "ness", -1, 5 )
                };

        private readonly static Among[] a_7 = {
                    new Among ( "ic", -1, 1 ),
                    new Among ( "ance", -1, 1 ),
                    new Among ( "ence", -1, 1 ),
                    new Among ( "able", -1, 1 ),
                    new Among ( "ible", -1, 1 ),
                    new Among ( "ate", -1, 1 ),
                    new Among ( "ive", -1, 1 ),
                    new Among ( "ize", -1, 1 ),
                    new Among ( "iti", -1, 1 ),
                    new Among ( "al", -1, 1 ),
                    new Among ( "ism", -1, 1 ),
                    new Among ( "ion", -1, 2 ),
                    new Among ( "er", -1, 1 ),
                    new Among ( "ous", -1, 1 ),
                    new Among ( "ant", -1, 1 ),
                    new Among ( "ent", -1, 1 ),
                    new Among ( "ment", 15, 1 ),
                    new Among ( "ement", 16, 1 )
                };

        private readonly static Among[] a_8 = {
                    new Among ( "e", -1, 1 ),
                    new Among ( "l", -1, 2 )
                };

        private readonly static Among[] a_9 = {
                    new Among ( "succeed", -1, -1 ),
                    new Among ( "proceed", -1, -1 ),
                    new Among ( "exceed", -1, -1 ),
                    new Among ( "canning", -1, -1 ),
                    new Among ( "inning", -1, -1 ),
                    new Among ( "earring", -1, -1 ),
                    new Among ( "herring", -1, -1 ),
                    new Among ( "outing", -1, -1 )
                };

        private readonly static Among[] a_10 = {
                    new Among ( "andes", -1, -1 ),
                    new Among ( "atlas", -1, -1 ),
                    new Among ( "bias", -1, -1 ),
                    new Among ( "cosmos", -1, -1 ),
                    new Among ( "dying", -1, 3 ),
                    new Among ( "early", -1, 9 ),
                    new Among ( "gently", -1, 7 ),
                    new Among ( "howe", -1, -1 ),
                    new Among ( "idly", -1, 6 ),
                    new Among ( "lying", -1, 4 ),
                    new Among ( "news", -1, -1 ),
                    new Among ( "only", -1, 10 ),
                    new Among ( "singly", -1, 11 ),
                    new Among ( "skies", -1, 2 ),
                    new Among ( "skis", -1, 1 ),
                    new Among ( "sky", -1, -1 ),
                    new Among ( "tying", -1, 5 ),
                    new Among ( "ugly", -1, 8 )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)1 };

        private static readonly char[] g_v_WXY = { (char)1, (char)17, (char)65, (char)208, (char)1 };

        private static readonly char[] g_valid_LI = { (char)55, (char)141, (char)2 };

        private bool B_Y_found;
        private int I_p2;
        private int I_p1;

        private void copy_from(EnglishStemmer other)
        {
            B_Y_found = other.B_Y_found;
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            base.CopyFrom(other);
        }

        private bool r_prelude()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            // (, line 25
            // unset Y_found, line 26
            B_Y_found = false;
            // do, line 27
            v_1 = m_cursor;

            do
            {
                // (, line 27
                // [, line 27
                m_bra = m_cursor;
                // literal, line 27
                if (!(Eq_S(1, "'")))
                {
                    goto lab0;
                }
                // ], line 27
                m_ket = m_cursor;
                // delete, line 27
                SliceDel();
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 28
            v_2 = m_cursor;

            do
            {
                // (, line 28
                // [, line 28
                m_bra = m_cursor;
                // literal, line 28
                if (!(Eq_S(1, "y")))
                {
                    goto lab1;
                }
                // ], line 28
                m_ket = m_cursor;
                // <-, line 28
                SliceFrom("Y");
                // set Y_found, line 28
                B_Y_found = true;
            } while (false);
            lab1:
            m_cursor = v_2;
            // do, line 29
            v_3 = m_cursor;

            do
            {
                // repeat, line 29

                while (true)
                {
                    v_4 = m_cursor;

                    do
                    {
                        // (, line 29
                        // goto, line 29

                        while (true)
                        {
                            v_5 = m_cursor;

                            do
                            {
                                // (, line 29
                                if (!(InGrouping(g_v, 97, 121)))
                                {
                                    goto lab6;
                                }
                                // [, line 29
                                m_bra = m_cursor;
                                // literal, line 29
                                if (!(Eq_S(1, "y")))
                                {
                                    goto lab6;
                                }
                                // ], line 29
                                m_ket = m_cursor;
                                m_cursor = v_5;
                                goto golab5;
                            } while (false);
                            lab6:
                            m_cursor = v_5;
                            if (m_cursor >= m_limit)
                            {
                                goto lab4;
                            }
                            m_cursor++;
                        }
                        golab5:
                        // <-, line 29
                        SliceFrom("Y");
                        // set Y_found, line 29
                        B_Y_found = true;

                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab3;

                        goto end_of_outer_loop;

                    } while (false);
                    lab4:
                    m_cursor = v_4;
                    goto replab3;
                    end_of_outer_loop: { }
                }
                replab3: {/* LUCENENET: intentionally blank */}
            } while (false);
            //lab2: - not referenced
            m_cursor = v_3;
            return true;
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            // (, line 32
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 35
            v_1 = m_cursor;

            do
            {
                // (, line 35
                // or, line 41

                do
                {
                    v_2 = m_cursor;

                    do
                    {
                        // among, line 36
                        if (FindAmong(a_0, 3) == 0)
                        {
                            goto lab2;
                        }
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;
                    // (, line 41
                    // gopast, line 41

                    while (true)
                    {

                        do
                        {
                            if (!(InGrouping(g_v, 97, 121)))
                            {
                                goto lab4;
                            }
                            goto golab3;
                        } while (false);
                        lab4:
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    }
                    golab3:
                    // gopast, line 41

                    while (true)
                    {

                        do
                        {
                            if (!(OutGrouping(g_v, 97, 121)))
                            {
                                goto lab6;
                            }
                            goto golab5;
                        } while (false);
                        lab6:
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    }
                    golab5: {/* LUCENENET: intentionally blank */}
                } while (false);
                lab1:
                // setmark p1, line 42
                I_p1 = m_cursor;
                // gopast, line 43

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 121)))
                        {
                            goto lab8;
                        }
                        goto golab7;
                    } while (false);
                    lab8:
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                }
                golab7:
                // gopast, line 43

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 121)))
                        {
                            goto lab10;
                        }
                        goto golab9;
                    } while (false);
                    lab10:
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                }
                golab9:
                // setmark p2, line 43
                I_p2 = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            return true;
        }

        [ExceptionToNetNumericConvention]
        private bool r_shortv()
        {
            int v_1;
            // (, line 49
            // or, line 51

            do
            {
                v_1 = m_limit - m_cursor;

                do
                {
                    // (, line 50
                    if (!(OutGroupingB(g_v_WXY, 89, 121)))
                    {
                        goto lab1;
                    }
                    if (!(InGroupingB(g_v, 97, 121)))
                    {
                        goto lab1;
                    }
                    if (!(OutGroupingB(g_v, 97, 121)))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_1;
                // (, line 52
                if (!(OutGroupingB(g_v, 97, 121)))
                {
                    return false;
                }
                if (!(InGroupingB(g_v, 97, 121)))
                {
                    return false;
                }
                // atlimit, line 52
                if (m_cursor > m_limit_backward)
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_Step_1a()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 58
            // try, line 59
            v_1 = m_limit - m_cursor;

            do
            {
                // (, line 59
                // [, line 60
                m_ket = m_cursor;
                // substring, line 60
                among_var = FindAmongB(a_1, 3);
                if (among_var == 0)
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // ], line 60
                m_bra = m_cursor;
                switch (among_var)
                {
                    case 0:
                        m_cursor = m_limit - v_1;
                        goto lab0;
                    case 1:
                        // (, line 62
                        // delete, line 62
                        SliceDel();
                        break;
                }
            } while (false);
            lab0:
            // [, line 65
            m_ket = m_cursor;
            // substring, line 65
            among_var = FindAmongB(a_2, 6);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 65
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 66
                    // <-, line 66
                    SliceFrom("ss");
                    break;
                case 2:
                    // (, line 68
                    // or, line 68

                    do
                    {
                        v_2 = m_limit - m_cursor;

                        do
                        {
                            // (, line 68
                            // hop, line 68
                            {
                                int c = m_cursor - 2;
                                if (m_limit_backward > c || c > m_limit)
                                {
                                    goto lab2;
                                }
                                m_cursor = c;
                            }
                            // <-, line 68
                            SliceFrom("i");
                            goto lab1;
                        } while (false);
                        lab2:
                        m_cursor = m_limit - v_2;
                        // <-, line 68
                        SliceFrom("ie");
                    } while (false);
                    lab1:
                    break;
                case 3:
                    // (, line 69
                    // next, line 69
                    if (m_cursor <= m_limit_backward)
                    {
                        return false;
                    }
                    m_cursor--;
                    // gopast, line 69

                    while (true)
                    {

                        do
                        {
                            if (!(InGroupingB(g_v, 97, 121)))
                            {
                                goto lab4;
                            }
                            goto golab3;
                        } while (false);
                        lab4:
                        if (m_cursor <= m_limit_backward)
                        {
                            return false;
                        }
                        m_cursor--;
                    }
                    golab3:
                    // delete, line 69
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_1b()
        {
            int among_var;
            int v_1;
            int v_3;
            int v_4;
            // (, line 74
            // [, line 75
            m_ket = m_cursor;
            // substring, line 75
            among_var = FindAmongB(a_4, 6);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 75
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 77
                    // call R1, line 77
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 77
                    SliceFrom("ee");
                    break;
                case 2:
                    // (, line 79
                    // test, line 80
                    v_1 = m_limit - m_cursor;
                    // gopast, line 80

                    while (true)
                    {

                        do
                        {
                            if (!(InGroupingB(g_v, 97, 121)))
                            {
                                goto lab1;
                            }
                            goto golab0;
                        } while (false);
                        lab1:
                        if (m_cursor <= m_limit_backward)
                        {
                            return false;
                        }
                        m_cursor--;
                    }
                    golab0:
                    m_cursor = m_limit - v_1;
                    // delete, line 80
                    SliceDel();
                    // test, line 81
                    v_3 = m_limit - m_cursor;
                    // substring, line 81
                    among_var = FindAmongB(a_3, 13);
                    if (among_var == 0)
                    {
                        return false;
                    }
                    m_cursor = m_limit - v_3;
                    switch (among_var)
                    {
                        case 0:
                            return false;
                        case 1:
                            // (, line 83
                            // <+, line 83
                            {
                                int c = m_cursor;
                                Insert(m_cursor, m_cursor, "e");
                                m_cursor = c;
                            }
                            break;
                        case 2:
                            // (, line 86
                            // [, line 86
                            m_ket = m_cursor;
                            // next, line 86
                            if (m_cursor <= m_limit_backward)
                            {
                                return false;
                            }
                            m_cursor--;
                            // ], line 86
                            m_bra = m_cursor;
                            // delete, line 86
                            SliceDel();
                            break;
                        case 3:
                            // (, line 87
                            // atmark, line 87
                            if (m_cursor != I_p1)
                            {
                                return false;
                            }
                            // test, line 87
                            v_4 = m_limit - m_cursor;
                            // call shortv, line 87
                            if (!r_shortv())
                            {
                                return false;
                            }
                            m_cursor = m_limit - v_4;
                            // <+, line 87
                            {
                                int c = m_cursor;
                                Insert(m_cursor, m_cursor, "e");
                                m_cursor = c;
                            }
                            break;
                    }
                    break;
            }
            return true;
        }

        private bool r_Step_1c()
        {
            int v_1;
            int v_2;
            // (, line 93
            // [, line 94
            m_ket = m_cursor;
            // or, line 94

            do
            {
                v_1 = m_limit - m_cursor;

                do
                {
                    // literal, line 94
                    if (!(Eq_S_B(1, "y")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_1;
                // literal, line 94
                if (!(Eq_S_B(1, "Y")))
                {
                    return false;
                }
            } while (false);
            lab0:
            // ], line 94
            m_bra = m_cursor;
            if (!(OutGroupingB(g_v, 97, 121)))
            {
                return false;
            }
            // not, line 95
            {
                v_2 = m_limit - m_cursor;

                do
                {
                    // atlimit, line 95
                    if (m_cursor > m_limit_backward)
                    {
                        goto lab2;
                    }
                    return false;
                } while (false);
                lab2:
                m_cursor = m_limit - v_2;
            }
            // <-, line 96
            SliceFrom("i");
            return true;
        }

        private bool r_Step_2()
        {
            int among_var;
            // (, line 99
            // [, line 100
            m_ket = m_cursor;
            // substring, line 100
            among_var = FindAmongB(a_5, 24);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 100
            m_bra = m_cursor;
            // call R1, line 100
            if (!r_R1())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 101
                    // <-, line 101
                    SliceFrom("tion");
                    break;
                case 2:
                    // (, line 102
                    // <-, line 102
                    SliceFrom("ence");
                    break;
                case 3:
                    // (, line 103
                    // <-, line 103
                    SliceFrom("ance");
                    break;
                case 4:
                    // (, line 104
                    // <-, line 104
                    SliceFrom("able");
                    break;
                case 5:
                    // (, line 105
                    // <-, line 105
                    SliceFrom("ent");
                    break;
                case 6:
                    // (, line 107
                    // <-, line 107
                    SliceFrom("ize");
                    break;
                case 7:
                    // (, line 109
                    // <-, line 109
                    SliceFrom("ate");
                    break;
                case 8:
                    // (, line 111
                    // <-, line 111
                    SliceFrom("al");
                    break;
                case 9:
                    // (, line 112
                    // <-, line 112
                    SliceFrom("ful");
                    break;
                case 10:
                    // (, line 114
                    // <-, line 114
                    SliceFrom("ous");
                    break;
                case 11:
                    // (, line 116
                    // <-, line 116
                    SliceFrom("ive");
                    break;
                case 12:
                    // (, line 118
                    // <-, line 118
                    SliceFrom("ble");
                    break;
                case 13:
                    // (, line 119
                    // literal, line 119
                    if (!(Eq_S_B(1, "l")))
                    {
                        return false;
                    }
                    // <-, line 119
                    SliceFrom("og");
                    break;
                case 14:
                    // (, line 120
                    // <-, line 120
                    SliceFrom("ful");
                    break;
                case 15:
                    // (, line 121
                    // <-, line 121
                    SliceFrom("less");
                    break;
                case 16:
                    // (, line 122
                    if (!(InGroupingB(g_valid_LI, 99, 116)))
                    {
                        return false;
                    }
                    // delete, line 122
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_3()
        {
            int among_var;
            // (, line 126
            // [, line 127
            m_ket = m_cursor;
            // substring, line 127
            among_var = FindAmongB(a_6, 9);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 127
            m_bra = m_cursor;
            // call R1, line 127
            if (!r_R1())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 128
                    // <-, line 128
                    SliceFrom("tion");
                    break;
                case 2:
                    // (, line 129
                    // <-, line 129
                    SliceFrom("ate");
                    break;
                case 3:
                    // (, line 130
                    // <-, line 130
                    SliceFrom("al");
                    break;
                case 4:
                    // (, line 132
                    // <-, line 132
                    SliceFrom("ic");
                    break;
                case 5:
                    // (, line 134
                    // delete, line 134
                    SliceDel();
                    break;
                case 6:
                    // (, line 136
                    // call R2, line 136
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 136
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_4()
        {
            int among_var;
            int v_1;
            // (, line 140
            // [, line 141
            m_ket = m_cursor;
            // substring, line 141
            among_var = FindAmongB(a_7, 18);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 141
            m_bra = m_cursor;
            // call R2, line 141
            if (!r_R2())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 144
                    // delete, line 144
                    SliceDel();
                    break;
                case 2:
                    // (, line 145
                    // or, line 145

                    do
                    {
                        v_1 = m_limit - m_cursor;

                        do
                        {
                            // literal, line 145
                            if (!(Eq_S_B(1, "s")))
                            {
                                goto lab1;
                            }
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_1;
                        // literal, line 145
                        if (!(Eq_S_B(1, "t")))
                        {
                            return false;
                        }
                    } while (false);
                    lab0:
                    // delete, line 145
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Step_5()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 149
            // [, line 150
            m_ket = m_cursor;
            // substring, line 150
            among_var = FindAmongB(a_8, 2);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 150
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 151
                    // or, line 151

                    do
                    {
                        v_1 = m_limit - m_cursor;

                        do
                        {
                            // call R2, line 151
                            if (!r_R2())
                            {
                                goto lab1;
                            }
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_1;
                        // (, line 151
                        // call R1, line 151
                        if (!r_R1())
                        {
                            return false;
                        }
                        // not, line 151
                        {
                            v_2 = m_limit - m_cursor;

                            do
                            {
                                // call shortv, line 151
                                if (!r_shortv())
                                {
                                    goto lab2;
                                }
                                return false;
                            } while (false);
                            lab2:
                            m_cursor = m_limit - v_2;
                        }
                    } while (false);
                    lab0:
                    // delete, line 151
                    SliceDel();
                    break;
                case 2:
                    // (, line 152
                    // call R2, line 152
                    if (!r_R2())
                    {
                        return false;
                    }
                    // literal, line 152
                    if (!(Eq_S_B(1, "l")))
                    {
                        return false;
                    }
                    // delete, line 152
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_exception2()
        {
            // (, line 156
            // [, line 158
            m_ket = m_cursor;
            // substring, line 158
            if (FindAmongB(a_9, 8) == 0)
            {
                return false;
            }
            // ], line 158
            m_bra = m_cursor;
            // atlimit, line 158
            if (m_cursor > m_limit_backward)
            {
                return false;
            }
            return true;
        }

        private bool r_exception1()
        {
            int among_var;
            // (, line 168
            // [, line 170
            m_bra = m_cursor;
            // substring, line 170
            among_var = FindAmong(a_10, 18);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 170
            m_ket = m_cursor;
            // atlimit, line 170
            if (m_cursor < m_limit)
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 174
                    // <-, line 174
                    SliceFrom("ski");
                    break;
                case 2:
                    // (, line 175
                    // <-, line 175
                    SliceFrom("sky");
                    break;
                case 3:
                    // (, line 176
                    // <-, line 176
                    SliceFrom("die");
                    break;
                case 4:
                    // (, line 177
                    // <-, line 177
                    SliceFrom("lie");
                    break;
                case 5:
                    // (, line 178
                    // <-, line 178
                    SliceFrom("tie");
                    break;
                case 6:
                    // (, line 182
                    // <-, line 182
                    SliceFrom("idl");
                    break;
                case 7:
                    // (, line 183
                    // <-, line 183
                    SliceFrom("gentl");
                    break;
                case 8:
                    // (, line 184
                    // <-, line 184
                    SliceFrom("ugli");
                    break;
                case 9:
                    // (, line 185
                    // <-, line 185
                    SliceFrom("earli");
                    break;
                case 10:
                    // (, line 186
                    // <-, line 186
                    SliceFrom("onli");
                    break;
                case 11:
                    // (, line 187
                    // <-, line 187
                    SliceFrom("singl");
                    break;
            }
            return true;
        }

        private bool r_postlude()
        {
            int v_1;
            int v_2;
            // (, line 203
            // Boolean test Y_found, line 203
            if (!(B_Y_found))
            {
                return false;
            }
            // repeat, line 203

            while (true)
            {
                v_1 = m_cursor;

                do
                {
                    // (, line 203
                    // goto, line 203

                    while (true)
                    {
                        v_2 = m_cursor;

                        do
                        {
                            // (, line 203
                            // [, line 203
                            m_bra = m_cursor;
                            // literal, line 203
                            if (!(Eq_S(1, "Y")))
                            {
                                goto lab3;
                            }
                            // ], line 203
                            m_ket = m_cursor;
                            m_cursor = v_2;
                            goto golab2;
                        } while (false);
                        lab3:
                        m_cursor = v_2;
                        if (m_cursor >= m_limit)
                        {
                            goto lab1;
                        }
                        m_cursor++;
                    }
                    golab2:
                    // <-, line 203
                    SliceFrom("y");
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;
                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
            int v_12;
            int v_13;
            // (, line 205
            // or, line 207

            do
            {
                v_1 = m_cursor;

                do
                {
                    // call exception1, line 207
                    if (!r_exception1())
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = v_1;

                do
                {
                    // not, line 208
                    {
                        v_2 = m_cursor;

                        do
                        {
                            // hop, line 208
                            {
                                int c = m_cursor + 3;
                                if (0 > c || c > m_limit)
                                {
                                    goto lab3;
                                }
                                m_cursor = c;
                            }
                            goto lab2;
                        } while (false);
                        lab3:
                        m_cursor = v_2;
                    }
                    goto lab0;
                } while (false);
                lab2:
                m_cursor = v_1;
                // (, line 208
                // do, line 209
                v_3 = m_cursor;

                do
                {
                    // call prelude, line 209
                    if (!r_prelude())
                    {
                        goto lab4;
                    }
                } while (false);
                lab4:
                m_cursor = v_3;
                // do, line 210
                v_4 = m_cursor;

                do
                {
                    // call mark_regions, line 210
                    if (!r_mark_regions())
                    {
                        goto lab5;
                    }
                } while (false);
                lab5:
                m_cursor = v_4;
                // backwards, line 211
                m_limit_backward = m_cursor; m_cursor = m_limit;
                // (, line 211
                // do, line 213
                v_5 = m_limit - m_cursor;

                do
                {
                    // call Step_1a, line 213
                    if (!r_Step_1a())
                    {
                        goto lab6;
                    }
                } while (false);
                lab6:
                m_cursor = m_limit - v_5;
                // or, line 215

                do
                {
                    v_6 = m_limit - m_cursor;

                    do
                    {
                        // call exception2, line 215
                        if (!r_exception2())
                        {
                            goto lab8;
                        }
                        goto lab7;
                    } while (false);
                    lab8:
                    m_cursor = m_limit - v_6;
                    // (, line 215
                    // do, line 217
                    v_7 = m_limit - m_cursor;

                    do
                    {
                        // call Step_1b, line 217
                        if (!r_Step_1b())
                        {
                            goto lab9;
                        }
                    } while (false);
                    lab9:
                    m_cursor = m_limit - v_7;
                    // do, line 218
                    v_8 = m_limit - m_cursor;

                    do
                    {
                        // call Step_1c, line 218
                        if (!r_Step_1c())
                        {
                            goto lab10;
                        }
                    } while (false);
                    lab10:
                    m_cursor = m_limit - v_8;
                    // do, line 220
                    v_9 = m_limit - m_cursor;

                    do
                    {
                        // call Step_2, line 220
                        if (!r_Step_2())
                        {
                            goto lab11;
                        }
                    } while (false);
                    lab11:
                    m_cursor = m_limit - v_9;
                    // do, line 221
                    v_10 = m_limit - m_cursor;

                    do
                    {
                        // call Step_3, line 221
                        if (!r_Step_3())
                        {
                            goto lab12;
                        }
                    } while (false);
                    lab12:
                    m_cursor = m_limit - v_10;
                    // do, line 222
                    v_11 = m_limit - m_cursor;

                    do
                    {
                        // call Step_4, line 222
                        if (!r_Step_4())
                        {
                            goto lab13;
                        }
                    } while (false);
                    lab13:
                    m_cursor = m_limit - v_11;
                    // do, line 224
                    v_12 = m_limit - m_cursor;

                    do
                    {
                        // call Step_5, line 224
                        if (!r_Step_5())
                        {
                            goto lab14;
                        }
                    } while (false);
                    lab14:
                    m_cursor = m_limit - v_12;
                } while (false);
                lab7:
                m_cursor = m_limit_backward;                        // do, line 227
                v_13 = m_cursor;

                do
                {
                    // call postlude, line 227
                    if (!r_postlude())
                    {
                        goto lab15;
                    }
                } while (false);
                lab15:
                m_cursor = v_13;
            } while (false);
            lab0:
            return true;
        }

        public override bool Equals(object o)
        {
            return o is EnglishStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}