/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.replicator.IndexInputInputStream;
import org.apache.lucene.replicator.Revision;
import org.apache.lucene.replicator.RevisionFile;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

@Deprecated
public class IndexRevision
implements Revision {
    private static final int RADIX = 16;
    private static final String SOURCE = "index";
    private final IndexWriter writer;
    private final IndexCommit commit;
    private final SnapshotDeletionPolicy sdp;
    private final String version;
    private final Map<String, List<RevisionFile>> sourceFiles;

    private static RevisionFile newRevisionFile(String file, Directory dir) throws IOException {
        RevisionFile revFile = new RevisionFile(file);
        revFile.size = dir.fileLength(file);
        return revFile;
    }

    public static Map<String, List<RevisionFile>> revisionFiles(IndexCommit commit) throws IOException {
        Collection commitFiles = commit.getFileNames();
        ArrayList<RevisionFile> revisionFiles = new ArrayList<RevisionFile>(commitFiles.size());
        String segmentsFile = commit.getSegmentsFileName();
        Directory dir = commit.getDirectory();
        for (String file : commitFiles) {
            if (file.equals(segmentsFile)) continue;
            revisionFiles.add(IndexRevision.newRevisionFile(file, dir));
        }
        revisionFiles.add(IndexRevision.newRevisionFile(segmentsFile, dir));
        return Collections.singletonMap(SOURCE, revisionFiles);
    }

    public static String revisionVersion(IndexCommit commit) {
        return Long.toString(commit.getGeneration(), 16);
    }

    public IndexRevision(IndexWriter writer) throws IOException {
        IndexDeletionPolicy delPolicy = writer.getConfig().getIndexDeletionPolicy();
        if (!(delPolicy instanceof SnapshotDeletionPolicy)) {
            throw new IllegalArgumentException("IndexWriter must be created with SnapshotDeletionPolicy");
        }
        this.writer = writer;
        this.sdp = (SnapshotDeletionPolicy)delPolicy;
        this.commit = this.sdp.snapshot();
        this.version = IndexRevision.revisionVersion(this.commit);
        this.sourceFiles = IndexRevision.revisionFiles(this.commit);
    }

    @Override
    public int compareTo(String version) {
        long gen = Long.parseLong(version, 16);
        long commitGen = this.commit.getGeneration();
        return commitGen < gen ? -1 : (commitGen > gen ? 1 : 0);
    }

    @Override
    public int compareTo(Revision o) {
        IndexRevision other = (IndexRevision)o;
        return this.commit.compareTo(other.commit);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, List<RevisionFile>> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public InputStream open(String source, String fileName) throws IOException {
        assert (source.equals(SOURCE)) : "invalid source; expected=index got=" + source;
        return new IndexInputInputStream(this.commit.getDirectory().openInput(fileName, IOContext.READONCE));
    }

    @Override
    public void release() throws IOException {
        this.sdp.release(this.commit);
        this.writer.deleteUnusedFiles();
    }

    public String toString() {
        return "IndexRevision version=" + this.version + " files=" + String.valueOf(this.sourceFiles);
    }
}

