/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CustomAnalyzerConfig {
    private final String configDir;
    private final ComponentConfig tokenizerConfig;
    private final List<ComponentConfig> charFilterConfigs;
    private final List<ComponentConfig> tokenFilterConfigs;

    private CustomAnalyzerConfig(Builder builder) {
        this.tokenizerConfig = builder.tokenizerConfig;
        this.configDir = builder.configDir;
        this.charFilterConfigs = builder.charFilterConfigs;
        this.tokenFilterConfigs = builder.tokenFilterConfigs;
    }

    Optional<String> getConfigDir() {
        return Optional.ofNullable(this.configDir);
    }

    ComponentConfig getTokenizerConfig() {
        return this.tokenizerConfig;
    }

    List<ComponentConfig> getCharFilterConfigs() {
        return List.copyOf(this.charFilterConfigs);
    }

    List<ComponentConfig> getTokenFilterConfigs() {
        return List.copyOf(this.tokenFilterConfigs);
    }

    public static class Builder {
        private String configDir;
        private final ComponentConfig tokenizerConfig;
        private final List<ComponentConfig> charFilterConfigs = new ArrayList<ComponentConfig>();
        private final List<ComponentConfig> tokenFilterConfigs = new ArrayList<ComponentConfig>();

        public Builder(String name, Map<String, String> tokenizerParams) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(tokenizerParams);
            this.tokenizerConfig = new ComponentConfig(name, new HashMap<String, String>(tokenizerParams));
        }

        public Builder configDir(String val) {
            this.configDir = val;
            return this;
        }

        public Builder addCharFilterConfig(String name, Map<String, String> params) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(params);
            this.charFilterConfigs.add(new ComponentConfig(name, new HashMap<String, String>(params)));
            return this;
        }

        public Builder addTokenFilterConfig(String name, Map<String, String> params) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(params);
            this.tokenFilterConfigs.add(new ComponentConfig(name, new HashMap<String, String>(params)));
            return this;
        }

        public CustomAnalyzerConfig build() {
            return new CustomAnalyzerConfig(this);
        }
    }

    record ComponentConfig(String name, Map<String, String> params) {
        ComponentConfig(String name, Map<String, String> params) {
            this.name = Objects.requireNonNull(name);
            this.params = Objects.requireNonNull(params);
        }
    }
}

