/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingNearestChildrenKnnCollectorManager;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class DiversifyingChildrenFloatKnnVectorQuery
extends KnnFloatVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final BitSetProducer parentsFilter;
    private final Query childFilter;
    private final int k;
    private final float[] query;

    public DiversifyingChildrenFloatKnnVectorQuery(String field, float[] query, Query childFilter, int k, BitSetProducer parentsFilter) {
        this(field, query, childFilter, k, parentsFilter, (KnnSearchStrategy)KnnSearchStrategy.Hnsw.DEFAULT);
    }

    public DiversifyingChildrenFloatKnnVectorQuery(String field, float[] query, Query childFilter, int k, BitSetProducer parentsFilter, KnnSearchStrategy searchStrategy) {
        super(field, query, k, childFilter, searchStrategy);
        this.childFilter = childFilter;
        this.parentsFilter = parentsFilter;
        this.k = k;
        this.query = query;
    }

    protected TopDocs exactSearch(LeafReaderContext context, DocIdSetIterator acceptIterator, QueryTimeout queryTimeout) throws IOException {
        FloatVectorValues floatVectorValues = context.reader().getFloatVectorValues(this.field);
        if (floatVectorValues == null) {
            FloatVectorValues.checkField((LeafReader)context.reader(), (String)this.field);
            return NO_RESULTS;
        }
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return NO_RESULTS;
        }
        VectorScorer floatVectorScorer = floatVectorValues.scorer(this.query);
        if (floatVectorScorer == null) {
            return NO_RESULTS;
        }
        DiversifyingChildrenVectorScorer vectorScorer = new DiversifyingChildrenVectorScorer(acceptIterator, parentBitSet, floatVectorScorer);
        int queueSize = Math.min(this.k, Math.toIntExact(acceptIterator.cost()));
        HitQueue queue = new HitQueue(queueSize, true);
        TotalHits.Relation relation = TotalHits.Relation.EQUAL_TO;
        ScoreDoc topDoc = (ScoreDoc)queue.top();
        while (vectorScorer.nextParent() != Integer.MAX_VALUE) {
            if (queryTimeout != null && queryTimeout.shouldExit()) {
                relation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                break;
            }
            float score = vectorScorer.score();
            if (!(score > topDoc.score)) continue;
            topDoc.score = score;
            topDoc.doc = vectorScorer.bestChild();
            topDoc = (ScoreDoc)queue.updateTop();
        }
        while (queue.size() > 0 && ((ScoreDoc)queue.top()).score < 0.0f) {
            queue.pop();
        }
        ScoreDoc[] topScoreDocs = new ScoreDoc[queue.size()];
        for (int i = topScoreDocs.length - 1; i >= 0; --i) {
            topScoreDocs[i] = (ScoreDoc)queue.pop();
        }
        TotalHits totalHits = new TotalHits(acceptIterator.cost(), relation);
        return new TopDocs(totalHits, topScoreDocs);
    }

    protected KnnCollectorManager getKnnCollectorManager(int k, IndexSearcher searcher) {
        return new DiversifyingNearestChildrenKnnCollectorManager(k, this.parentsFilter, searcher);
    }

    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        FloatVectorValues.checkField((LeafReader)context.reader(), (String)this.field);
        KnnCollector collector = knnCollectorManager.newCollector(visitedLimit, this.searchStrategy, context);
        if (collector == null) {
            return NO_RESULTS;
        }
        context.reader().searchNearestVectors(this.field, this.query, collector, acceptDocs);
        return collector.topDocs();
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Object)((Object)this)).getClass().getSimpleName() + ":");
        buffer.append(this.field + "[" + this.query[0] + ",...]");
        buffer.append("[" + this.k + "]");
        if (this.filter != null) {
            buffer.append("[" + String.valueOf(this.filter) + "]");
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiversifyingChildrenFloatKnnVectorQuery that = (DiversifyingChildrenFloatKnnVectorQuery)((Object)o);
        return this.k == that.k && Objects.equals(this.parentsFilter, that.parentsFilter) && Objects.equals(this.childFilter, that.childFilter) && Arrays.equals(this.query, that.query);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.parentsFilter, this.childFilter, this.k);
        result = 31 * result + Arrays.hashCode(this.query);
        return result;
    }

    static class DiversifyingChildrenVectorScorer {
        private final VectorScorer vectorScorer;
        private final DocIdSetIterator vectorIterator;
        private final DocIdSetIterator acceptedChildrenIterator;
        private final BitSet parentBitSet;
        private int currentParent = -1;
        private int bestChild = -1;
        private float currentScore = Float.NEGATIVE_INFINITY;

        protected DiversifyingChildrenVectorScorer(DocIdSetIterator acceptedChildrenIterator, BitSet parentBitSet, VectorScorer vectorScorer) {
            this.acceptedChildrenIterator = acceptedChildrenIterator;
            this.vectorScorer = vectorScorer;
            this.vectorIterator = vectorScorer.iterator();
            this.parentBitSet = parentBitSet;
        }

        public int bestChild() {
            return this.bestChild;
        }

        public int nextParent() throws IOException {
            int nextChild = this.acceptedChildrenIterator.docID();
            if (nextChild == -1) {
                nextChild = this.acceptedChildrenIterator.nextDoc();
            }
            if (nextChild == Integer.MAX_VALUE) {
                this.currentParent = Integer.MAX_VALUE;
                return this.currentParent;
            }
            this.currentScore = Float.NEGATIVE_INFINITY;
            this.currentParent = this.parentBitSet.nextSetBit(nextChild);
            do {
                this.vectorIterator.advance(nextChild);
                float score = this.vectorScorer.score();
                if (!(score > this.currentScore)) continue;
                this.bestChild = nextChild;
                this.currentScore = score;
            } while ((nextChild = this.acceptedChildrenIterator.nextDoc()) != Integer.MAX_VALUE && nextChild < this.currentParent);
            return this.currentParent;
        }

        public float score() throws IOException {
            return this.currentScore;
        }
    }
}

