/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.docgen.processor.AsciiDocData;
import org.apache.logging.log4j.docgen.processor.internal.CellImpl;
import org.apache.logging.log4j.docgen.processor.internal.ListImpl;
import org.apache.logging.log4j.docgen.processor.internal.ListItemImpl;
import org.apache.logging.log4j.docgen.processor.internal.RowImpl;
import org.apache.logging.log4j.docgen.processor.internal.TableImpl;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.jspecify.annotations.Nullable;

abstract class AbstractAsciiDocTreeVisitor
extends SimpleDocTreeVisitor<Void, AsciiDocData> {
    private static final String JAVA_SOURCE_STYLE = "source,java";
    private static final String XML_SOURCE_STYLE = "source,xml";
    private static final String CODE_DELIM = "`";
    private static final String EMPHASIS_DELIM = "_";
    private static final String STRONG_EMPHASIS_DELIM = "*";
    private static final String SPACE = " ";
    private static final Pattern XML_TAG = Pattern.compile("<\\w+\\s*(\\w+=[\"'][^\"']*[\"']\\s*)*/?>");

    AbstractAsciiDocTreeVisitor() {
    }

    @Override
    public Void visitStartElement(StartElementTree node, AsciiDocData data) {
        String elementName;
        switch (elementName = node.getName().toString()) {
            case "p": {
                data.newParagraph();
                break;
            }
            case "ol": {
                if (data.getCurrentNode() instanceof ListItem) {
                    data.newParagraph();
                }
                data.pushChildNode(ListImpl::new).setContext("olist");
                break;
            }
            case "ul": {
                if (data.getCurrentNode() instanceof ListItem) {
                    data.newParagraph();
                }
                data.pushChildNode(ListImpl::new).setContext("ulist");
                break;
            }
            case "li": {
                if (!(data.getCurrentNode() instanceof org.asciidoctor.ast.List)) {
                    throw new IllegalArgumentException("A <li> tag must be a child of a <ol> or <ul> tag.");
                }
                data.pushChildNode(ListItemImpl::new);
                break;
            }
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h6": {
                StructuralNode currentNode;
                data.newParagraph();
                while ((currentNode = data.getCurrentNode()) != null && !(currentNode instanceof Section) && !(currentNode instanceof Document)) {
                    data.popNode();
                }
                break;
            }
            case "table": {
                data.pushChildNode(TableImpl::new);
                break;
            }
            case "tr": {
                break;
            }
            case "th": {
                data.pushChildNode(CellImpl::new).setContext("header");
                break;
            }
            case "td": {
                data.pushChildNode(CellImpl::new);
                break;
            }
            case "pre": {
                data.newParagraph();
                data.getCurrentParagraph().setContext("listing");
                break;
            }
            case "code": 
            case "em": 
            case "i": 
            case "strong": 
            case "b": {
                data.newTextSpan();
                break;
            }
        }
        return (Void)super.visitStartElement(node, data);
    }

    @Override
    public Void visitEndElement(EndElementTree node, AsciiDocData data) {
        String elementName;
        switch (elementName = node.getName().toString()) {
            case "p": {
                break;
            }
            case "ol": 
            case "ul": 
            case "li": 
            case "table": 
            case "td": {
                data.popNode();
                break;
            }
            case "th": {
                data.popNode().setContext("header");
                break;
            }
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h6": {
                if (!StringUtils.isEmpty((CharSequence)data.getCurrentLine())) {
                    data.newLine();
                }
                Block currentParagraph = data.getCurrentParagraph();
                String title = StringUtils.normalizeSpace((String)currentParagraph.convert());
                currentParagraph.setLines(new ArrayList());
                int newLevel = "h1".equals(elementName) ? 2 : elementName.charAt(1) - 48;
                data.setCurrentSectionLevel(newLevel);
                data.getCurrentNode().setTitle(title);
                break;
            }
            case "pre": {
                Block codeBlock = data.newParagraph();
                List lines = codeBlock.getLines();
                int commonIndentSize = Integer.MAX_VALUE;
                for (String line : lines) {
                    int firstNotSpace = StringUtils.indexOfAnyBut((CharSequence)line, (CharSequence)SPACE);
                    if (0 > firstNotSpace || firstNotSpace >= commonIndentSize) continue;
                    commonIndentSize = firstNotSpace;
                }
                boolean isXml = XML_TAG.matcher(String.join((CharSequence)SPACE, lines)).find();
                ArrayList<String> newLines = new ArrayList<String>(lines.size());
                for (String line : lines) {
                    newLines.add(StringUtils.substring((String)line, (int)commonIndentSize));
                }
                codeBlock.setLines(newLines);
                codeBlock.setStyle(isXml ? XML_SOURCE_STYLE : JAVA_SOURCE_STYLE);
                break;
            }
            case "tr": {
                Table table = (Table)data.getCurrentNode();
                List cells = table.getBlocks();
                int idx = 0;
                for (Row row : table.getBody()) {
                    idx += row.getCells().size();
                }
                RowImpl row = new RowImpl();
                for (int i = idx; i < table.getBlocks().size(); ++i) {
                    StructuralNode cell = (StructuralNode)cells.get(i);
                    if (!(cell instanceof Cell)) continue;
                    row.getCells().add((Cell)cell);
                }
                table.getBody().add(row);
                break;
            }
            case "code": {
                this.appendSpan(data, CODE_DELIM);
                break;
            }
            case "em": 
            case "i": {
                this.appendSpan(data, EMPHASIS_DELIM);
                break;
            }
            case "strong": 
            case "b": {
                this.appendSpan(data, STRONG_EMPHASIS_DELIM);
                break;
            }
        }
        return (Void)super.visitEndElement(node, data);
    }

    @Override
    public Void visitLink(LinkTree node, AsciiDocData data) {
        String referenceSignature = AbstractAsciiDocTreeVisitor.getReferenceSignature(node.getReference(), data);
        String referenceLabel = AbstractAsciiDocTreeVisitor.linkLabelToAsciiDoc(node);
        data.appendAdjustingSpace(" apiref:").append(referenceSignature).append("[").append(referenceLabel).append("]");
        return (Void)super.visitLink(node, data);
    }

    private static String getReferenceSignature(ReferenceTree referenceTree, AsciiDocData data) {
        String methodSignature;
        String classSignature;
        String referenceSignature = referenceTree.getSignature();
        if (referenceSignature.startsWith("#")) {
            return data.qualifiedClassName + referenceSignature;
        }
        int methodSplitterIndex = referenceSignature.indexOf(35);
        if (methodSplitterIndex > 0) {
            classSignature = referenceSignature.substring(0, methodSplitterIndex);
            methodSignature = referenceSignature.substring(methodSplitterIndex).replaceAll(" +", "");
        } else {
            classSignature = referenceSignature;
            methodSignature = "";
        }
        @Nullable String importedClassFqcn = (String)data.imports.get(classSignature);
        if (importedClassFqcn != null) {
            return importedClassFqcn + methodSignature;
        }
        try {
            String qualifiedClassName = "java.lang." + classSignature;
            Class.forName(qualifiedClassName);
            return qualifiedClassName + methodSignature;
        }
        catch (ClassNotFoundException qualifiedClassName) {
            String packageName = data.qualifiedClassName.substring(0, data.qualifiedClassName.lastIndexOf(46));
            boolean alreadyQualified = classSignature.startsWith(packageName);
            return alreadyQualified ? referenceSignature : packageName + "." + classSignature + methodSignature;
        }
    }

    private static String linkLabelToAsciiDoc(LinkTree node) {
        int[] labelTokenIndex = new int[]{0};
        return node.getLabel().stream().map(labelToken -> {
            if (!(labelToken instanceof TextTree)) {
                String message = String.format("Non-text labels in links are not allowed! That is, `{@link foo.bar.Baz awesome thing}` is allowed, whereas {@link foo.bar.Baz {@code doh}}` is not. While visiting link `%s`, label token at index %d found to be of unexpected type: `%s`", node, labelTokenIndex[0], labelToken.getClass().getCanonicalName());
                throw new IllegalArgumentException(message);
            }
            labelTokenIndex[0] = labelTokenIndex[0] + 1;
            TextTree textLabel = (TextTree)labelToken;
            return textLabel.getBody();
        }).collect(Collectors.joining(SPACE));
    }

    @Override
    public Void visitLiteral(LiteralTree node, AsciiDocData data) {
        if (node.getKind() == DocTree.Kind.CODE) {
            data.newTextSpan();
            node.getBody().accept(this, data);
            this.appendSpan(data, CODE_DELIM);
        } else {
            node.getBody().accept(this, data);
        }
        return (Void)super.visitLiteral(node, data);
    }

    @Override
    public Void visitEntity(EntityTree node, AsciiDocData asciiDocData) {
        String text;
        switch (node.getName().toString()) {
            case "amp": {
                text = "&";
                break;
            }
            case "apos": {
                text = "'";
                break;
            }
            case "gt": {
                text = ">";
                break;
            }
            case "lt": {
                text = "<";
                break;
            }
            case "quot": {
                text = "\"";
                break;
            }
            default: {
                text = null;
            }
        }
        if (text != null) {
            asciiDocData.append(text);
        }
        return (Void)super.visitEntity(node, asciiDocData);
    }

    @Override
    public Void visitText(TextTree node, AsciiDocData data) {
        Block currentParagraph = data.getCurrentParagraph();
        if ("paragraph".equals(currentParagraph.getContext())) {
            AbstractAsciiDocTreeVisitor.appendSentences(node.getBody(), data);
        } else {
            data.append(node.getBody());
        }
        return (Void)super.visitText(node, data);
    }

    private static void appendSentences(String text, AsciiDocData data) {
        String[] sentences = text.split("(?<=\\w{2}[.!?])", -1);
        for (int i = 0; i < sentences.length - 1; ++i) {
            data.appendAdjustingSpace(sentences[i]).newLine();
        }
        data.appendAdjustingSpace(sentences[sentences.length - 1]);
    }

    private void appendSpan(AsciiDocData data, String delimiter) {
        String body = data.popTextSpan();
        data.append(delimiter);
        boolean needsEscaping = body.contains(delimiter);
        if (needsEscaping) {
            data.append("++").append(body).append("++");
        } else {
            data.append(body);
        }
        data.append(delimiter);
    }
}

