/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.changelog.util.StringUtils;
import org.apache.logging.log4j.changelog.util.XmlUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlWriter {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String CHARSET_NAME = CHARSET.name();
    private static final String LS = System.lineSeparator();

    private XmlWriter() {
    }

    public static void toFile(Path filepath, String rootElementName, BiConsumer<Document, Element> documentConsumer) {
        try {
            String xml = XmlWriter.toString(rootElementName, documentConsumer);
            byte[] xmlBytes = xml.getBytes(CHARSET);
            Path filepathParent = filepath.getParent();
            if (filepathParent != null) {
                Files.createDirectories(filepathParent, new FileAttribute[0]);
            }
            Files.write(filepath, xmlBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception error) {
            String message = String.format("failed writing XML to file `%s`", filepath);
            throw new RuntimeException(message, error);
        }
    }

    public static String toString(String rootElementName, BiConsumer<Document, Element> documentConsumer) {
        try {
            DocumentBuilderFactory documentBuilderFactory = XmlUtils.createDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlStandalone(true);
            Comment licenseComment = document.createComment(LS + "  ~ Licensed to the Apache Software Foundation (ASF) under one or more" + LS + "  ~ contributor license agreements.  See the NOTICE file distributed with" + LS + "  ~ this work for additional information regarding copyright ownership." + LS + "  ~ The ASF licenses this file to you under the Apache License, Version 2.0" + LS + "  ~ (the \"License\"); you may not use this file except in compliance with" + LS + "  ~ the License.  You may obtain a copy of the License at" + LS + "  ~" + LS + "  ~      http://www.apache.org/licenses/LICENSE-2.0" + LS + "  ~" + LS + "  ~ Unless required by applicable law or agreed to in writing, software" + LS + "  ~ distributed under the License is distributed on an \"AS IS\" BASIS," + LS + "  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied." + LS + "  ~ See the License for the specific language governing permissions and" + LS + "  ~ limitations under the License." + LS + "  ");
            document.appendChild(licenseComment);
            Element rootElement = document.createElement(rootElementName);
            document.appendChild(rootElement);
            documentConsumer.accept(document, rootElement);
            return XmlWriter.serializeXmlDocument(document, rootElementName);
        }
        catch (Exception error) {
            throw new RuntimeException("failed writing XML", error);
        }
    }

    @SuppressFBWarnings(value={"XXE_DTD_TRANSFORM_FACTORY", "XXE_XSLT_TRANSFORM_FACTORY"})
    private static String serializeXmlDocument(Document document, String rootElementName) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", CHARSET_NAME);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, result);
        String xml = result.getWriter().toString();
        String padding = StringUtils.repeat(" ", rootElementName.length() + 2);
        return xml.replace("?><!--", "?>" + LS + "<!--").replace("--><", "-->" + LS + "<").replaceFirst('<' + rootElementName + " (.+>" + LS + ")", '<' + rootElementName + " xmlns=\"" + "https://logging.apache.org/xml/ns" + "\"" + LS + padding + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + LS + padding + "xsi:schemaLocation=\"" + "https://logging.apache.org/xml/ns" + " " + "https://logging.apache.org/xml/ns/log4j-changelog-0.xsd" + "\"" + LS + padding + "$1");
    }
}

