/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.asciidoctor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.generator.internal.ArtifactSourcedType;
import org.apache.logging.log4j.docgen.generator.internal.TypeLookup;
import org.apache.logging.log4j.docgen.io.stax.PluginBundleStaxReader;
import org.apache.logging.log4j.tools.internal.freemarker.util.FreeMarkerUtils;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.Format;
import org.asciidoctor.extension.FormatType;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.Name;
import org.asciidoctor.extension.PositionalAttributes;
import org.jspecify.annotations.Nullable;

@Name(value="apiref")
@Format(value=FormatType.LONG)
@PositionalAttributes(value={"label"})
public final class ApirefMacro
extends InlineMacroProcessor {
    private static final Logger LOGGER = Logger.getLogger(ApirefMacro.class.getName());
    private static final String IMPOSSIBLE_REGEX = "(?!.*)";
    private TypeLookup lookup;
    private String typeTargetTemplate;
    private boolean packageNameStripped;
    private boolean initialized = false;

    public PhraseNode process(StructuralNode parent, String target, Map<String, Object> attributes) {
        this.initialize(parent);
        return this.createPhraseNode(parent, target, attributes);
    }

    private PhraseNode createPhraseNode(StructuralNode parent, String target, Map<String, Object> attributes) {
        int methodSplitterIndex = target.indexOf(35);
        boolean methodProvided = methodSplitterIndex > 0;
        String className = methodProvided ? target.substring(0, methodSplitterIndex) : target;
        @Nullable String label = (String)attributes.get("label");
        @Nullable ArtifactSourcedType sourcedType = (ArtifactSourcedType)this.lookup.get((Object)className);
        if (sourcedType != null) {
            HashMap<String, String> nodeOptions = new HashMap<String, String>();
            nodeOptions.put("type", ":xref");
            nodeOptions.put("target", this.createTypeTemplateTargetPath(sourcedType));
            String effectiveLabel = label != null ? label : className.substring(className.lastIndexOf(46) + 1);
            return this.createPhraseNode((ContentNode)parent, "anchor", effectiveLabel, attributes, nodeOptions);
        }
        if (label != null) {
            return this.createPhraseNode((ContentNode)parent, "quoted", "<em>" + label + "</em>", attributes);
        }
        String effectiveLabel = this.packageNameStripped ? target.replaceFirst("^([a-z][a-z0-9_]*\\.)*", "") : target;
        return this.createPhraseNode((ContentNode)parent, "quoted", "<code>" + effectiveLabel + "</code>", attributes);
    }

    private String createTypeTemplateTargetPath(ArtifactSourcedType sourcedType) {
        Map<String, ArtifactSourcedType> templateData = Collections.singletonMap("sourcedType", sourcedType);
        return FreeMarkerUtils.renderString((String)this.typeTargetTemplate, templateData);
    }

    private static String or(@Nullable String value, String fallback) {
        return value != null ? value : fallback;
    }

    private void initialize(StructuralNode node) {
        if (!this.initialized) {
            LOGGER.fine("Initializing...");
            this.lookup = this.createTypeLookup(node);
            Map documentAttributes = node.getDocument().getAttributes();
            this.typeTargetTemplate = ApirefMacro.getStringAttribute(documentAttributes, ApirefMacro.attributeName("type-target-template"), null);
            this.packageNameStripped = ApirefMacro.isBooleanAttributeProvided(documentAttributes, ApirefMacro.attributeName("package-name-stripped"));
            this.initialized = true;
            LOGGER.fine("Initialized.");
        }
    }

    private TypeLookup createTypeLookup(StructuralNode node) {
        Set<PluginSet> pluginSets = this.loadDescriptors(node);
        Map documentAttributes = node.getDocument().getAttributes();
        Pattern includePattern = ApirefMacro.getPatternAttribute(documentAttributes, ApirefMacro.attributeName("type-filter-include-pattern"), ".*");
        Pattern excludePattern = ApirefMacro.getPatternAttribute(documentAttributes, ApirefMacro.attributeName("type-filter-exclude-pattern"), IMPOSSIBLE_REGEX);
        LOGGER.log(Level.FINE, "Creating type lookup using `%s` and `%s` patterns for inclusion and exclusion, respectively...", new Object[]{includePattern, excludePattern});
        Predicate<String> classNameFilter = className -> includePattern.matcher((CharSequence)className).matches() && !excludePattern.matcher((CharSequence)className).matches();
        return TypeLookup.of(pluginSets, classNameFilter);
    }

    private Set<PluginSet> loadDescriptors(StructuralNode node) {
        Map documentAttributes = node.getDocument().getAttributes();
        String directory = ApirefMacro.getStringAttribute(documentAttributes, ApirefMacro.attributeName("descriptor-directory"), null);
        String pathMatcher = ApirefMacro.getStringAttribute(documentAttributes, ApirefMacro.attributeName("descriptor-path-matcher"), "glob:**/*.xml");
        boolean dotFilesIncluded = ApirefMacro.isBooleanAttributeProvided(documentAttributes, ApirefMacro.attributeName("descriptor-dot-files-included"));
        LOGGER.log(Level.FINE, "Loading descriptors matching `{}` pattern in `{}`... (Dot files will be {})", new Object[]{pathMatcher, directory, dotFilesIncluded ? "included!" : "ignored."});
        Set<PluginSet> pluginSets = this.loadDescriptors(directory, pathMatcher, dotFilesIncluded);
        LOGGER.log(Level.FINE, "Loaded {} descriptors in total.", pluginSets.size());
        return pluginSets;
    }

    private static String attributeName(String key) {
        String attributeName = "log4j-docgen-" + key;
        if (key.matches(".*[^a-z-]+.*")) {
            String message = String.format("Found invalid attribute name: `%s`.%n`node.getDocument().getAttributes()` lower cases all attribute names and replaces symbols with dashes.%nHence, you should use kebab-case attribute names.", attributeName);
            throw new IllegalArgumentException(message);
        }
        return attributeName;
    }

    private static Pattern getPatternAttribute(Map<String, Object> documentAttributes, String key, String defaultValue) {
        String regex = ApirefMacro.getStringAttribute(documentAttributes, key, defaultValue);
        try {
            return Pattern.compile(regex);
        }
        catch (Exception error) {
            String message = String.format("failed compiling the regex pattern `%s` provided in attribute `%s`", regex, key);
            throw new IllegalArgumentException(message, error);
        }
    }

    private static boolean isBooleanAttributeProvided(Map<String, Object> documentAttributes, String key) {
        return documentAttributes.containsKey(key);
    }

    private static String getStringAttribute(Map<String, Object> documentAttributes, String key, @Nullable String defaultValue) {
        String textValue;
        Object value = documentAttributes.get(key);
        if (!(value instanceof String) || (textValue = ((String)value).trim()).isEmpty()) {
            if (defaultValue == null) {
                String message = String.format("blank or missing attribute: `%s`", key);
                throw new IllegalArgumentException(message);
            }
            return defaultValue;
        }
        return textValue;
    }

    private Set<PluginSet> loadDescriptors(String directory, String pathPattern, boolean dotFilesIncluded) {
        LinkedHashSet<PluginSet> pluginSets = new LinkedHashSet<PluginSet>();
        PluginBundleStaxReader pluginSetReader = new PluginBundleStaxReader();
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(pathPattern);
        try (Stream<Path> paths = Files.walk(Paths.get(directory, new String[0]), new FileVisitOption[0]);){
            paths.forEach(path -> {
                PluginSet pluginSet;
                boolean dotFile;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                boolean bl = dotFile = !dotFilesIncluded && path.getFileName().toString().startsWith(".");
                if (dotFile) {
                    return;
                }
                boolean matched = pathMatcher.matches((Path)path);
                if (!matched) {
                    return;
                }
                try {
                    pluginSet = pluginSetReader.read(path.toString());
                }
                catch (Exception error) {
                    String message = String.format("failed reading descriptor: `%s`", path);
                    throw new RuntimeException(message, error);
                }
                pluginSets.add(pluginSet);
                LOGGER.log(Level.FINE, "Loaded descriptor at `{}`.", new Object[]{path});
            });
        }
        catch (IOException error) {
            String message = String.format("failed reading descriptors from directory: `%s`", directory);
            throw new UncheckedIOException(message, error);
        }
        return pluginSets;
    }
}

