/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.logging.log4j.catalog.api.util;

/**
 *
 */
public final class StringUtils {

    private StringUtils() {
    }

    public static final boolean isBlank(String value) {
        return value == null || value.length() == 0;
    }

    public static void appendNewline(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append("\n");
        }
    }
}
