/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.rest;

import java.text.DecimalFormat;

public class ElapsedUtil {
    private static long NANO_PER_SECOND = 1000000000L;
    private static long NANO_PER_MINUTE = NANO_PER_SECOND * 60L;
    private static long NANO_PER_HOUR = NANO_PER_MINUTE * 60L;

    static void addElapsed(long elapsed, StringBuilder msg) {
        long nanoseconds = elapsed;
        long hours = nanoseconds / NANO_PER_HOUR;
        long minutes = (nanoseconds %= NANO_PER_HOUR) / NANO_PER_MINUTE;
        long seconds = (nanoseconds %= NANO_PER_MINUTE) / NANO_PER_SECOND;
        nanoseconds %= NANO_PER_SECOND;
        if (hours > 0L) {
            msg.append(hours).append(" hours ");
        }
        if (minutes > 0L || hours > 0L) {
            msg.append(minutes).append(" minutes ");
        }
        DecimalFormat numFormat = null;
        numFormat = new DecimalFormat("#0");
        msg.append(numFormat.format(seconds)).append('.');
        numFormat = new DecimalFormat("000000000");
        msg.append(numFormat.format(nanoseconds)).append(" seconds");
    }
}

