/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.catalog;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.audit.catalog.CatalogManager;
import org.apache.logging.log4j.audit.exception.AuditException;
import org.apache.logging.log4j.audit.util.NamingUtils;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.CatalogData;
import org.apache.logging.log4j.catalog.api.CatalogReader;
import org.apache.logging.log4j.catalog.api.Event;
import org.apache.logging.log4j.catalog.api.EventAttribute;

public class CatalogManagerImpl
implements CatalogManager {
    private static Logger logger = LogManager.getLogger(CatalogManagerImpl.class);
    private volatile Map<String, Map<String, CatalogInfo>> infoMap;
    private Map<String, Attribute> requestContextAttributes = new HashMap<String, Attribute>();
    protected final Map<String, Map<String, Attribute>> attributeMap = new ConcurrentHashMap<String, Map<String, Attribute>>();
    private static final String REQCTX = "ReqCtx_";
    protected CatalogData catalogData;

    public CatalogManagerImpl(CatalogReader catalogReader) {
        try {
            this.infoMap = this.initializeData(catalogReader);
        }
        catch (Exception ex) {
            throw new AuditException("Unable to initialize catalog data", ex);
        }
    }

    protected Map<String, Map<String, CatalogInfo>> getInfoMap() {
        return this.infoMap;
    }

    @Override
    public Event getEvent(String eventName, String catalogId) {
        CatalogInfo info = this.getCatalogInfo(eventName, catalogId);
        return info != null ? info.event : null;
    }

    @Override
    public List<String> getRequiredContextAttributes(String eventName, String catalogId) {
        Map<String, CatalogInfo> catalogMap = this.infoMap.get(catalogId == null ? "DEFAULT" : catalogId);
        return catalogMap != null ? catalogMap.get(eventName).requiredContextAttributes : null;
    }

    @Override
    public Map<String, Attribute> getAttributes(String eventName, String catalogId) {
        Event event = this.getEvent(eventName, catalogId);
        if (event == null) {
            logger.warn("The event named {} could not be found in catalog {}", (Object)eventName, (Object)catalogId);
            return null;
        }
        List eventAttributes = event.getAttributes() == null ? Collections.emptyList() : event.getAttributes();
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>(eventAttributes.size());
        for (EventAttribute eventAttribute : eventAttributes) {
            Attribute attr = this.getAttribute(eventAttribute.getName(), event.getCatalogId());
            if (attr == null) continue;
            attributes.put(attr.getName(), attr);
        }
        return attributes;
    }

    @Override
    public List<String> getAttributeNames(String eventName, String catalogId) {
        return this.infoMap.get(catalogId == null ? "DEFAULT" : catalogId).get(eventName).attributeNames;
    }

    @Override
    public Attribute getAttribute(String name) {
        Map<String, Attribute> attrMap = this.attributeMap.get("DEFAULT");
        return attrMap != null ? attrMap.get(name) : null;
    }

    @Override
    public Attribute getAttribute(String name, String catalogId) {
        Map<String, Attribute> attrMap = this.attributeMap.get(catalogId);
        if (attrMap == null || !attrMap.containsKey(name)) {
            attrMap = this.attributeMap.get("DEFAULT");
        }
        return attrMap != null ? attrMap.get(name) : null;
    }

    @Override
    public Map<String, Attribute> getRequestContextAttributes() {
        return this.requestContextAttributes;
    }

    private CatalogInfo getCatalogInfo(String eventName, String catalogId) {
        Map<String, CatalogInfo> defaultCatalog = this.infoMap.get("DEFAULT");
        Map<String, CatalogInfo> catalog = catalogId != null ? this.infoMap.get(catalogId) : null;
        return catalog != null && catalog.containsKey(eventName) ? catalog.get(eventName) : defaultCatalog.get(eventName);
    }

    private Map<String, Map<String, CatalogInfo>> initializeData(CatalogReader catalogReader) throws Exception {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper mapper = new ObjectMapper(factory);
        String catalog = catalogReader.readCatalog();
        this.catalogData = (CatalogData)mapper.readValue(catalog, CatalogData.class);
        if (this.catalogData.getAttributes() != null) {
            for (Attribute attr : this.catalogData.getAttributes()) {
                Map<String, Attribute> attrMap;
                if (attr.isRequestContext()) {
                    this.requestContextAttributes.put(attr.getName(), attr);
                }
                if ((attrMap = this.attributeMap.get(attr.getCatalogId())) == null) {
                    attrMap = new HashMap<String, Attribute>();
                    this.attributeMap.put(attr.getCatalogId(), attrMap);
                }
                attrMap.put(attr.getName(), attr);
            }
        }
        HashMap<String, Map<String, CatalogInfo>> map = new HashMap<String, Map<String, CatalogInfo>>();
        map.put("DEFAULT", new HashMap());
        for (Event event : this.catalogData.getEvents()) {
            this.addEntry(map, event);
        }
        return map;
    }

    protected void addEntry(Map<String, Map<String, CatalogInfo>> map, Event event) {
        CatalogInfo info = new CatalogInfo();
        info.event = event;
        String catalogId = event.getCatalogId();
        if (catalogId != null && catalogId.length() > 0 && !map.containsKey(catalogId)) {
            map.put(catalogId, new HashMap());
        }
        ArrayList<String> required = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        info.attributes = new HashMap(names.size());
        if (event.getAttributes() != null) {
            for (EventAttribute eventAttribute : event.getAttributes()) {
                String name = eventAttribute.getName();
                Attribute attribute = this.getAttribute(name, event.getCatalogId());
                if (attribute != null) {
                    info.attributes.put(name, attribute);
                    if (name.indexOf(46) != -1) {
                        name = name.replaceAll("\\.", "");
                    }
                    if (name.indexOf(47) != -1) {
                        name = name.replaceAll("/", "");
                    }
                    if (attribute.isRequestContext()) {
                        if (!attribute.isRequired()) continue;
                        if (name.startsWith(REQCTX)) {
                            name = name.substring(REQCTX.length());
                        }
                        required.add(name);
                        continue;
                    }
                    names.add(name);
                    continue;
                }
                throw new IllegalStateException("Attribute " + name + " is not defined");
            }
        }
        info.requiredContextAttributes = required;
        info.attributeNames = names;
        Map<String, CatalogInfo> catalogMap = catalogId == null ? map.get("DEFAULT") : map.get(catalogId);
        catalogMap.put(NamingUtils.getFieldName(event.getName()), info);
    }

    protected class CatalogInfo {
        private Event event;
        private List<String> requiredContextAttributes;
        private List<String> attributeNames;
        private Map<String, Attribute> attributes;

        protected CatalogInfo() {
        }
    }
}

