/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.cs.persistence.conf;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class PersistenceConfTest {

  @Test
  @DisplayName("constTest")
  public void constTest() {

    String tuningClassValue = PersistenceConf.TUNING_CLASS.getValue();
    String tuningMethodValue = PersistenceConf.TUNING_METHOD.getValue();
    Boolean packageHeaderValue =
        PersistenceConf.ENABLE_CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue();
    String csDeserializeReplacePackageHeaderValue =
        PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue();
    String csidPackageHeader = PersistenceConf.CSID_PACKAGE_HEADER;

    Assertions.assertNotNull(tuningClassValue);
    Assertions.assertNotNull(tuningMethodValue);
    Assertions.assertTrue(packageHeaderValue.booleanValue());
    Assertions.assertNotNull(csDeserializeReplacePackageHeaderValue);
    Assertions.assertNotNull(csidPackageHeader);
  }
}
