/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication.ldap;

import java.io.Serializable;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.config.OptionalConfigEntry;
import org.apache.kyuubi.service.ServiceUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

public final class LdapUtils$
implements Logging {
    public static final LdapUtils$ MODULE$ = new LdapUtils$();
    private static transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public String extractBaseDn(String dn) {
        int indexOfFirstDelimiter = dn.indexOf(",");
        if (indexOfFirstDelimiter > -1) {
            return dn.substring(indexOfFirstDelimiter + 1);
        }
        return null;
    }

    public String extractFirstRdn(String dn) {
        return dn.substring(0, dn.indexOf(","));
    }

    public String extractUserName(String userDn) {
        if (!this.isDn(userDn) && !this.hasDomain(userDn)) {
            return userDn;
        }
        int domainIdx = ServiceUtils$.MODULE$.indexOfDomainMatch(userDn);
        if (domainIdx > 0) {
            return userDn.substring(0, domainIdx);
        }
        if (userDn.contains("=")) {
            return userDn.substring(userDn.indexOf("=") + 1, userDn.indexOf(","));
        }
        return userDn;
    }

    public String getShortName(String rdn) {
        return rdn.split(",")[0].split("=")[1];
    }

    public boolean hasDomain(String userName) {
        return ServiceUtils$.MODULE$.indexOfDomainMatch(userName) > 0;
    }

    public String getUserName(String user) {
        return this.hasDomain(user) ? this.extractUserName(user) : user;
    }

    public boolean isDn(String name) {
        return name.contains("=");
    }

    public String[] parseDnPatterns(KyuubiConf conf, OptionalConfigEntry<String> confKey) {
        ArrayBuffer result = new ArrayBuffer();
        ((Option)conf.get(confKey)).map((Function1 & Serializable)patternsString -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])patternsString.split(":")), (Function1 & Serializable)pattern -> {
                BoxedUnit boxedUnit;
                if (pattern.contains(",") && pattern.contains("=")) {
                    boxedUnit = result$1.$plus$eq(pattern);
                } else {
                    LdapUtils$.MODULE$.warn((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(33).append("Unexpected format for ").append(confKey$1).append(", ignoring ").append((String)pattern).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            return BoxedUnit.UNIT;
        }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String guidAttr = conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GUID_KEY());
            ((Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_BASE_DN())).foreach((Function1 & Serializable)defaultBaseDn -> (ArrayBuffer)result.$plus$eq((Object)new StringBuilder(4).append(guidAttr).append("=%s,").append((String)defaultBaseDn).toString()));
        });
        return (String[])result.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String patternToBaseDn(String pattern) {
        return pattern.contains("=%s") ? pattern.split(",", 2)[1] : pattern;
    }

    public String[] patternsToBaseDns(String[] patterns) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])patterns), (Function1 & Serializable)pattern -> MODULE$.patternToBaseDn((String)pattern), ClassTag$.MODULE$.apply(String.class));
    }

    public String[] createCandidatePrincipals(KyuubiConf conf, String user) {
        String[] stringArray;
        Object object = new Object();
        try {
            if (this.hasDomain(user) || this.isDn(user)) {
                return (String[])((Object[])new String[]{user});
            }
            stringArray = (String[])((Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_DOMAIN())).map((Function1 & Serializable)ldapDomain -> (String[])((Object[])new String[]{new StringBuilder(1).append(user).append("@").append((String)ldapDomain).toString()})).getOrElse((Function0 & Serializable)() -> {
                String[] userPatterns = MODULE$.parseDnPatterns(conf, KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_USER_DN_PATTERN());
                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])userPatterns))) {
                    throw new NonLocalReturnControl(object, (Object)new String[]{user});
                }
                return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])userPatterns), (Function1 & Serializable)x$1 -> x$1.replaceAll("%s", user), ClassTag$.MODULE$.apply(String.class));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                stringArray = (String[])ex.value();
            }
            throw ex;
        }
        return stringArray;
    }

    private LdapUtils$() {
    }
}

