/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.session;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.engine.spark.events.SessionEvent;
import org.apache.kyuubi.engine.spark.events.SessionEvent$;
import org.apache.kyuubi.engine.spark.operation.SparkSQLOperationManager;
import org.apache.kyuubi.engine.spark.udf.KDFRegistry$;
import org.apache.kyuubi.engine.spark.util.SparkCatalogUtils$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoType;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.ui.SparkUIUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\r\u001a\u0001\u0019B\u0011\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u001e\t\u0013q\u0002!\u0011!Q\u0001\nuR\u0005\"C&\u0001\u0005\u0003\u0005\u000b\u0011B\u001fM\u0011%i\u0005A!A!\u0002\u0013id\nC\u0005P\u0001\t\u0005\t\u0015!\u0003Q'\"IA\u000b\u0001B\u0001B\u0003%Q\u000b\u0017\u0005\t9\u0001\u0011)\u0019!C\u00013\"A\u0011\r\u0001B\u0001B\u0003%!\fC\u0003c\u0001\u0011\u00051\rC\u0004n\u0001\t\u0007I\u0011\t8\t\rI\u0004\u0001\u0015!\u0003p\u0011\u001d\u0019\bA1A\u0005\nQDq!a\u0001\u0001A\u0003%Q\u000f\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003u\u0011\u001d\t9\u0001\u0001Q\u0001\nUDq!!\u0003\u0001\t\u0013\tY\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002 !A\u0011Q\u0006\u0001!\u0002\u0013\t\t\u0003C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005M\u0002\u0001\"\u0015\u00026!9\u00111\n\u0001\u0005B\u00055\u0003bBA0\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003C\u0002A\u0011AA2\u0005A\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00136\u0004HN\u0003\u0002\u001b7\u000591/Z:tS>t'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004f]\u001eLg.\u001a\u0006\u0003A\u0005\naa[=vk\nL'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001FK\u0007\u0002S)\u0011!dH\u0005\u0003W%\u0012q\"\u00112tiJ\f7\r^*fgNLwN\\\u0001\taJ|Go\\2pYB\u0011a&O\u0007\u0002_)\u0011\u0001'M\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005I\u001a\u0014a\u0001:qG*\u0011A'N\u0001\bg\u0016\u0014h/[2f\u0015\t1t'\u0001\u0003iSZ,'B\u0001\u001d \u0003\u0019\u0019\b.\u00193fI&\u0011!h\f\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:L!\u0001\f\u0016\u0002\tU\u001cXM\u001d\t\u0003}\u001ds!aP#\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t+\u0013A\u0002\u001fs_>$hHC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$D\u0013\ta$&\u0001\u0005qCN\u001cxo\u001c:e\u0013\tY%&A\u0005ja\u0006#GM]3tg&\u0011QJK\u0001\u0005G>tg\r\u0005\u0003?#vj\u0014B\u0001*J\u0005\ri\u0015\r]\u0005\u0003\u001f*\nab]3tg&|g.T1oC\u001e,'\u000f\u0005\u0002)-&\u0011q+\u000b\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0013\t!&&F\u0001[!\tYv,D\u0001]\u0015\tif,A\u0002tc2T!\u0001H\u0011\n\u0005\u0001d&\u0001D*qCJ\\7+Z:tS>t\u0017AB:qCJ\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\tI\u001a<\u0007.\u001b6lYB\u0011Q\rA\u0007\u00023!)A&\u0003a\u0001[!)A(\u0003a\u0001{!)1*\u0003a\u0001{!)Q*\u0003a\u0001{!)q*\u0003a\u0001!\")A+\u0003a\u0001+\")A$\u0003a\u00015\u00061\u0001.\u00198eY\u0016,\u0012a\u001c\t\u0003QAL!!]\u0015\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0003\u001dA\u0017M\u001c3mK\u0002\nab]3tg&|gNU;o)&lW-F\u0001v!\t1x0D\u0001x\u0015\tA\u00180\u0001\u0004bi>l\u0017n\u0019\u0006\u0003un\f!bY8oGV\u0014(/\u001a8u\u0015\taX0\u0001\u0003vi&d'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u00039(AC!u_6L7\rT8oO\u0006y1/Z:tS>t'+\u001e8US6,\u0007%\u0001\btKN\u001c\u0018n\u001c8DaV$\u0016.\\3\u0002\u001fM,7o]5p]\u000e\u0003X\u000fV5nK\u0002\n1c]3u\u001b>$\u0017NZ5bE2,7i\u001c8gS\u001e$b!!\u0004\u0002\u0016\u0005e\u0001\u0003BA\b\u0003#i\u0011aQ\u0005\u0004\u0003'\u0019%\u0001B+oSRDa!a\u0006\u0011\u0001\u0004i\u0014aA6fs\"1\u00111\u0004\tA\u0002u\nQA^1mk\u0016\fAb]3tg&|g.\u0012<f]R,\"!!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n\u001c\u0003\u0019)g/\u001a8ug&!\u00111FA\u0013\u00051\u0019Vm]:j_:,e/\u001a8u\u00035\u0019Xm]:j_:,e/\u001a8uA\u0005!q\u000e]3o)\t\ti!\u0001\u0007sk:|\u0005/\u001a:bi&|g\u000e\u0006\u0003\u00028\u0005\r\u0003\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ur$A\u0005pa\u0016\u0014\u0018\r^5p]&!\u0011\u0011IA\u001e\u0005=y\u0005/\u001a:bi&|g\u000eS1oI2,\u0007bBA\u001f)\u0001\u0007\u0011Q\t\t\u0005\u0003s\t9%\u0003\u0003\u0002J\u0005m\"!C(qKJ\fG/[8o\u0003\u001d9W\r^%oM>$B!a\u0014\u0002VA\u0019a&!\u0015\n\u0007\u0005MsFA\u0007U\u000f\u0016$\u0018J\u001c4p-\u0006dW/\u001a\u0005\b\u0003/*\u0002\u0019AA-\u0003!IgNZ8UsB,\u0007c\u0001\u0018\u0002\\%\u0019\u0011QL\u0018\u0003\u0019Q;U\r^%oM>$\u0016\u0010]3\u0002\u000b\rdwn]3\u0002+%t7M]3bg\u0016\u0014VO\\!oI\u000e\u0003X\u000fV5nKR1\u0011QBA3\u0003_Bq!a\u001a\u0018\u0001\u0004\tI'A\u0004sk:$\u0016.\\3\u0011\t\u0005=\u00111N\u0005\u0004\u0003[\u001a%\u0001\u0002'p]\u001eDq!!\u001d\u0018\u0001\u0004\tI'A\u0004daV$\u0016.\\3")
public class SparkSessionImpl
extends AbstractSession {
    private final SparkSession spark;
    private final SessionHandle handle;
    private final AtomicLong sessionRunTime;
    private final AtomicLong sessionCpuTime;
    private final SessionEvent sessionEvent;

    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public SessionHandle handle() {
        return this.handle;
    }

    private AtomicLong sessionRunTime() {
        return this.sessionRunTime;
    }

    private AtomicLong sessionCpuTime() {
        return this.sessionCpuTime;
    }

    private void setModifiableConfig(String key, String value) {
        try {
            this.spark().conf().set(key, value);
        }
        catch (AnalysisException e) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> e.getMessage());
        }
    }

    private SessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    @Override
    public void open() {
        Tuple2 tuple2 = this.normalizedConf().partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkSessionImpl.$anonfun$open$1(x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map useCatalogAndDatabaseConf = (Map)tuple2._1();
        Map otherConf = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)useCatalogAndDatabaseConf, (Object)otherConf);
        Tuple2 tuple23 = tuple22;
        Map useCatalogAndDatabaseConf2 = (Map)tuple23._1();
        Map otherConf2 = (Map)tuple23._2();
        useCatalogAndDatabaseConf2.get((Object)package$.MODULE$.USE_CATALOG()).foreach((Function1 & Serializable)catalog -> {
            SparkSessionImpl.$anonfun$open$2(this, catalog);
            return BoxedUnit.UNIT;
        });
        useCatalogAndDatabaseConf2.get((Object)"use:database").foreach((Function1 & Serializable)database -> {
            SparkSessionImpl.$anonfun$open$4(this, database);
            return BoxedUnit.UNIT;
        });
        otherConf2.foreach((Function1 & Serializable)x0$2 -> {
            SparkSessionImpl.$anonfun$open$5(this, x0$2);
            return BoxedUnit.UNIT;
        });
        KDFRegistry$.MODULE$.registerAll(this.spark());
        EventBus$.MODULE$.post(this.sessionEvent());
        super.open();
    }

    @Override
    public OperationHandle runOperation(Operation operation) {
        this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        return super.runOperation(operation);
    }

    @Override
    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable)() -> {
            TGetInfoValue tGetInfoValue;
            TGetInfoType tGetInfoType = infoType;
            boolean bl = TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType);
            if (bl) {
                tGetInfoValue = TGetInfoValue.stringValue("Spark SQL");
            } else if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                tGetInfoValue = TGetInfoValue.stringValue(org.apache.spark.package$.MODULE$.SPARK_VERSION());
            } else if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                tGetInfoValue = TGetInfoValue.stringValue("Unimplemented");
            } else {
                boolean bl2 = TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType) ? true : (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType) ? true : TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType));
                if (bl2) {
                    tGetInfoValue = TGetInfoValue.lenValue(128L);
                } else {
                    throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
            }
            return tGetInfoValue;
        });
    }

    @Override
    public void close() {
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(12).append("sessionId=").append(this.sessionEvent().sessionId()).append(", ").toString()).append(new StringBuilder(17).append("sessionRunTime=").append(SparkUIUtils$.MODULE$.formatDuration(this.sessionRunTime().get())).append(", ").toString()).append(new StringBuilder(15).append("sessionCpuTime=").append(SparkUIUtils$.MODULE$.formatDuration(this.sessionCpuTime().get() / 1000000L)).toString()).toString());
        this.sessionEvent().endTime_$eq(System.currentTimeMillis());
        this.sessionEvent().sessionRunTime_$eq(this.sessionRunTime().get());
        this.sessionEvent().sessionCpuTime_$eq(this.sessionCpuTime().get());
        EventBus$.MODULE$.post(this.sessionEvent());
        super.close();
        this.spark().sessionState().catalog().getTempViewNames().foreach((Function1 & Serializable)tableName -> {
            SparkSessionImpl.$anonfun$close$2(this, tableName);
            return BoxedUnit.UNIT;
        });
        ((SparkSQLOperationManager)super.sessionManager().operationManager()).closeILoop(this.handle());
        ((SparkSQLOperationManager)super.sessionManager().operationManager()).closePythonProcess(this.handle());
    }

    public void increaseRunAndCpuTime(long runTime, long cpuTime) {
        this.sessionEvent().sessionRunTime_$eq(this.sessionRunTime().addAndGet(runTime));
        this.sessionEvent().sessionCpuTime_$eq(this.sessionCpuTime().addAndGet(cpuTime));
    }

    public static final /* synthetic */ boolean $anonfun$open$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{package$.MODULE$.USE_CATALOG(), package$.MODULE$.USE_DATABASE()}), (Object)k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$open$2(SparkSessionImpl $this, String catalog) {
        try {
            SparkCatalogUtils$.MODULE$.setCurrentCatalog($this.spark(), catalog);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2.getMessage().contains("Cannot find catalog plugin class for catalog")) {
                $this.warn((Function0<Object>)(Function0 & Serializable)() -> throwable2.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$open$4(SparkSessionImpl $this, String database) {
        try {
            $this.spark().sessionState().catalogManager().setCurrentNamespace((String[])((Object[])new String[]{database}));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            String string = database;
            String string2 = "default";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (StringUtils.containsAny((CharSequence)throwable2.getMessage(), (CharSequence[])new CharSequence[]{"not found", "SCHEMA_NOT_FOUND", "is not authorized to perform: glue:GetDatabase"})) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$open$5(SparkSessionImpl $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.setModifiableConfig(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$close$2(SparkSessionImpl $this, String tableName) {
        $this.spark().catalog().uncacheTable(tableName);
    }

    public SparkSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf, SessionManager sessionManager, SparkSession spark) {
        this.spark = spark;
        super(protocol, user, password, ipAddress, conf, sessionManager);
        this.handle = (SessionHandle)super.conf().get((Object)"kyuubi.session.handle").map((Function1 & Serializable)uuid -> SessionHandle$.MODULE$.fromUUID((String)uuid)).getOrElse((Function0 & Serializable)() -> SessionHandle$.MODULE$.apply());
        this.sessionRunTime = new AtomicLong(0L);
        this.sessionCpuTime = new AtomicLong(0L);
        this.sessionEvent = SessionEvent$.MODULE$.apply(this);
    }
}

