/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AHSProxy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AHSProxy.class);

    public static <T> T createAHSProxy(Configuration conf, Class<T> protocol, InetSocketAddress ahsAddress) throws IOException {
        LOG.info("Connecting to Application History server at " + ahsAddress);
        return AHSProxy.getProxy(conf, protocol, ahsAddress);
    }

    protected static <T> T getProxy(final Configuration conf, final Class<T> protocol, final InetSocketAddress rmAddress) throws IOException {
        return UserGroupInformation.getCurrentUser().doAs(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return YarnRPC.create(conf).getProxy(protocol, rmAddress, conf);
            }
        });
    }
}

