/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common;

import java.net.HttpCookie;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class UpgradeRequestAdapter
implements UpgradeRequest {
    private URI requestURI;
    private List<String> subProtocols = new ArrayList<String>(1);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>(1);
    private List<HttpCookie> cookies = new ArrayList<HttpCookie>(1);
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>(1);
    private Object session;
    private String httpVersion;
    private String method;
    private String host;
    private boolean secure;

    protected UpgradeRequestAdapter() {
    }

    public UpgradeRequestAdapter(String requestURI) {
        this(URI.create(requestURI));
    }

    public UpgradeRequestAdapter(URI requestURI) {
        this.setRequestURI(requestURI);
    }

    @Override
    public void addExtensions(ExtensionConfig ... configs) {
        Collections.addAll(this.extensions, configs);
    }

    @Override
    public void addExtensions(String ... configs) {
        for (String config : configs) {
            this.extensions.add(ExtensionConfig.parse(config));
        }
    }

    @Override
    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        int size = values.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return values.get(0);
        }
        boolean needsDelim = false;
        StringBuilder ret = new StringBuilder();
        for (String value : values) {
            if (needsDelim) {
                ret.append(", ");
            }
            QuoteUtil.quoteIfNeeded(ret, value, "\"'\\\n\r\t\f\b%+ ;=");
            needsDelim = true;
        }
        return ret.toString();
    }

    @Override
    public int getHeaderInt(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return -1;
        }
        int size = values.size();
        if (size <= 0) {
            return -1;
        }
        if (size == 1) {
            return Integer.parseInt(values.get(0));
        }
        throw new NumberFormatException("Cannot convert multi-value header into int");
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getOrigin() {
        return this.getHeader("Origin");
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getProtocolVersion() {
        String version = this.getHeader("Sec-WebSocket-Version");
        if (version == null) {
            return "13";
        }
        return version;
    }

    @Override
    public String getQueryString() {
        return this.requestURI.getQuery();
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public Object getSession() {
        return this.session;
    }

    @Override
    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public boolean hasSubProtocol(String test) {
        for (String protocol : this.subProtocols) {
            if (!protocol.equalsIgnoreCase(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOrigin(String test) {
        return test.equalsIgnoreCase(this.getOrigin());
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setCookies(List<HttpCookie> cookies) {
        this.cookies.clear();
        if (cookies != null && !cookies.isEmpty()) {
            this.cookies.addAll(cookies);
        }
    }

    @Override
    public void setExtensions(List<ExtensionConfig> configs) {
        this.extensions.clear();
        if (configs != null) {
            this.extensions.addAll(configs);
        }
    }

    @Override
    public void setHeader(String name, List<String> values) {
        this.headers.put(name, values);
    }

    @Override
    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setHeader(name, values);
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.clearHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            this.setHeader(name, values);
        }
    }

    @Override
    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    protected void setParameterMap(Map<String, List<String>> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    @Override
    public void setRequestURI(URI uri) {
        this.requestURI = uri;
        String scheme = uri.getScheme();
        if ("ws".equalsIgnoreCase(scheme)) {
            this.secure = false;
        } else if ("wss".equalsIgnoreCase(scheme)) {
            this.secure = true;
        } else {
            throw new IllegalArgumentException("URI scheme must be 'ws' or 'wss'");
        }
        this.host = this.requestURI.getHost();
        this.parameters.clear();
    }

    @Override
    public void setSession(Object session) {
        this.session = session;
    }

    @Override
    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols.clear();
        if (subProtocols != null) {
            this.subProtocols.addAll(subProtocols);
        }
    }

    @Override
    public void setSubProtocols(String ... protocols) {
        this.subProtocols.clear();
        Collections.addAll(this.subProtocols, protocols);
    }
}

