/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.fliptables;

public final class FlipTable {
    private static final String EMPTY = "(empty)";
    private final String[] headers;
    private final String[][] data;
    private final int columns;
    private final int[] columnWidths;
    private final int emptyWidth;

    public static String of(String[] headers, String[][] data) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        if (headers.length == 0) {
            throw new IllegalArgumentException("Headers must not be empty.");
        }
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        return new FlipTable(headers, data).toString();
    }

    private FlipTable(String[] headers, String[][] data) {
        this.headers = headers;
        this.data = data;
        this.columns = headers.length;
        this.columnWidths = new int[this.columns];
        for (int row = -1; row < data.length; ++row) {
            String[] rowData;
            String[] stringArray = rowData = row == -1 ? headers : data[row];
            if (rowData.length != this.columns) {
                throw new IllegalArgumentException(String.format("Row %s's %s columns != %s columns", row + 1, rowData.length, this.columns));
            }
            for (int column = 0; column < this.columns; ++column) {
                for (String rowDataLine : rowData[column].split("\\n")) {
                    this.columnWidths[column] = Math.max(this.columnWidths[column], rowDataLine.length());
                }
            }
        }
        int emptyWidth = 3 * (this.columns - 1);
        for (int columnWidth : this.columnWidths) {
            emptyWidth += columnWidth;
        }
        this.emptyWidth = emptyWidth;
        if (emptyWidth < EMPTY.length()) {
            int n = this.columns - 1;
            this.columnWidths[n] = this.columnWidths[n] + (EMPTY.length() - emptyWidth);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.printDivider(builder, "\u2554\u2550\u2564\u2550\u2557");
        this.printData(builder, this.headers);
        if (this.data.length == 0) {
            this.printDivider(builder, "\u2560\u2550\u2567\u2550\u2563");
            builder.append('\u2551').append(FlipTable.pad(this.emptyWidth, EMPTY)).append("\u2551\n");
            this.printDivider(builder, "\u255a\u2550\u2550\u2550\u255d");
        } else {
            for (int row = 0; row < this.data.length; ++row) {
                this.printDivider(builder, row == 0 ? "\u2560\u2550\u256a\u2550\u2563" : "\u255f\u2500\u253c\u2500\u2562");
                this.printData(builder, this.data[row]);
            }
            this.printDivider(builder, "\u255a\u2550\u2567\u2550\u255d");
        }
        return builder.toString();
    }

    private void printDivider(StringBuilder out, String format) {
        for (int column = 0; column < this.columns; ++column) {
            out.append(column == 0 ? format.charAt(0) : format.charAt(2));
            out.append(FlipTable.pad(this.columnWidths[column], "").replace(' ', format.charAt(1)));
        }
        out.append(format.charAt(4)).append('\n');
    }

    private void printData(StringBuilder out, String[] data) {
        int lines = 1;
        for (int line = 0; line < lines; ++line) {
            for (int column = 0; column < this.columns; ++column) {
                out.append(column == 0 ? (char)'\u2551' : '\u2502');
                String[] cellLines = data[column].split("\\n");
                lines = Math.max(lines, cellLines.length);
                String cellLine = line < cellLines.length ? cellLines[line] : "";
                out.append(FlipTable.pad(this.columnWidths[column], cellLine));
            }
            out.append("\u2551\n");
        }
    }

    private static String pad(int width, String data) {
        return String.format(" %1$-" + width + "s ", data);
    }
}

